<?php
/*	
 * The default authority setting value given by a new user of WordPress
*/
function get_default_capabillities(){
	global $xoops_db;
	$db_option = get_wp_prefix() . 'options';
	return $xoops_db->get_var("SELECT option_value FROM $db_option WHERE option_name = 'default_role'");
}

/*
 * Get The level from the capabillities name.
 */
function get_role_level($capabillities){
	if ($capabillities == 'default') $capabillities = get_default_capabillities();
	switch($capabillities) {
		case 'administrator':
			return 5;
		case 'editor':
			return 4;
		case 'author':
			return 3;
		case 'contributor':
			return 2;
		case 'subscriber':
			return 1;
		default:
			return 0;
	}
}

/*
 * The highest authority and the accompanying data
 * in the WordPress authority given to the group to which the user belongs are obtained. 
*/
function get_xoops_group_role($uid=0){
	$ans = array();
	if ($uid == 0){
		return '';
	}
	
	global $xoops_db;
	$db_groups_users_link = get_xoops_prefix() . 'groups_users_link';
	$db_group_role = get_wp_prefix() . 'group_role';
	$db_groups = get_xoops_prefix() . 'groups';
	
	$sql  = "SELECT * ";
	$sql .= "FROM $db_groups_users_link ";
	$sql .= "LEFT JOIN $db_group_role ON $db_groups_users_link.groupid = $db_group_role.groupid ";
	$sql .= "LEFT JOIN $db_groups ON $db_groups_users_link.groupid = $db_groups.groupid ";
	$sql .= "WHERE  uid = $uid";
	$user_groups = $xoops_db->get_results($sql);
	$ans['capabillities'] = '';
	$ans['allway_update'] = 0;
	
	foreach($user_groups as $user_group){
		if ($user_group->group_type == 'Admin'){
			$ans['capabillities'] = 'administrator';
			$ans['allway_update'] = 0;
			break;
		}
		$before_level = get_role_level($ans['capabillities']);
		
		$now_level = get_role_level($user_group->role);
		if ($now_level > $before_level){
			$ans['capabillities'] = $user_group->role;
			$ans['allway_update'] = $user_group->login_all;
		}
	}
	return $ans;
}
	
/*
 * Get User ID of WordPress from the login name. 
*/
function get_wp_user_id($login_name){
	global $xoops_db;
	$sql = "SELECT ID FROM " . get_wp_prefix() . "users WHERE user_login = '$login_name'";
	$uid = $xoops_db->get_var($sql);
	return $uid;
}

/*
 * The user data of XOOPS is written in the WordPress user data. 
 * If $sync_uid is 0, all users are written. 
*/
function user_sync_to_wordpress($sync_uid = 0, &$message){
	global $xoops_db;

	$db_xoops_users = get_xoops_prefix() . 'users';
	$db_xpress_users = get_wp_prefix() . 'users';

	$message = 'Do Sync';

	if ($sync_uid == 0) {
		$xu_sql  = "SELECT uid ,name ,uname ,pass ,email, url, user_regdate, user_aim, user_yim FROM $db_xoops_users";
	} else {
		$xu_sql  = "SELECT uid ,name ,uname ,pass ,email, url, user_regdate, user_aim, user_yim FROM $db_xoops_users WHERE uid = $sync_uid";
	}

	$xoops_users = $xoops_db->get_results($xu_sql);
	
	if (empty($xoops_users)){
		$message .= '...ERR ('. $xu_sql . ')';
		return false;
	}

	foreach($xoops_users as $xoops_user){
		$role = get_xoops_group_role($xoops_user->uid);
		$capabillities_name = $role['capabillities'];
		$allway_update = $role['allway_update'];
		
		$wp_user_id = get_wp_user_id($xoops_user->uname) ;
		
		if (empty($capabillities_name)){
			if ($sync_uid != 0){
				if ($wp_user_id) {
					if ($allway_update){
						$message .= '...NOT XPRESS USER ' . $xoops_user->uname;
						return false;
					}
				} else {
					$message .= '...NOT XPRESS USER ' . $xoops_user->uname;
					return false;
				}
			} else {
				$message .= "...PASS '" . $xoops_user->uname ."'[uid=".$xoops_user->uid ."](not xpress user)";
				continue;
			}
		}

		$user_regist_time = date('Y-m-d H:i:s' , $xoops_user->user_regdate);
		$user_status = 0;
		$user_display_name =empty($xoops_user->name) ? $xoops_user->uname :$xoops_user->name ;

		$is_update = false;
		
		if ($wp_user_id){
			$wu_sql  = 	"UPDATE $db_xpress_users ";
			$wu_sql .= 	'SET ';
			$wu_sql .=		"user_pass  = '$xoops_user->pass', ";
			$wu_sql .=		"user_email = '$xoops_user->email', ";
			$wu_sql .=		"user_url = '$xoops_user->url', ";
			$wu_sql .=		"user_nicename = '$xoops_user->uname', ";
			$wu_sql .=		"user_registered = '$user_regist_time', ";
			$wu_sql .=		"user_status = 0 ";
			$wu_sql .=	"WHERE (user_login = '$xoops_user->uname' )";

			$xoops_db->query($wu_sql);
			if ($allway_update){
				$sycc_user = new WP_User($wp_user_id);
				$sycc_user->set_role($capabillities_name);
				$message .= '...UPDATE ' . $xoops_user->uname . '(' . $capabillities_name . ')';

			} else {
				$message .= '...UPDATE ' . $xoops_user->uname . '(Level Not Change)';
			}
			if (!check_user_meta_prefix($wp_user_id)){
				repair_user_meta_prefix();
			}

			$is_update = true;
		}else{
			$wu_sql  =	"INSERT INTO $db_xpress_users ";
			$wu_sql .=  	"(user_login , user_pass ,user_email , user_url , user_nicename " ;
			$wu_sql .=		" , user_registered , user_status , display_name) ";
			$wu_sql .=	"VALUES ";
			$wu_sql .=		"('$xoops_user->uname', '$xoops_user->pass', '$xoops_user->email', '$xoops_user->url', '$xoops_user->uname' ";
			$wu_sql .=		" , '$user_regist_time', $user_status, '$user_display_name')";
			$xoops_db->query($wu_sql);
//					$wp_user_id = get_wp_user_id($user_login_name) ;					
			$wp_user_id = mysql_insert_id();
			$sycc_user = new WP_User($wp_user_id);
			$sycc_user->set_role($capabillities_name);						
			$message .= '...INSERT ' . $user_login_name . '(' . $capabillities_name . ')';
		}
		
		$user_nickname =	empty($xoops_user->name) ? $xoops_user->uname :$xoops_user->name ;
		$user_rich_editing = 'true';
		$user_first_name = 	$xoops_user->uname;
		$user_last_name = 	'';
		$user_description = '';
		$user_jabber = 		'';

		update_usermeta( $wp_user_id,'nickname',$user_nickname);
		update_usermeta( $wp_user_id,'first_name',$user_first_name);
		update_usermeta( $wp_user_id,'last_name',$user_last_name);
		update_usermeta( $wp_user_id,'description',$user_description);
		update_usermeta( $wp_user_id,'jabber',$user_jabber);
		update_usermeta( $wp_user_id,'aim',$xoops_user->user_aim);
		update_usermeta( $wp_user_id,'yim',$xoops_user->user_yim);
		if ($is_update === false ) {
			update_usermeta( $wp_user_id,'rich_editing',$user_rich_editing);
		} 
					
	}
	$message .= "...END";
	return true;
}

/*
 * Get User ID of XOOPS from the login name. 
*/
function get_xoops_user_id($login_name){
	global $xoops_db;
	$sql = "SELECT uid FROM " . get_xoops_prefix() . "users WHERE uname = '$login_name'";
	$uid = $xoops_db->get_var($sql);
	return $uid;	
}

/*
 *The user data of wordpress is written in the xoops user data. 
*/
function user_sync_to_xoops($user_ID){
	global $xoops_db;
	
	$user_info = get_userdata($user_ID);
	$xoops_uid = get_xoops_user_id($user_info->user_login);
	$db_xoops_users = get_xoops_prefix() . "users";
	$user_regdate  = strtotime($user_info->user_registered);
	$aim = get_usermeta($user_ID,'aim');
	$yim = get_usermeta($user_ID,'yim');	
	
	if ($xoops_uid){
		$wu_sql  = 	"UPDATE $db_xoops_users ";
		$wu_sql .= 	'SET ';
		$wu_sql .=		"uname  = '$user_info->user_login', ";
		$wu_sql .=		"pass = '$user_info->user_pass', ";
		$wu_sql .=		"email = '$user_info->user_email', ";
		$wu_sql .=		"url = '$user_info->user_url', ";
		$wu_sql .=		"name = '$user_info->display_name', ";
		$wu_sql .=		"user_aim = '$aim', ";
		$wu_sql .=		"user_yim = '$yim', ";
		$wu_sql .=		"user_regdate = $user_regdate ";
		$wu_sql .=	"WHERE (uid = $xoops_uid )";
		$xoops_db->query($wu_sql);
	}else{
		$wu_sql  =	"INSERT INTO $db_xoops_users ";
		$wu_sql .=  	"(uname , pass ,email , url , name , user_aim , user_yim , user_regdate) " ;
		$wu_sql .=	"VALUES ";
		$wu_sql .=		"('$user_info->user_login', '$user_info->user_pass', '$user_info->user_email', '$user_info->user_url', '$user_info->display_name' ";
		$wu_sql .=		" , '$aim' , '$yim' , $user_regdate )";
		$xoops_db->query($wu_sql);
		// get xoops users default groupe ID
		$db_xoops_group = get_xoops_prefix() . 'groups';
		$default_xoops_group_id = $xoops_db->get_var("SELECT groupid FROM $db_xoops_group WHERE group_type = 'User'");
		// get insert users  ID
		$db_xoops_group = get_xoops_prefix() . 'users';
		$user_id = $xoops_db->get_var("SELECT uid FROM $db_xoops_group WHERE uname = '$user_info->user_login'");
		// insert groups_users_link 
		$db_xoops_group_users_link = get_xoops_prefix() . 'groups_users_link';
		$default_xoops_group_id = $xoops_db->get_var("INSERT INTO $db_xoops_group_users_link (groupid , uid ) VALUES ($default_xoops_group_id , $user_id)");
	}
}


/*
 * When I changed the pre-fix of the database in XOOPS Protector Module, user authority data of WordPress read it and cannot do it. 
 * This is because a meta_key pre-fix of the usermeta table of WordPress is not changed.
 * and  user_roles option_name pre-fix of the option table of WordPress is not changed.
*/
function check_user_meta_prefix($uid){
	global $xoops_db;
	$db_xpress_usermeta = get_wp_prefix() . 'usermeta';
	$user_meta_prefix = get_wp_prefix();

	$sql = "SELECT * FROM $db_xpress_usermeta WHERE user_id = $uid AND meta_key = '" . $user_meta_prefix ."user_level'" ;

	$user_level = $xoops_db->get_results($sql);
	if (empty($user_level)) return false ;

	$sql = "SELECT * FROM $db_xpress_usermeta WHERE user_id = $uid AND meta_key = '" . $user_meta_prefix ."capabilities'" ;
	$capabilities = $xoops_db->get_results($sql);
	if (empty($capabilities)) return false ;
	
	return true;	
}

function repair_user_meta_prefix(){
	global $xoops_db;

	// repair usermeta db
	$db_xpress_usermeta = get_wp_prefix() . 'usermeta';
	$wp_prefix_only = get_wp_prefix_only();
	$user_meta_prefix = get_wp_prefix();
	$sql = "SELECT * FROM $db_xpress_usermeta WHERE meta_key LIKE '%_" . $wp_prefix_only . "%'" ;
	$user_metas = $xoops_db->get_results($sql);
	foreach($user_metas as $user_meta){
		if (strpos($user_meta->meta_key,$user_meta_prefix) === false) {
			$new_meta_key = '';
			if (strpos($user_meta->meta_key,$wp_prefix_only.'user_level'))
				$new_meta_key = $user_meta_prefix . 'user_level';
			if (strpos($user_meta->meta_key,$wp_prefix_only.'capabilities'))
				$new_meta_key = $user_meta_prefix . 'capabilities';
			if (strpos($user_meta->meta_key,$wp_prefix_only.'autosave_draft_ids'))
				$new_meta_key = $user_meta_prefix . 'autosave_draft_ids';
			if (strpos($user_meta->meta_key,$wp_prefix_only.'usersettings')){
				if (strpos($user_meta->meta_key,$wp_prefix_only.'usersettingstime'))
					$new_meta_key = $user_meta_prefix . 'usersettingstime';
				else
					$new_meta_key = $user_meta_prefix . 'usersettings';
			}
			if (!empty($new_meta_key)){
				$repair_sql  = 	"UPDATE $db_xpress_usermeta ";
				$repair_sql .= 	'SET ';
				$repair_sql .=	"meta_key = '$new_meta_key' ";
				$repair_sql .=	"WHERE (umeta_id = $user_meta->umeta_id )";
				$xoops_db->query($repair_sql);
			}
		}
	}
	
	// repair option db user_roles
	$db_wp_option = get_wp_prefix() . 'options';
	$new_option_name = get_wp_prefix() . 'user_roles';
	$sql = "SELECT option_id , option_name FROM $db_wp_option WHERE option_name LIKE '%_" . $wp_prefix_only . "user_roles'" ;
	$option= $xoops_db->get_row($sql);
	if ($option->option_name != $new_option_name){
		$repair_sql  = 	"UPDATE $db_wp_option ";
		$repair_sql .= 	'SET ';
		$repair_sql .=	"option_name = '$new_option_name' ";
		$repair_sql .=	"WHERE (option_id = $option->option_id )";
		$xoops_db->query($repair_sql);
	}
}
?>