<?php
/*
 * XPressME - WordPress for XOOPS
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @package		module::xpress
 */

/* 
 * The function to acquire only a set value without calling the XOOPS system is here.
 */
require_once dirname( __FILE__ ).'/wpInfo_class.php' ;

class ConfigFromXoops{
	var $xoops_mainfile_path;
	var $define_arry = array();	
	var $external_define_path;
	var $xp_config_file_path;
	var $xoops_root_path;
	var $xoops_url;
	var $xoops_trust_path;
	var $xoops_cache_path;
	var $xoops_db_prefix;
	var $xoops_db_name;
	var $xoops_db_user;
	var $xoops_db_pass;
	var $xoops_db_host;
	var $module_name;
	var $module_path;
	var $module_url;
	var $module_db_prefix;
	var $module_version;
	var $module_codename;	
	var $xoops_upload_path;
	var $xoops_upload_url;
	var $xoops_db_salt;
	var $xoops_salt;
	var $is_impress;
	var $impress_db_config_file;
	var $wp_db_version;
	var $wp_version;
	var $is_wp_me;
	var $xoops_language;
	var $module_id;
	var $module_config= array();
	var $xoops_time_zone;
	var $xoops_var_path;
	var $xoops_db_charset;
	var $xoops_db_pconnect;
	var $xoops_path;
	var $xoops_lang;
	var $wp_lang;
	
	function __constructor()	//for PHP5
    {
        $this->ConfigFromXoops();
       
    }
    
    function ConfigFromXoops()	//for PHP4 constructor
    {  
    	$this->xoops_mainfile_path = $this->get_xoops_mainfile_path();
    	$this->module_path=dirname(dirname(__FILE__));
    	$this->module_name=basename($this->module_path);
    	$this->xp_config_file_path = $this->module_path . '/xp-config.php';
    	
    	// start /admin/index.php page detect
    	$php_script_name = $_SERVER['SCRIPT_NAME'];
		$php_query_string = $_SERVER['QUERY_STRING'];
		$admin_page = 	basename(dirname(dirname(__FILE__))) . '/admin/index.php';
		$is_xoops_module_admin = false;
		if (strstr($php_script_name,$admin_page) !== false) $is_xoops_module_admin = true;
		if (strstr($php_query_string,$admin_page) !== false) $is_xoops_module_admin = true;
    	$this->_get_value_by_xoops_define();
		//  define from /settings/definition.inc.php (XCL)  or /include/common.php(2016a-JP)
		$this->xoops_upload_path = $this->xoops_root_path .'/uploads';
		$this->xoops_upload_url = $this->xoops_url . '/uploads';
		$this->module_db_prefix = $this->xoops_db_prefix  . '_' . preg_replace('/wordpress/','wp',$this->module_name) . '_';
		
		$this->set_module_version();
		$this->set_wp_version();
		if (function_exists('date_default_timezone_get')){
			$this->xoops_time_zone = date_default_timezone_get();
		}
		$this->_get_cache_path();
    }

	// A set value is acquired from XOOPS define value .
	function _get_value_by_xoops_define(){
		$this->xoops_root_path = XOOPS_ROOT_PATH;
		$this->xoops_url = XOOPS_URL;
		$this->module_url = $this->xoops_url . '/modules/' . $this->module_name;
		if(defined('XOOPS_TRUST_PATH')) $this->xoops_trust_path = XOOPS_TRUST_PATH; else $this->xoops_trust_path = '';
		$this->xoops_db_prefix = XOOPS_DB_PREFIX;
		$this->xoops_db_name = XOOPS_DB_NAME;
		$this->xoops_db_user = XOOPS_DB_USER;
		$this->xoops_db_pass = XOOPS_DB_PASS;
		$this->xoops_db_host = XOOPS_DB_HOST;
		if(defined('XOOPS_DB_SALT')) $this->xoops_db_salt = XOOPS_DB_SALT; else $this->xoops_db_salt = '';
		if(defined('XOOPS_SALT')) $this->xoops_salt = XOOPS_SALT; else $this->xoops_salt = '';
		$this->xoops_lang =  @$GLOBALS["xoopsConfig"]['language'];
		$wp_info = new wpInfo;
		$this->wp_lang = $wp_info->get_wpLang($this->xoops_lang);

	}
	
	// call after the $this->xoops_trust_path is set
	function _get_cache_path(){
		$cache_path = $this->xoops_trust_path . '/cache';
		if (file_exists($cache_path) && is_writable($cache_path)){
			$this->xoops_cache_path = $cache_path;
			return;
		}
		$this->xoops_cache_path = $this->xoops_root_path . '/cache';
	}
    
    function get_xoops_mainfile_path(){
    	return dirname(dirname(dirname(dirname(__FILE__)))) . '/mainfile.php';
    }
    
    // set XPressME module virsion and codename from xoops_versions.php
    function set_module_version(){
    	$xoops_version_file = dirname(dirname(__FILE__)) . '/xoops_version.php';
		if(file_exists($xoops_version_file)){
			$version_file = file($xoops_version_file);
			$version_pattern = '^\s*(\$modversion\[\s*\'version\'\s*\])\s*=\s*[\'"]([^\'"]*)[\'"]';
			$codename_pattern = '^\s*(\$modversion\[\s*\'codename\'\s*\])\s*=\s*[\'"]([^\'"]*)[\'"]';
			$version_found = false;
			$codename_found = false;
			for ($i = 0 ; $i <count($version_file) ; $i++){
				if (preg_match( "/$version_pattern/", $version_file[$i] ,$v_matches )){
					$this->module_version = $v_matches[2];
					$version_found = true;
				}
				if (preg_match( "/$codename_pattern/", $version_file[$i] ,$c_matches )){
					$this->module_codename = $c_matches[2];
					$codename_found = true;
				}
				if ( $version_found && $codename_found ) break;
			}
		}
    }
    
    function set_wp_version(){
    	include dirname(dirname(__FILE__)) . '/wp-includes/version.php';
    	
    	$this->wp_db_version = $wp_db_version;
		
		$this->wp_version = str_replace("ME", "", $wp_version);
		
		$pattern = 'ME.*';
    	if (preg_match('/' . $pattern . '/' ,$wp_version)){
			$this->is_wp_me = true;
		} else {
			$this->is_wp_me = true;
		}
    }
    
}
?>