<?php get_header(); ?>
<div id="xpress_wrap">
<?php
	if(xpress_is_theme_sidebar_disp()) {
		echo '<div id="xpress_content" class="narrowcolumn">';	
	} else {
		echo '<div id="xpress_content" class="narrowcolumn_nonside">';
	}	
?>				

		<div id="xpress-header-bar">
			<div class="xpress-header-title">
				<a href="<?php echo get_option('home'); ?>/"><?php bloginfo('name'); ?></a>
			</div>
			<div class="xpress-conditional-title">
				&nbsp;( <?php xpress_conditional_title();?> )
			</div>
			<div class="xpress-description">
				<?php bloginfo('description'); ?>
			</div>
			<div class="xpress-operation-link">
				<a href="<?php echo get_option('home'); ?>/"><?php _e('Mein Page','xpress')?></a> 
				<?php if(is_xpress_contributor()) { echo ' | ' ; xpress_post_new_link(__('Post New','xpress')); }?>
			</div>
		</div>
		<hr class="xpress-border">
		<?php if (have_posts()) : ?>
			<div class="xpress-navi-bar">
				<?php if(function_exists('wp_pagenavi')) : ?>			
					<div class="xpress_pagenavi"><?php wp_pagenavi(); ?></div>
				<?php else : ?>
					<div class="alignleft"><?php xpress_left_arrow_posts_link(true); ?></div>
					<div class="alignright"><?php xpress_right_arrow_posts_link(true); ?></div>
				<?php endif; ?>
			</div>
				
			<?php while (have_posts()) : the_post(); ?>

				<div class="xpress-post" id="post-<?php the_ID(); ?>">
					<div class ="xpress-post-header">
						<?php if (function_exists('hotDates')) { hotDates(); }?>
						<div class ="xpress-post-title">
							<h3><a href="<?php the_permalink() ?>" rel="bookmark" title="<?php printf(__('Permanent Link to %s', 'xpress'), the_title_attribute('echo=0')); ?>"><?php the_title(); ?></a></h2>
						</div>
					</div>
					<div class="xpress-post-entry">
						<?php xpress_the_content(__('Read the rest of this entry &raquo;') ); ?>
					</div>
					<?php wp_link_pages() ?>		
					<div class ="xpress-post-footer">
					<?php
						the_time('Y/m/d l');
						echo ' - ';
						the_author_posts_link();
						echo ' (' . xpress_post_views_count($post->ID,__('Views :%d', 'xpress'),false) . ')'; 
						echo ' | ';
						// echo the_tags(__('Tags:', 'xpress') . ' ', ', ', ' | ');
						printf(__('Posted in %s', 'xpress'), get_the_category_list(', '));
						echo ' | ';
						edit_post_link(__('Edit', 'xpress'), '', ' | ');
						comments_popup_link(__('No Comments &#187;', 'xpress'), __('1 Comment &#187;', 'xpress'), __('% Comments &#187;', 'xpress'), '', __('Comments Closed', 'xpress') );
					?>
					</div>
				</div>

			<?php endwhile; ?>
				
			<div class="xpress-navi-bar">
				<?php if(function_exists('wp_pagenavi')) : ?>			
					<div class="xpress_pagenavi"><?php wp_pagenavi(); ?></div>
				<?php else : ?>
					<div class="alignleft"><?php xpress_left_arrow_posts_link(true); ?></div>
					<div class="alignright"><?php xpress_right_arrow_posts_link(true); ?></div>
				<?php endif; ?>
			</div>
				
		<?php else : ?>

			<h2 class="center"><?php _e('Not Found', 'xpress'); ?></h2>
			<p class="center"><?php _e('Sorry, but you are looking for something that isn&#8217;t here.', 'xpress'); ?></p>
			<?php include (get_template_directory() . "/searchform.php"); ?>

		<?php endif; ?>
	</div>
</div>
<?php if(xpress_is_theme_sidebar_disp()) get_sidebar(); ?>
<hr class="xpress-border">
<?php get_footer(); ?>
