<?php
/*
 * XPressME - WordPress for XOOPS
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @package		module::xpress
 */

/* 
 * The function to acquire only a set value without calling the XOOPS system is here.
 */
class ConfigFromXoops{
	var $xoops_mainfile_path;
	var $define_arry = array();	
	var $xoops_root_path;
	var $xoops_url;
	var $xoops_trust_path;
	var $xoops_db_prefix;
	var $xoops_db_name;
	var $xoops_db_user;
	var $xoops_db_pass;
	var $xoops_db_host;
	var $module_name;
	var $module_path;
	var $module_url;
	var $module_db_prefix;
	var $module_version;
	var $module_codename;	
	var $xoops_upload_path;
	var $xoops_upload_url;
	var $xoops_db_salt;
	var $xoops_salt;
	var $is_impress;
	var $impress_db_config_file;
	
	
	function __constructor()	//for PHP5
    {
        $this->ConfigFromXoops();
       
    }
    
    function xpress_eval($str){
    	$eval_str = '$ret = ' . $str . ' ;';
    	eval($eval_str);
    	return $ret;
    }

    function ConfigFromXoops()	//for PHP4 constructor
    {  
    	$this->xoops_mainfile_path = $this->get_xoops_mainfile_path();
    	$this->module_path=dirname(dirname(__FILE__));   	
    	$this->module_name=basename($this->module_path);
		if(file_exists($this->xoops_mainfile_path)){
			$array_file = file($this->xoops_mainfile_path);
			$pattern = '^\s*define\s*\(\s*(\'[^\']+\'|"[^"]+")\s*,\s*([^\s]+.*)\s*\)\s*;';
			$impress_include_pattern = '^\s*(include_once|include)\s*\(\s*XOOPS_TRUST_PATH\s*.\s*[\'"]([^\'"]+)[\'"]\s*\)';
			for ($i = 0 ; $i <count($array_file) ; $i++){
				if (preg_match('/' . $pattern . '/' ,$array_file[$i],$matchs)){
					$keys = $matchs[1];
					if (preg_match('/^\'[^\']*\'$/',$keys)) $keys = preg_replace('/\'/', '', $keys);
					if (preg_match('/^"[^"]*"$/',$keys)) $keys = preg_replace('/"/', '', $keys);
					$key_value = $matchs[2];

					switch ($keys){
						case  'XOOPS_ROOT_PATH':
							$this->xoops_root_path = $this->xpress_eval($key_value);
							$this->xoops_url . '/modules/' . $this->module_name;
							break;
						case  'XOOPS_URL':
							$this->xoops_url = $this->xpress_eval($key_value);
							$this->module_url = $this->xoops_url . '/modules/' . $this->module_name;
							break;
						case  'XOOPS_TRUST_PATH':
							$this->xoops_trust_path = $this->xpress_eval($key_value);
							break;
						case  'XOOPS_DB_PREFIX':
							$this->xoops_db_prefix = $this->xpress_eval($key_value);
							break;
						case  'XOOPS_DB_NAME':
							$this->xoops_db_name = $this->xpress_eval($key_value);
							break;
						case  'XOOPS_DB_USER':
							$this->xoops_db_user = $this->xpress_eval($key_value);
							break;
						case  'XOOPS_DB_PASS':
							$this->xoops_db_pass = $this->xpress_eval($key_value);
							break;
						case  'XOOPS_DB_HOST':
							$this->xoops_db_host = $this->xpress_eval($key_value);
							break;
						case  'XOOPS_DB_SALT':
							$this->xoops_db_salt = $this->xpress_eval($key_value);
							break;
						case  'XOOPS_SALT':
							$this->xoops_salt = $this->xpress_eval($key_value);
							break;
						default :
							
					}	// end of switch
				}	 // end of if preg_match
				
				// Check ImpressCMS
				if (preg_match('/' . $impress_include_pattern . '/' ,$array_file[$i],$impres_matchs)){
					$this->is_impress = true;
					$this->impress_db_config_file = $this->xoops_trust_path . $impres_matchs[2];
				}
			} // end of for loop
		} // end of if file_exists
		
		// DB Config from Impress CMS impress_db_config file
		if ($this->is_impress){
			if(file_exists($this->impress_db_config_file)){
				$array_file = file($this->impress_db_config_file);
				$pattern = '^\s*define\s*\(\s*(\'[^\']+\'|"[^"]+")\s*,\s*(\'[^\']*\'|"[^"]*"|[^\'"])\s*\)\s*;';
				for ($i = 0 ; $i <count($array_file) ; $i++){
					if (preg_match('/' . $pattern . '/' ,$array_file[$i],$matchs)){
						$keys = $matchs[1];
						if (preg_match('/^\'[^\']*\'$/',$keys)) $keys = preg_replace('/\'/', '', $keys);
						if (preg_match('/^"[^"]*"$/',$keys)) $keys = preg_replace('/"/', '', $keys);
						$key_value = $matchs[2];

						switch ($keys){
							case  'SDATA_DB_SALT':
								$this->xoops_db_salt = $this->xpress_eval($key_value);
								break;
							case  'SDATA_DB_PREFIX':
								$this->xoops_db_prefix = $this->xpress_eval($key_value);
								break;
							case  'SDATA_DB_NAME':
								$this->xoops_db_name = $this->xpress_eval($key_value);
								break;
							case  'SDATA_DB_USER':
								$this->xoops_db_user = $this->xpress_eval($key_value);
								break;
							case  'SDATA_DB_PASS':
								$this->xoops_db_pass = $this->xpress_eval($key_value);
								break;
							case  'SDATA_DB_HOST':
								$this->xoops_db_host = $this->xpress_eval($key_value);
								break;
							default :
								
						}	// end of switch
					}
				} // end of for
			}
		}
			
		//  define from /settings/definition.inc.php (XCL)  or /include/common.php(2016a-JP)
		$this->xoops_upload_path = $this->xoops_root_path .'/uploads';
		$this->xoops_upload_url = $this->xoops_url . '/uploads';
		
		if ($this->module_name == 'wordpress')
			$this->module_db_prefix =  $this->xoops_db_prefix  . '_wp_';
		else
			$this->module_db_prefix =  $this->xoops_db_prefix  . '_' . $this->module_name . '_';
		
		$this->set_module_version();
		
    }
    
    function get_xoops_mainfile_path(){
    	return dirname(dirname(dirname(dirname(__FILE__)))) . '/mainfile.php';
    }
    
    // set XPressME module virsion and codename from xoops_versions.php
    function set_module_version(){
    	$xoops_version_file = dirname(dirname(__FILE__)) . '/xoops_version.php';
		if(file_exists($xoops_version_file)){
			$version_file = file($xoops_version_file);
			$version_pattern = '^\s*(\$modversion\[\s*\'version\'\s*\])\s*=\s*[\'"]([^\'"]*)[\'"]';
			$codename_pattern = '^\s*(\$modversion\[\s*\'codename\'\s*\])\s*=\s*[\'"]([^\'"]*)[\'"]';
			$version_found = false;
			$codename_found = false;
			for ($i = 0 ; $i <count($version_file) ; $i++){
				if (preg_match( "/$version_pattern/", $version_file[$i] ,$v_matches )){
					$this->module_version = $v_matches[2];
					$version_found = true;
				}
				if (preg_match( "/$codename_pattern/", $version_file[$i] ,$c_matches )){
					$this->module_codename = $c_matches[2];
					$codename_found = true;
				}
				if ( $version_found && $codename_found ) break;
			}
		}
    }
    
}
?>
