<?php
global $xoops_config;
if (!is_object($xoops_config)){ // is call other modules
	require_once dirname(dirname(dirname(dirname(dirname( __FILE__ ))))) .'/class/config_from_xoops.class.php' ;
	$xoops_config = new ConfigFromXoops;
}

function get_xoops_config($config_name,$module_dir){
	global $xoops_db;
	
	$modules_db = get_xoops_prefix() . 'modules';
	$config_db = get_xoops_prefix() . 'config';

	$moduleID = $xoops_db->get_var("SELECT mid FROM $modules_db WHERE dirname = '$module_dir'");
	if (empty($moduleID)) return null;
	$conf_value = $xoops_db->get_var("SELECT conf_value FROM $config_db WHERE (conf_modid = $moduleID) AND (conf_name = '$config_name')");
	if (empty($conf_value)) return null;
	return  $conf_value;
}

// xoops db
function get_xpress_dir_path()
{
	return ABSPATH;
}

function get_xpress_dir_name()
{
	return basename(ABSPATH);
}

function get_wp_prefix_only()
{
	$dir_name = get_xpress_dir_name();
	$prefix = $dir_name;
	if ($prefix == 'wordpress') $prefix = 'wp';
	
	$prefix = $prefix . '_';
	return $prefix;
}

function get_xoops_prefix()
{
	global $xoops_config;
	$ret =$xoops_config->xoops_db_prefix . '_';
	return $ret;
}

function get_xoops_trust_path()
{
	global $xoops_config;
	$ret =$xoops_config->xoops_trust_path;
	return $ret;
}

function get_xoops_root_path()
{
	global $xoops_config;
	$ret =$xoops_config->xoops_root_path;
	return $ret;
}

function get_wp_prefix()
{
	$prefix = get_xoops_prefix() . get_wp_prefix_only();
	return $prefix;
}
function get_xoops_url()
{
	global $xoops_config;
	$ret =$xoops_config->xoops_url ;
	return $ret;
}

function get_xpress_url()
{
	global $xoops_config;
	$ret =$xoops_config->module_url ;
	return $ret;
}

function get_xpress_modid()
{
	global $xoops_db;
	
	$modulename = get_xpress_dir_name();	
	$sql = "SELECT mid FROM " . get_xoops_prefix() . "modules WHERE dirname = '$modulename'";
	$mid = $xoops_db->get_var($sql);
	return $mid;	
}

function get_xpress_db_version()
{
	include get_xpress_dir_path() . '/wp-includes/version.php';
	return $wp_db_version;
}

function is_xpress_mobile()
{
	//ktai_style
 	if (function_exists('is_ktai')){
 		if (is_ktai()) {
 //			$file_path = $GLOBALS['xoopsModuleConfig']["ktai_style_tmpdir"] . '/comments.php';
			return true;
		}
	}
	
	//mobg
	if (function_exists('is_mobile')) {
		if (is_mobile()){
			return true;
		}
	}
	if (
	  preg_match("/DoCoMo/", $_SERVER['HTTP_USER_AGENT']) ||
	  preg_match("/softbank/", $_SERVER['HTTP_USER_AGENT']) ||
	  preg_match("/vodafone/", $_SERVER['HTTP_USER_AGENT']) ||
	  preg_match("/J-PHONE/", $_SERVER['HTTP_USER_AGENT']) ||
	  preg_match("/UP\.Browser/", $_SERVER['HTTP_USER_AGENT']) ||
	  preg_match("/ASTEL/", $_SERVER['HTTP_USER_AGENT']) ||
	  preg_match("/PDXGW/", $_SERVER['HTTP_USER_AGENT'])
	) 
	{
		return true;
	} else {
		return false;
	}
}

function block_cache_refresh() 
{ 
	global $xoops_db; 
	$mid = get_xpress_modid(); 
	$sql = "SELECT bid,options,func_file FROM " . get_xoops_prefix() . "newblocks WHERE mid = $mid"; 
	$blocks = $xoops_db->get_results($sql); 
	$mydirname = get_xpress_dir_name(); 
	require_once get_xpress_dir_path() . '/include/xpress_block_render.php'; 


	foreach($blocks as $block){ 
		$func_file = $block->func_file; 
		$call_theme_function_name = str_replace(".php", "", $func_file); 
		$inc_theme_file_name = str_replace(".php", "", $func_file) . '_theme.php'; 
		$cache_title = str_replace(".php", "", $func_file); 
		$blockID = $block->bid; 
		$options = explode("|", $block->options); 

		$block_theme_file = get_block_file_path($mydirname,$inc_theme_file_name); 
		require_once $block_theme_file; 
		$block_render = $call_theme_function_name($options);            //The block name and the called function name should be assumed to be the same name.                     
		$xml['block'] = $block_render; 
		$xml['block']['options'] = $block->options; 
		xpress_block_cache_write($mydirname,$cache_title. $blockID, $xml); 
	} 
}
function is_wordpress_style()
{
	global $xpress_config;
	
	if ($xpress_config->viewer_type == 'wordpress') return true;
	if ($xpress_config->viewer_type == 'xoops') return false;
	
	// user select
	$get_style = isset($_GET["style"]) ? $_GET["style"] : '';
	$cookie_style = isset($_COOKIE["xpress_style"]) ? $_COOKIE["xpress_style"] : '';
	
	// set style
	if (!empty($get_style)){
		$style = $get_style;
	} else {
		if (!empty($cookie_style)){
			$style = $cookie_style;
		} else {
			$style = 'x';
		}
	}
	
	// set cookie
	if (empty($cookie_style)){
		setcookie("xpress_style", $style);
		$_COOKIE["xpress_style"] = $style;
	} else {
		if ($style != $cookie_style) {
			setcookie("xpress_style", $style);
			$_COOKIE["xpress_style"] = $style;
		}
	}
	if ($style == 'w') {
		return true;
	} else { 
		return false;
	}
}

function wp_meta_add_xpress_menu()
{
	global $xpress_config;
	if ($xpress_config->viewer_type == 'user_select'){
		echo disp_mode_set();
	}
	if (function_exists('wp_theme_switcher') ) {	
		echo '<li>' . __('Themes') . ':';
		wp_theme_switcher('dropdown');
	 	echo '</li>';
	}
}

function disp_mode_set(){
	global $xpress_config;
	
	$select ="";
	if ($xpress_config->viewer_type == 'user_select'){
		$style = isset($_GET["style"]) ? $_GET["style"] : (isset($_COOKIE["xpress_style"]) ? $_COOKIE["xpress_style"] : "");

		switch($style) {
		case 'w':
			$select ='<li><a href="'.get_settings('siteurl').'/?style=x" title="'. __('Switch to XOOPS mode','xpressme').'">'.__('Switch to XOOPS mode','xpressme').'</a></li>';
//			$select.='<img src="'. get_settings('siteurl').'/images/external.png" alt="'.__('Switch to XOOPS mode','xpressme') . '"></a></li>';
			break;
		case 'x':
			$select='<li><a href="'.get_settings('siteurl').'/?style=w" title="'.__('Switch to WordPress mode','xpressme').'">'.__('Switch to WordPress mode','xpressme').'</a></li>';
			break;
		default:
			$select='<li><a href="'.get_settings('siteurl').'/?style=w" title="'.__('Switch to WordPress mode','xpressme').'">'.__('Switch to WordPress mode','xpressme').'</a></li>';
			break;
		}
	}
	return $select;
}

function xpress_comment_count( $count ) {
        global $id;
        $comments_by_type = &separate_comments(get_comments('status=approve&post_id=' . $id));
        return count($comments_by_type['comment']);
}

function xpress_set_author_cookie()
{
	$author_cookie = get_xpress_dir_name() . "_select_author" ;
	if(xpress_is_multi_user()){
		if (empty($_GET)){
	//		$GLOBALS["wp_xoops_author"] = null;
			setcookie($author_cookie, 0);
			$_COOKIE[$author_cookie] = 0;
			
		} else {
			$auth = intval( @$_GET["author"] );
			if ($auth > 0){
				setcookie($author_cookie, $auth);
				$_COOKIE[$author_cookie] = $auth;
			}
		}
	}else{
	//	$GLOBALS["wp_xoops_author"] = null;
		setcookie($author_cookie, 0);
		$_COOKIE[$author_cookie] = 0;
	}
}

function xpress_query_filter(&$query)
{
	$author_cookie = get_xpress_dir_name() . "_select_author" ;
	
	if (strpos($query,'SELECT') !==0)  return $query;

	$select_pattern = "SELECT(.*)post_author(.*)FROM";
	if (preg_match ( "/".$select_pattern."/i", $query, $select_match ))
		return $query;

	$query = preg_replace('/\s\s+/', ' ', $query);
	if (!empty($_COOKIE[$author_cookie])){
		$pattern = "WHERE.*post_type\s*=\s*'post'\s*\)?";
		if ( preg_match ( "/".$pattern."/i", $query, $match ) ){
			$where_str = "$match[0]";
			$where_arry = split(' ',$where_str);
			$post_prefix = '';
			foreach ($where_arry as $p){
				if ( preg_match ( "/post_type/", $p, $match3 ) ){
					$post_prefix = preg_replace("/post_type/", "", $p);
					$post_prefix = preg_replace("/\(/", "", $post_prefix);
					break;
				}
			}
			preg_match ( "/post_type(.*)/", $where_str, $p_match );
			$patern = $p_match[0];
			$patern = preg_replace('/\)/', '\)', $patern);
			
			$replace = $patern . " AND {$post_prefix}post_author = " . intval($_COOKIE[$author_cookie]) . " ";

			$query = preg_replace("/$patern/", $replace, $query);
		}
	}
//	xpress_show_sql_quary($query);
	return $query;
}
?>