<?php

//< style >< script >< link > tag is pulled out from the header of html contents. 
function get_mod_header($contents)
{
	$pattern = "<head[^>]*?>(.*)<\/head>";
	preg_match("/".$pattern."/s",  $contents, $head_matches);
	$head_str = $head_matches[1];
	
	$pattern = "<style[^>]*?>(.*)<\/style>";
	preg_match("/".$pattern."/s",  $head_str, $style_matches);
	$style = $style_matches[0];
 
	$pattern = "<link(.*)>";
	preg_match_all("/".$pattern."/",  $head_str, $link_match,PREG_PATTERN_ORDER);
	$links = $link_match[0];
	$link_str ='';
	foreach ( $links as $link){
		ob_start();
			echo $link . "\n";
			
			$link_str .= ob_get_contents();
		ob_end_clean();
	}
	
	$pattern = "<script[^>]*?>(.*)<\/script>";
	preg_match_all("/".$pattern."/s",  $head_str, $script_match,PREG_PATTERN_ORDER);
	$scripts = $script_match[0];
	$script_str ='';
	foreach ( $scripts as $script){		
		if (($GLOBALS["xoopsModuleConfig"]['use_d3forum'] != 1) || (strpos($script,'function wpopen') ===false))
			$script_str .= $script;
	}
	return $link_str."\n".$style . "\n" . $script_str ."\n";
}

// < body > tag is pulled out from the header of html contents. 
function get_body($contents)
{
	$pattern = "<body[^>]*?>(.*)<\/body>";
	preg_match("/".$pattern."/s",  $contents, $body_matches);
	$body = $body_matches[1];
	return $body;
}

//Making of module header
function get_xpress_module_header($contents)
{
	global $xoopsTpl;
	if( defined( 'XOOPS_CUBE_LEGACY' ) ) {
		$preload_make_module_header = $xoopsTpl->get_template_vars('xoops_module_header');
	} else {
		$preload_make_module_header = '';
	}
	
	if (! empty($preload_make_module_header)){
	$preload_make_module_header = '<!-- preload added module header -->
' . $preload_make_module_header . '
';
	}
	
	$wp_module_header = '<!-- wordpress  added module header -->
' . get_mod_header($contents) . '
<!-- end of wordpress  added module header -->';
	
	return $preload_make_module_header . $wp_module_header;
}

//rendering for the module header and the body
function xpress_render($contents){
	global $xoopsTpl;
	include XOOPS_ROOT_PATH."/header.php";
	$page_title = $GLOBALS["xoopsModule"]->getVar("name")." ".wp_title('&raquo;', false);	
	$xoopsTpl->assign('xoops_module_header', get_xpress_module_header($contents));
	$xoopsTpl->assign('xoops_pagetitle', $page_title);
	$xoopsTpl->assign('xpress_body_contents', get_body($contents));
 	echo get_body($contents);
}

?>