<?php
/**
 * XPressME - WordPress for XOOPS
 *
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @since		2.04
 * @version		$Id$
 * @package		module::xpress
 */


//
// wordpress user data vs xoops user data
// wordpress database info from http://adiary.blog.abk.nu/080
//
//	wordpress									xpress
//------------------------------------------------------------------------------------------
//	users.ID [bigint(20)]						users.uid [mediumint(8)]
//	users.user_login [varchar(60)]				users.uname [varchar(60)]
//	users.user_pass [varchar(64)]				users.pass [varchar(32)]
//	users.user_email [varchar(100)]				users.email [varchar(60)]
//	users.user_url[varchar(100)]				users.url [varchar(100)]
//	users.dateYMDhour [datetime]				
//	users.user_nicename [varchar(50)]			users.uname [varchar(60)]
//	users.user_registerd [datetime]				date('Y-m-d H:i:s' , users.regdate[int(10)])
//	users.user_activation_key [varchar(60)]		null
//	users.user_status	[int(11)]				0
//	users.display_name [varchar(250)]			empty(users.name) ? users.uname :users.name
//
//	usermeta[meta_key]							get_xpress_user_level(uid);
//		user_level	10:admim
//					7: editor
//					2: auther
//					1: contributor
//					0: subscriber							
//		nickname								users.name [varchar(25)]
//		capabillities
//			at user_level	10:admim			'a:1:{s:13:"administrator";b:1;}'		
//							7: editor			'a:1:{s:6:"editor";b:1;}'
//							2: auther			'a:1:{s:6:"author";b:1;}'
//							1: contributor		'a:1:{s:11:"contributor";b:1;}'
//							0: subscriber		'a:1:{s:10:"subscriber";b:1;}'
//					
//		first_name
//		last_name								
//		description
//		jabber
//		aim										users.user_aim
//		yim										users.user_yim
//		
//

	include_once dirname( __FILE__ ).'/../../../mainfile.php';
	$path = dirname(dirname(__FILE__)) . '/';
	if (file_exists($path . 'wp-load.php')) {
		require_once $path . 'wp-load.php';
	} else {
		require_once $path . 'wp-config.php';
	}

//if( ! function_exists( 'get_xpress_mid' ) ) :
	function get_xpress_mid($mydirname){
		$xoopsDB =& Database::getInstance();
		$module_tbl = $xoopsDB->prefix('modules');		
		$module_dir = XOOPS_ROOT_PATH . '/modules/' . $mydirname;
		$module_id = 0;

		$sql = "SELECT mid FROM $module_tbl WHERE dirname LIKE '$mydirname'";
		$result =  $xoopsDB->query($sql, 0, 0);
		if ($xoopsDB->getRowsNum($result)  > 0){
			$row = $xoopsDB->fetchArray($result);
			$module_id = $row['mid'];
		}
		return $module_id;
	}
//endif;		


//if( ! function_exists( 'get_xpress_user_level' ) ) :
	function get_xpress_user_level($mydirname , $uid=0){
		if ($uid == 0){
			return 0;
		}

		global $xoopsModule;
		$xoopsDB =& Database::getInstance();
		$db_groups_users_link = $xoopsDB->prefix('groups_users_link');
		$db_group_permission = $xoopsDB->prefix('group_permission');
		$module_tbl = $xoopsDB->prefix('modules');
		
		$module_id = get_xpress_mid($mydirname);
		$sql = "SELECT uid FROM $db_groups_users_link WHERE groupid = 1 AND uid = $uid";
	
		$result =  $xoopsDB->query($sql, 0, 0);
		if ($xoopsDB->getRowsNum($result)  > 0){
				return 5;
		}
		
		$sql  = "SELECT Max($db_group_permission.gperm_itemid) AS user_level ,$db_groups_users_link.uid ";
		$sql .= "FROM $db_groups_users_link LEFT JOIN $db_group_permission ON $db_groups_users_link.groupid = $db_group_permission.gperm_groupid ";
		$sql .= "WHERE $db_group_permission.gperm_modid = $module_id ";
		$sql .= "GROUP BY $db_groups_users_link.uid ";
		$sql .= "HAVING $db_groups_users_link.uid = $uid";
		$result =  $xoopsDB->query($sql, 0, 0);
		if ($result === false){
			return 0;
		}else{
			if ($xoopsDB->getRowsNum($result)  > 0){
				$row = $xoopsDB->fetchArray($result);	
				$level =  $row['user_level'];
				return $level;
			} else { 
				return 0;
			}
		}
	}
//endif;

//if( ! function_exists( 'get_now_user_level' ) ) :
	function get_now_user_level(){

		global $xoopsModule;

		if(empty($GLOBALS['user_level'])){
			return 0;		
		} else {
			//$user_id =  $GLOBALS["xoopsUser"]->getVar("uid");
			//$level = xpress2wp_user_level(get_xpress_user_level($mydirname , $user_id));
			//$level = get_wp_user_level($mydirname,$user_id);
			$level = $GLOBALS['user_level'];
			return $level;
		}		
	}
//endif;

//if( ! function_exists( 'get_wp_user_leve' ) ) :
	function get_wp_user_level($mydirname,$uid=0){
		$wp_prefix = get_xpress_prefix($mydirname);
		$xoopsDB =& Database::getInstance();		
		$db_xpress_usermeta = $xoopsDB->prefix($wp_prefix . 'usermeta');
		$meta_key_str = $xoopsDB->prefix($wp_prefix . 'user_level');
		$sql = "SELECT meta_value FROM $db_xpress_usermeta WHERE (user_id = $uid) AND (meta_key = $meta_key)";
		$res =  $xoopsDB->query($sql, 0, 0);
		if ($res === false){
			return 0;
		}else{
			if ($xoopsDB->getRowsNum($res)  > 0){
				$row = $xoopsDB->fetchArray($res);	
				$level =  $row['meta_value'];
				return $level;
			} else { 
				return 0;
			}
		}
		
	}
//endif;		

//if( ! function_exists( 'get_xpress_prefix' ) ) :
	function get_xpress_prefix($mydirname){
		global $xoopsModule;
		if ($mydirname == 'wordpress'){
			return 'wp_';
		} else {
			return $mydirname . '_';
		}
	}
//endif;

//if( ! function_exists( 'xpress_user_found' ) ) :
	function xpress_user_found($mydirname, $uid){
		$wp_prefix = get_xpress_prefix($mydirname);
		$xoopsDB =& Database::getInstance();
		$db_xpress_users = $xoopsDB->prefix($wp_prefix . 'users');

		$sql = "SELECT ID FROM $db_xpress_users WHERE ID = $uid";
		$res = $xoopsDB->query($sql, 0, 0);
		if ($res === false){
			return false;
		} else {
			if ($xoopsDB->getRowsNum($res)  > 0){
				return true;
			} else {
				return false;
			}
		}
	}
//endif;

//if( ! function_exists( 'xpress2wp_user_level' ) ) :
	function xpress2wp_user_level($level){
		switch($level) {
			case 5:
				return 10;
			case 4:
				return 7;
			case 3:
				return 2;
			case 2:
				return 1;
			case 1:
				return 0;
			default:
				return 0;
		}
	}
//endif;

//if( ! function_exists( 'get_capabillities_name' ) ) :
	function get_capabillities_name($level){
		switch($level) {
			case 10:
				return 'administrator';
			case 7:
				return 'editor';
			case 2:
				return 'author';
			case 1:
				return 'contributor';
			case 0:
				return 'subscriber';
			default:
				return 'subscriber';
		}
	}
//endif;

//if( ! function_exists( 'xpress_usermeta_sync' ) ) :
	function xpress_usermeta_sync($mydirname , $uid,$meta_key,$meta_value){
		$wp_prefix = get_xpress_prefix($mydirname);
		$xoopsDB =& Database::getInstance();		
		$db_xpress_usermeta = $xoopsDB->prefix($wp_prefix . 'usermeta');
		$sql = "SELECT user_id FROM $db_xpress_usermeta WHERE (user_id = $uid) AND (meta_key = $meta_key)";
		$res =  $xoopsDB->query($sql, 0, 0);

		if ($res === false){
			$sql2 = "INSERT INTO $db_xpress_usermeta (user_id,meta_key,meta_value) VALUES ($uid,$meta_key,$meta_value)";
		}else {
			if ($xoopsDB->getRowsNum($res)  > 0){
				
				$sql2 = "UPDATE $db_xpress_usermeta SET meta_value = $meta_value WHERE (user_id = $uid) AND (meta_key = $meta_key)";
			} else {
				$sql2 = "INSERT INTO $db_xpress_usermeta (user_id,meta_key,meta_value) VALUES ($uid,$meta_key,$meta_value)";
			}
		}
		$res = $xoopsDB->queryF($sql2, 0, 0);
		if ($res === false) {
			$ret = "...ERR($sql2)";
			return $ret;
		} else {
			return '';
		}

	}
//endif;

//if( ! function_exists( 'sql_str' ) ) :
	function sql_str($text = ''){
		return "'" . $text . "'";
	}
//endif;
	
//if( ! function_exists( 'xpress_user_sync' ) ) :
	function xpress_user_sync($sync_uid = 0){
		$mydirname = basename( dirname( dirname( __FILE__ ) ) ) ;

		if( is_object( @$GLOBALS["xoopsModule"] ) ) {
			$wp_prefix = get_xpress_prefix($mydirname);
			$xoopsDB =& Database::getInstance();
			$db_xoops_users = $xoopsDB->prefix('users');
			$db_xpress_users = $xoopsDB->prefix($wp_prefix . 'users');

			$ret_str = 'Do Sync';
		
			if ($sync_uid == 0) {
				$xu_sql  = "SELECT uid ,name ,uname ,pass ,email, url, user_regdate, user_aim, user_yim FROM $db_xoops_users";
			} else {
				$xu_sql  = "SELECT uid ,name ,uname ,pass ,email, url, user_regdate, user_aim, user_yim FROM $db_xoops_users WHERE uid = $sync_uid";
			}	

			$xu_res =  $xoopsDB->query($xu_sql, 0, 0);
			if ($xu_res === false){
				$ret_str .= '...ERR ('. $xu_sql . ')';
				return $ret_str;
			}else {
				while($xu_row = 	$xoopsDB->fetchArray($xu_res)){
					$xpress_user_level = get_xpress_user_level($mydirname , $xu_row['uid']);
					if ($xpress_user_level < 1){
						$ret_str .= "...PASS '" . $xu_row['uname'] ."'[uid=".$xu_row['uid'] ."](not xpress user)";
						if ($sync_uid != 0){
							$ret_str .= '...NOT XPRESS USER ' . $xu_row['uname'];
							return $ret_str;
						}
					} else {
						$user_ID = 			$xu_row['uid'];
						$user_level = xpress2wp_user_level($xpress_user_level);
						if ($user_level == 10 ){
							$capabillities_name = 'administrator';
						}else {
							if (!empty($GLOBALS["xoopsModuleConfig"]["use_wp_userlevel"])){
								$capabillities_name = get_option('default_role');		
							}else {
								$capabillities_name = get_capabillities_name($user_level);
							}
						}
						$user_login_name = 	sql_str($xu_row['uname']);
						$user_pass_md5 = 	sql_str( $xu_row['pass']);
						$user_email = 		sql_str( $xu_row['email']);
						$user_url = 		sql_str( $xu_row['url']);
						$user_regist_time = sql_str(date('Y-m-d H:i:s' , $xu_row['user_regdate']));
						$user_nicename =	sql_str( $xu_row['uname']);
						$user_status = 0;
						$user_display_name =sql_str( empty($xu_row['name']) ? $xu_row['uname'] :$xu_row['name'] );
						$user_nickname =	sql_str( empty($xu_row['name']) ? $xu_row['uname'] :$xu_row['name'] );
						$user_aim =			sql_str( $xu_row['user_aim']);
						$user_yim =			sql_str( $xu_row['user_yim']);
						$user_first_name = 	sql_str( $xu_row['uname']);
						$user_last_name = 	sql_str('');
						$user_description = sql_str('');
						$user_jabber = 		sql_str('');
						$user_rich_editing = sql_str('true');

						$is_update = false;
						
//						$capabillities = sql_str(get_capabillities($user_level));
		
						if (xpress_user_found($mydirname, $user_ID)){
							$wu_sql  = 	"UPDATE $db_xpress_users ";
							$wu_sql .= 	'SET ';
							$wu_sql .=		"user_login  = $user_login_name, ";
							$wu_sql .=		"user_pass  = $user_pass_md5, ";
							$wu_sql .=		"user_email = $user_email, ";
							$wu_sql .=		"user_url = $user_url, ";
							$wu_sql .=		"user_nicename = $user_nicename, ";
							$wu_sql .=		"user_registered = $user_regist_time, ";
							$wu_sql .=		"user_status = 0 ";
							$wu_sql .=	"WHERE (ID = $user_ID )";
							if (!empty($GLOBALS["xoopsModuleConfig"]["use_wp_userlevel"])){
								$ret_str .= '...UPDATE ' . $user_login_name . '(Level Not Change)';
							} else {
								$ret_str .= '...UPDATE ' . $user_login_name . '(' . $capabillities_name . ')';
							}
							$is_update = true;
						}else{
							$wu_sql  =	"INSERT INTO $db_xpress_users ";
							$wu_sql .=  	"(ID , user_login , user_pass ,user_email , user_url , user_nicename " ;
							$wu_sql .=		" , user_registered , user_status , display_name) ";
							$wu_sql .=	"VALUES ";
							$wu_sql .=		"($user_ID, $user_login_name, $user_pass_md5, $user_email, $user_url, $user_nicename ";
							$wu_sql .=		" , $user_regist_time, $user_status, $user_display_name)";
							if (!empty($GLOBALS["xoopsModuleConfig"]["use_wp_userlevel"])){
								$ret_str .= '...INSERT ' . $user_login_name . '(' . $capabillities_name . '-WP Default)';
							} else {
								$ret_str .= '...INSERT ' . $user_login_name . '(' . $capabillities_name . ')';
							}
						}
		
						$wu_res = $xoopsDB->queryF($wu_sql, 0, 0);
		
						if ($wu_res === false){
							$ret_str .= '...ERR(' . $wu_sql . ')';
							return $ret_str;
						}
								
						if (!empty($GLOBALS["xoopsModuleConfig"]["use_wp_userlevel"])){
							if (!$is_update){
								$sycc_user = new WP_User($user_ID);
								$sycc_user->set_role($capabillities_name);
							}
						} else {
							$sycc_user = new WP_User($user_ID);
							$sycc_user->set_role($capabillities_name);						
						}

						if( $is_update === false){
							$meta_key = sql_str('nickname');
							$ans =xpress_usermeta_sync($mydirname, $user_ID,$meta_key,$user_nickname);
							if(!empty($ans)){
								$ret_str .= $ans;
								return $ret_str;
							}
							$meta_key = sql_str('first_name');
							$ans =xpress_usermeta_sync($mydirname, $user_ID,$meta_key,$user_first_name);
							if(!empty($ans)){
								$ret_str .= $ans;
								return $ret_str;
							}
							$meta_key = sql_str('last_name');
							$ans =xpress_usermeta_sync($mydirname, $user_ID,$meta_key,$user_last_name);
							if(!empty($ans)){
								$ret_str .= $ans;
								return $ret_str;
							}
							$meta_key = sql_str('description');
							$ans =xpress_usermeta_sync($mydirname, $user_ID,$meta_key,$user_description);
							if(!empty($ans)){
								$ret_str .= $ans;
								return $ret_str;
							}
							$meta_key = sql_str('jabber');
							$ans =xpress_usermeta_sync($mydirname, $user_ID,$meta_key,$user_jabber);
							if(!empty($ans)){
								$ret_str .= $ans;
								return $ret_str;
							}
						}
						$meta_key = sql_str('aim');
						$ans =xpress_usermeta_sync($mydirname, $user_ID,$meta_key,$user_aim);
						if(!empty($ans)){
							$ret_str .= $ans;
							return $ret_str;
						}
						$meta_key = sql_str('yim');
						$ans =xpress_usermeta_sync($mydirname, $user_ID,$meta_key,$user_yim);
						if(!empty($ans)){
							$ret_str .= $ans;
							return $ret_str;
						}
						if ($is_update === false ) {
							$meta_key = sql_str('rich_editing');
							$ans =xpress_usermeta_sync($mydirname, $user_ID,$meta_key,$user_rich_editing);
							if(!empty($ans)){
								$ret_str .= $ans;
								return $ret_str;
							}
						}					
					}
				}
			}
			$ret_str .= "...END";
			return $ret_str;
		}
	}
//endif;

//if( ! function_exists( 'check_user_role_prefix' ) ) :
	function check_user_role_prefix($mydirname){
		$wp_prefix = get_xpress_prefix($mydirname);
		$xoopsDB =& Database::getInstance();		
		$db_xpress_usermeta = $xoopsDB->prefix($wp_prefix . 'usermeta');
		$user_meta_prefix =$xoopsDB->prefix($wp_prefix);
		
		$sql = "SELECT * FROM $db_xpress_usermeta WHERE meta_key LIKE '%_" . $wp_prefix . "user_level' OR meta_key LIKE '%_" . $wp_prefix . "capabilities' OR meta_key LIKE '%_" . $wp_prefix . "autosave_draft_ids'";
		$result =  $xoopsDB->query($sql, 0, 0);
		if ($result === false){
			return -1;
		}else{
			$i=0;
			while($row = $xoopsDB->fetchArray($result)){
				$meta_key = $row['meta_key'];
				if (strpos($meta_key,$user_meta_prefix) === false) {
					$i++;
				}
			}
			return $i;
		}
	}
//endif;

//if( ! function_exists( 'same_metakey_delete' ) ) :
	function same_metakey_delete($mydirname,$metakey){
		$wp_prefix = get_xpress_prefix($mydirname);
		$xoopsDB =& Database::getInstance();		
		$db_xpress_usermeta = $xoopsDB->prefix($wp_prefix . 'usermeta');
		$user_meta_prefix =$xoopsDB->prefix($wp_prefix);
		
		$sql = "DELETE FROM $db_xpress_usermeta WHERE meta_key LIKE '$metakey'";
		$result =  $xoopsDB->query($sql, 0, 0);
		if ($result === false){
			return false;
		}else{
			return true;
		}
	}
//endif;

//if( ! function_exists( 'repair_user_role_prefix' ) ) :
	function repair_user_role_prefix($mydirname){
		$wp_prefix = get_xpress_prefix($mydirname);
		$xoopsDB =& Database::getInstance();		
		$db_xpress_usermeta = $xoopsDB->prefix($wp_prefix . 'usermeta');
		$user_meta_prefix =$xoopsDB->prefix($wp_prefix);
		$ret = '';
		
		$sql = "SELECT * FROM $db_xpress_usermeta WHERE meta_key LIKE '%_" . $wp_prefix . "user_level' OR meta_key LIKE '%_" . $wp_prefix . "capabilities' OR meta_key LIKE '%_" . $wp_prefix . "autosave_draft_ids'";
		$result =  $xoopsDB->queryF($sql, 0, 0);
		if ($result === false){
			return -1;
		}else{
			$i=0;
			while($row = $xoopsDB->fetchArray($result)){
				$meta_key = $row['meta_key'];
				$umeta_id = $row['umeta_id'];
				if (strpos($meta_key,$user_meta_prefix) === false) {
					$new_meta_key = '';
					if (strpos($meta_key,$wp_prefix.'user_level')){
						$new_meta_key = $xoopsDB->prefix($wp_prefix . 'user_level');
					}
					
					if (strpos($meta_key,$wp_prefix.'capabilities')){
						$new_meta_key = $xoopsDB->prefix($wp_prefix . 'capabilities');
					}
					
					if (strpos($meta_key,$wp_prefix.'autosave_draft_ids')){
						$new_meta_key = $xoopsDB->prefix($wp_prefix . 'autosave_draft_ids');
					}
					
					if (!empty($new_meta_key)){
						same_metakey_delete($mydirname,$new_meta_key);

						$repair_sql  = 	"UPDATE $db_xpress_usermeta ";
						$repair_sql .= 	'SET ';
						$repair_sql .=	"meta_key = '$new_meta_key' ";
						$repair_sql .=	"WHERE (umeta_id = $umeta_id )";
						$repair_res = $xoopsDB->queryF($repair_sql, 0, 0);
						if ($repair_res === false){
							$ret .= '...ERR(' . $meta_key . '->' . $new_meta_key . ')<br>';
						} else {
							$ret .= '...DO(' . $meta_key . '->' . $new_meta_key . ')<br>';
						}
					}
				}
			}
		}
		return $ret;
	}
//endif;		

?>