<?php
/*
Plugin Name: Plugin for XPressME
Plugin URI: http://ja.xpressme.info
Description: Plugin for XPressME (custom function,filter,action)
Author: toemon
Version: 1.0
Author URI: http://ja.xpressme.info
*/
require_once('xpressme_class.php');

require_once dirname( __FILE__ ).'/include/custom_functions.php' ;		// XPressME functions for themes
require_once dirname( __FILE__ ).'/include/xpress_common_functions.php' ;

$xoops_db = new wpdb(DB_USER, DB_PASSWORD, DB_NAME, DB_HOST);
$xoops_db->prefix = get_xoops_prefix();
$xoops_db->tables = array('modules', 'newblocks', 'users');

$xpress_config = new XPressME_Class();

require_once dirname( __FILE__ ).'/include/pluggable-override.php' ;
if ($xoops_config->is_wp20)
	require_once dirname( __FILE__ ).'/include/functions_for_wp20.php' ;

add_action('admin_menu', array(&$xpress_config, 'add_option_page'));
add_action('admin_head', array(&$xpress_config, 'add_admin_head'));
add_filter("upload_dir",array(&$xpress_config, 'xpress_upload_filter'),	1);		// Change wp-include/wp_upload_dir()
if (!$xpress_config->is_save_post_revision){
	remove_action( 'pre_post_update', 'wp_save_post_revision' );			// Not Save Post Revision
}
add_action("wp_meta" , "wp_meta_add_xpress_menu");			// add xpress menu  in wp_meta
	
//Site URL check
add_filter('option_home',			"safe_site_url_filter");
add_filter('option_siteurl',		"safe_site_url_filter");
	

//XOOPS Bloack Cache Refresh
add_action("comment_post",	"block_cache_refresh");
add_action("edit_comment",	"block_cache_refresh");
add_action("wp_set_comment_status","block_cache_refresh"); //wp_delete_comment() at deleted
add_action("deleted_post",	"block_cache_refresh");
add_action("publish_post",	"block_cache_refresh");
add_action("edit_post",		"block_cache_refresh");
add_action("private_to_published",	"block_cache_refresh");
add_action("transition_post_status", "block_cache_refresh");

add_action("the_content",	"set_post_views_count");

//XOOPS notifiction
require_once dirname( __FILE__ ).'/include/notify_functions.php' ;
add_action("transition_post_status",	"onaction_publish_post_notify" ,10 , 3);
//	add_action("edit_post",	"onaction_edit_post_notify");
add_action("comment_post",	"onaction_comment_notify");
//	add_action("approve_comment" , "onaction_comment_apobe_notify");
add_action("wp_set_comment_status" , "onaction_comment_apobe_notify");

// user data sync  user_sync_to_xoops($user_id)
require_once dirname( __FILE__ ).'/include/user_sync_xoops.php' ;
add_action('profile_update', 'user_sync_to_xoops');
add_action('user_register', 'user_sync_to_xoops');
//require_once('../include/custom_functions.php');

//D3Forum Comment Integration
if ($xpress_config->is_use_d3forum){
	require_once dirname( __FILE__ ).'/include/d3forum_comment_synchro.php' ;
	add_action("comment_post",	"onaction_comment_post");
	add_action("edit_comment",	"onaction_edit_comment");
	add_action("delete_comment","onaction_delete_comment");
	add_action("delete_post",	"onaction_delete_post");
	add_action("wp_set_comment_status" , "onaction_comment_apobe");
	
	
	add_filter('comments_template', "disp_d3forum_comments" );

}



//The trackback and the pingback are excluded from the count of the comment. 
add_filter('get_comments_number', 'xpress_comment_count', 0);

// Query filter for  MultiUser
add_filter('query','xpress_query_filter');
//add_action("init", "xpress_set_author_cookie");
if(xpress_is_wp20()){
	// It is called before parse_request() makes $GET. 
	add_action("query_vars", "xpress_set_author_cookie");
} else {
	// It is called at the end of parse_request(). 
	add_filter('request', 'xpress_set_author_cookie');
}

// SQL debug windows
add_filter('query', array(&$xpress_config, 'xpress_sql_debug'));
add_action('admin_footer', array(&$xpress_config, 'displayDebugLog'));
add_action('wp_footer', array(&$xpress_config, 'displayDebugLog'));

?>