<?php
	
if(!function_exists("xpress_block_cache_set")):
    function xpress_block_cache_set($mydirname,$collation_key)
    {
		$cache_dir = XOOPS_ROOT_PATH . '/cache/';
		$cache_time = 0;
        $filename = $cache_dir .$mydirname . '_' . $collation_key;
        if (file_exists($filename) && ((time() - filemtime($filename)) < $cache_time)) {
            return file_get_contents($filename);
        } else {
			return '';
		}
    } 
endif;

if(!function_exists("xpress_cache_make")):
    function xpress_cache_make($mydirname,$collation_key,$content)
    {
		$cache_dir = XOOPS_ROOT_PATH . '/cache/';
		$cache_time = 0;

        $filename = $cache_dir .$mydirname . '_' . $collation_key;
        if ((time() - @filemtime($filename)) > $cache_time) {
            $fp = fopen($filename, "w");
            flock($fp, 2);
            fputs($fp, $content);
            fclose($fp);
        } 
    } 
endif;

if(!function_exists("xpress_block_cache_clear")):
    function xpress_cache_clear($mydirname)
    {
		$cache_dir = XOOPS_ROOT_PATH . '/cache/';
		$cache_time = 0;
        if ($dh = opendir($cache_dir)) {
            while (($file = readdir($dh)) !== false) {
                if (preg_match('/^' . preg_quote($mydirname) . '/', $file)) {
                    unlink($cache_dir.$file);
                } 
            } 
            closedir($dh);
        } 
    } 
endif;

?>