<?php

if( ! function_exists( 'yes_no_radio_option' ) ) :
function yes_no_radio_option($option_name,$label,$value,$yes = '',$no= ''){
	if (empty( $yes ))  $yes = _YES ;
	if (empty( $no ))  $no = _NO ;
	$form = $label.' : ';
	if ($value){
		$form .= "<input type='radio' name='". $option_name . "' value='1' checked='checked' />" . $yes. "; " ;
		$form .= "<input type='radio' name='". $option_name . "' value='0' />". $no ;
	}else{
		$form .= "<input type='radio' name='". $option_name . "' value='1' />" . $yes. "; " ;
		$form .= "<input type='radio' name='". $option_name . "' value='0' checked='checked' />". $no ;
	}		
    return $form;
	
}
endif;

if(!function_exists("dropdown_cats_options")):
function dropdown_cats_options($sort_column = 'ID', $sort_order = 'asc', $selected=array()) 
{
    global $wpdb, $wp_query, $wp_rewrite, $wp_roles;

	$path = dirname(dirname(__FILE__)) . '/';
	if (file_exists($path . 'wp-load.php')) {
		require_once $path . 'wp-load.php';
	} else {
		require_once $path . 'wp-config.php';
	}

	$myts =& MyTextSanitizer::getInstance();
    $selected = is_array($selected)?$selected:array($selected);
    $sort_column = 'cat_'.$sort_column;
	if ($wp_db_version < 6124) {
		$query = "
	    	SELECT cat_ID, cat_name, category_nicename,category_parent 
	    	FROM $wpdb->categories 
	    	WHERE cat_ID > 0 
	        ";
	$query .= " ORDER BY $sort_column $sort_order";

    } else {
    	$query = "
			SELECT $wpdb->terms.term_id as cat_ID , $wpdb->terms.name as cat_name , $wpdb->term_taxonomy.taxonomy 
			FROM $wpdb->terms LEFT JOIN $wpdb->term_taxonomy ON $wpdb->terms.term_id = $wpdb->term_taxonomy.term_id 
			WHERE $wpdb->term_taxonomy.taxonomy = 'category' 
        ";
		$query .= " ORDER BY $sort_column $sort_order";
    }

    $categories = $wpdb->get_results($query);
    if ($categories) {
        foreach ($categories as $category) {
            $cat_name = apply_filters('list_cats', $category->cat_name, $category);
            echo "\t<option value=\"".$category->cat_ID."\"";
            if (in_array($category->cat_ID, $selected))
                echo ' selected="selected"';
            echo '>';
            echo $myts->htmlspecialchars($cat_name);
            echo "</option>\n";
        }
    }
    return;
}
endif;



?>