<?php
/*
 * XPressME - WordPress for XOOPS
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @package		module::xpress
 */

if (defined( 'XOOPS_MAINFILE_INCLUDED')) :

class modInfoClass {
	var $xoops_mainfile_path;
	var $xoops_root_path;
	var $xoops_url;
	var $xoops_trust_path;
	var $xoops_var_path;
	var $xoops_cache_path;
	var $xoops_upload_path;
	var $xoops_upload_url;
	var $xoops_db_salt;
	var $xoops_salt;
	var $xoops_db_prefix;
	var $xoops_language;
	var $module_db_prefix;
	var $module_name;
	var $module_path;
	var $module_url;
	var $module_version;
	var $module_codename;
	var $module_id;
	var $xoops_version;
	var $is_impress_cms;
	var $is_cube_legacy;
	var $is_xoops2jp;
	var $is_xoops2;
	var $is_xoops_legacy;
	var $is_jpex;
	var $xoops_time_zone;
	var $wp_version;
	var $wpConfigInfo;
	
	function __constructor()	//for PHP5
    {
        $this->modInfoClass();
       
    }
    
    function modInfoClass()	//for PHP4 constructor
    {  
    	global $xoopsModule,$wpConfigInfo;
    	if (is_object($wpConfigInfo)){
    		include_once dirname(__FILE__).'/wpConfigInfo_class.php';
    		$this->wpConfigInfo = new wpConfigInfoClass;
    	}
		$this->xoops_root_path = XOOPS_ROOT_PATH;
		$this->xoops_trust_path = (defined('XOOPS_TRUST_PATH')) ? XOOPS_TRUST_PATH : '';
		$this->xoops_url = XOOPS_URL;
    	$this->xoops_mainfile_path = XOOPS_ROOT_PATH . '/mainfile.php';
		$this->xoops_upload_path = XOOPS_UPLOAD_PATH;
		$this->xoops_upload_url = XOOPS_UPLOAD_URL;
		$this->xoops_cache_path = XOOPS_CACHE_PATH;
    	$this->module_path=dirname(dirname(__FILE__));
    	$this->module_name=basename($this->module_path);
		$this->module_url = $this->xoops_url . '/modules/' . $this->module_name;
		$this->xoops_db_prefix = XOOPS_DB_PREFIX . '_';
		$this->module_db_prefix = $this->_get_module_db_prefix();
		$this->xoops_lang =  @$GLOBALS["xoopsConfig"]['language'];
		$this->module_id =! empty($xoopsModule) ? $xoopsModule->getVar('mid') : 0;
		$this->module_version = empty($xoopsModule) ? $xoopsModule->getVar('version') : '';
		$this->module_codename = $this->_get_module_codename();
		$this->wp_version = $this->_get_wp_version();
		
		$this->xoops_version = (defined('XOOPS_VERSION')) ? XOOPS_VERSION : '';
    	$this->_branches_cores();
		
		if (function_exists('date_default_timezone_get')){
			$this->xoops_time_zone = date_default_timezone_get();
		}

    }

	function _get_module_db_prefix(){
    	$module_db_prefix = XOOPS_DB_PREFIX . '_' . preg_replace('/wordpress/','wp',$this->module_name);
    	return $module_db_prefix;
	}
    function _branches_cores(){
    	/*  XOOPS include/version.php define value */
		//define("XOOPS_VERSION","XOOPS 2.0.16a JP");
		//define("XOOPS_VERSION", "XOOPS Cube Legacy 2.2");
		//define('XOOPS_VERSION', 'ImpressCMS 1.1.2 Final');
		//define("XOOPS_VERSION", "XOOPS JPEx 1.6");
		//define("XOOPS_VERSION", "XOOPS 2.3.3");
		//define("XOOPS_VERSION", "Xoops Legacy");	define("XOOPS_ENGINE", "legacy");
    	$this->is_impress_cms = false;
		$this->is_cube_legacy = false;
		$this->is_xoops2jp = false;
		$this->is_xoops2 = false;
		$this->is_xoops_legacy = false;
		$this->is_jpex = false;
		
		$version = XOOPS_VERSION;
		
		
    	// branches by cores
		if( preg_match('/JP$/', $this->xoops_version))
			$this->is_xoops2jp = true;
		if( preg_match('/Cube\s*Legacy/', $this->xoops_version))
			$this->is_cube_legacy = true;
		if( preg_match('/ImpressCMS/', $this->xoops_version))
			$this->is_impress_cms = true;
		if( preg_match('/JPEx/', $this->xoops_version))
			$this->is_jpex = true;
		if( preg_match('/XOOPS\s*[0-9|\.]*$/', $this->xoops_version))
			$this->is_xoops2 = true;
		if( preg_match('/Xoops\s*Legacy/', $this->xoops_version))
			$this->is_xoops_legacy = true;
	}
    function _get_wp_version(){
    	$wp_version_file =  dirname(dirname(__FILE__)) . '/wp-includes/version.php';
    	if (file_exists($wp_version_file)){
    		include $wp_version_file;
    		return str_replace("ME", "", $wp_version);
    	}
    	return '';
    }
	
    // get XPressME module virsion and codename from xoops_versions.php
    function _get_module_codename(){
    	$xoops_version_file = $this->module_path . '/xoops_version.php';
		if(file_exists($xoops_version_file)){
			$version_file = file($xoops_version_file);
			$codename_pattern = '^\s*(\$modversion\[\s*\'codename\'\s*\])\s*=\s*[\'"]([^\'"]*)[\'"]';
			for ($i = 0 ; $i <count($version_file) ; $i++){
				if (preg_match( "/$codename_pattern/", $version_file[$i] ,$c_matches )){
					return $c_matches[2];
				}
			}
		}
		return '';
    }
	function get_xoops_db_prefix(){
		return $this->xoops_db_prefix;
	}
	
	function get_xoops_root_path(){
		return $this->xoops_root_path;
	}
	function get_xoops_trust_path(){
		return $this->xoops_trust_path;
	}
	function get_xoops_mainfile_path(){
		return $this->xoops_mainfile_path;
	}
	function get_xoops_header_path(){
		return $this->xoops_root_path ."/header.php";
	}
	function get_xoops_footer_path(){
		return $this->xoops_root_path . '/footer.php';
	}
	function get_xoops_cache_path(){
		return $this->xoops_cache_path;
	}
	function get_xoops_url(){
		return $this->xoops_url;
	}
	function get_xoops_upload_path(){
		return $this->xoops_upload_path;
	}
	function get_xoops_upload_url(){
		return $this->xoops_upload_url;
	}
	function get_module_path(){
		return $this->module_path;
	}
	function get_module_templates_path(){
		return $this->module_path . '/templates';
	}
	
	function get_module_name(){
		return $this->module_name;
	}
	function get_module_dirname(){
		return $this->module_name;
	}
	function get_module_url(){
		return $this->module_url;
	}
 	function get_module_db_prefix(){
		return $this->xpress_db_prefix;
	}
 	function get_xoops_time_zone(){
		return $this->xoops_time_zone;
	}
 	function get_module_version(){
		return $this->module_version;
	}
 	function get_module_codename(){
		return $this->module_codename;
	}
 	function get_wp_version(){
		return $this->wp_version;
	}
 	function get_module_full_version(){
		return $this->module_version . $this->module_codename;
	}
	
 	function is_impress_cms(){
		return $this->is_impress_cms;
	}
 	function is_cube_legacy(){
		return $this->is_cube_legacy;
	}
 	function is_xoops2jp(){
		return $this->is_xoops2jp;
	}
 	function is_xoops2(){
		return $this->is_xoops2;
	}
 	function is_xoops_legacy(){
		return $this->is_xoops_legacy;
	}
 	function is_jpex(){
		return $this->is_jpex;
	}
	
	function get_moduleID_ByDirname($dir_name){
		$module_handler =& xoops_gethandler('module');
		$module =& $module_handler->getByDirname($dir_name);
		$module_id = $module->getVar('mid');
	}
	
	function get_moduleID(){
		global $xoopsModule;
		$module_id = $xoopsModule->getVar('mid');
		return $module_id;
	}
	
	function get_ModuleConfig($key_name=''){
		if (empty($key_name)) return '';
		global $xoopsModuleConfig;
		$value = isset($xoopsModuleConfig[$key_name]) ? $xoopsModuleConfig[$key_name] : '';
	}
	
	function get_ModuleConfig_ByDirname($dir_name,$key_name=''){
		$mid = $this->get_moduleID_ByDirname($dir_name);
		$conf_handler =& xoops_gethandler('config');
		$modConfig = $conf_handler->getConfigsByCat(0, $mid);
		if(empty($modConfig)) return '';
		if(empty($key_name)) return $modConfig;
		return isset($modConfig[$key_name]) ? $modConfig[$key_name] : '';
	}
   
   	function is_wpdb_installed(){
   		global $xoopsDB;
		$mydirname = basename(dirname( dirname( __FILE__ ) )) ;
		$prefix_mod = XOOPS_DB_PREFIX .'_' . preg_replace('/wordpress/','wp',$mydirname) . '_';
		$sql = "SHOW TABLES LIKE '$prefix_mod%'";
		if ($result = $xoopsDB->queryf($sql)){
			if($xoopsDB->getRowsNum($result))  return true;
		}
		return false;
	}
	function is_wp_file_found()
	{
		if (!file_exists($this->module_path . '/wp-settings.php')){
			return false;
		}
		return true;
	}

	function is_writeable_mode($check_file) {
        if (!is_dir($check_file)) {
           if ( file_exists($check_file) ) {
                if (! is_writeable($check_file)) {
                    return false;
				}
            }
        } else {
            if (! is_writeable($check_file)) {
                return false;
            } else {
            	// Windows parmission check
            	$src_file = __FILE__ ;
				$newfile = $check_file . 'write_check.txt';
				if (!@copy($src_file, $newfile)) {
                	return false;
				} else {
					unlink($newfile);
				}
			}
        }
    	return true;
	}
	function get_php_version()
	{
		if (function_exists('phpversion'))
			return phpversion();
		else 
			return '';
	}
	function get_mysql_version()
	{
		global $xoopsDB;
		list($SV) = $xoopsDB->fetchRow($xoopsDB->query('SELECT version()'));
		return $SV;
	}
	public function get_mod_image_link($file_name='') 
	{
		$link_url = '';
		if(!empty($file_name)){
			if(file_exists($this->module_path.'/images/'.$file_name)){
				$link_url = '<img alt="'.$file_name.'" src="'. $this->mod_url .'/images/'.$file_name.'" title="'.$file_name.'" align=top>';
			}
		}
		return $link_url;
	}
	function get_wpLang($xoops_lang=''){
		return $this->wpConfigInfo->get_wpLang($xoops_lang);
	}
	
}
endif;
?>