<?php
$xoopsOption['nocommon'] = true ;
require '../../mainfile.php' ;
$mydirpath = dirname(__FILE__);
$mydirname = basename(dirname(__FILE__));
$icon_cache_limit = 3600 ; // default 3600sec == 1hour

session_cache_limiter('public');
header("Expires: ".date('r',intval(time()/$icon_cache_limit)*$icon_cache_limit+$icon_cache_limit));
header("Cache-Control: public, max-age=$icon_cache_limit");
header("Last-Modified: ".date('r',intval(time()/$icon_cache_limit)*$icon_cache_limit));
header("Content-type: image/png");

// file name
if( ! empty( $_GET['file'] ) ) {
	$file_base = preg_replace( '/[^0-9a-z_]/' , '' , $_GET['file'] ) ;
} else {
	$file_base = 'module_icon' ;
}

// branches by cores
if( defined( 'ICMS_TRUST_PATH' ) ) {
	$draw_dirname = false ;
	$file_base .= '_icms' ;
} else if( defined( 'XOOPS_CUBE_LEGACY' ) ) {
	$draw_dirname = true ;
	$file_base .= '_xcl' ;
	$title = '('.$mydirname.')';
	$px = ( 112 - 6 * strlen( $title ) ) ;
	$py = 14;
	$font = 3;

} else {
	$draw_dirname = true ;
	$title = $mydirname;
	$px = ( 92 - 6 * strlen( $title ) ) / 2 ;
	$py = 34;
	$font = 3;
}

// icon files must be PNG
$file = $file_base . '.png' ;

// custom icon
if( file_exists( $mydirpath.'/'.$file ) ) {
	$draw_dirname = false ;
	$icon_fullpath = $mydirpath.'/module_icon.png' ;
} else {
	$icon_fullpath = dirname(__FILE__).'/images/'.$file ;
}

if( $draw_dirname && function_exists( 'imagecreatefrompng' ) && function_exists( 'imagecolorallocate' ) && function_exists( 'imagestring' ) && function_exists( 'imagepng' ) ) {

	$im = imagecreatefrompng( $icon_fullpath ) ;

	$color = imagecolorallocate( $im , 0 , 0 , 0 ) ; // black
	imagestring( $im , $font , $px , $py , $title , $color ) ;
	imagepng( $im ) ;
	imagedestroy( $im ) ;

} else {

	readfile( $icon_fullpath ) ;

}

?>