<?php
/*	
 * The default authority setting value given by a new user of WordPress
*/
function get_default_capabillities(){
	global $xoops_db;
	$db_option = get_wp_prefix() . 'options';
	return $xoops_db->get_var("SELECT option_value FROM $db_option WHERE option_name = 'default_role'");
}

/*
 * Get The level from the capabillities name.
 */
function get_role_level($capabillities){
	if ($capabillities == 'default') $capabillities = get_default_capabillities();
	switch($capabillities) {
		case 'administrator':
			return 5;
		case 'editor':
			return 4;
		case 'author':
			return 3;
		case 'contributor':
			return 2;
		case 'subscriber':
			return 1;
		default:
			return 0;
	}
}

/*
 * The highest authority and the accompanying data
 * in the WordPress authority given to the group to which the user belongs are obtained. 
*/
	function get_xoops_group_role($mydirname , $uid=0){
		$ans = array();
		if ($uid == 0){
			return '';
		}
		
		global $xoops_db;
		$db_groups_users_link = get_xoops_prefix() . 'groups_users_link';
		$db_group_role = get_wp_prefix() . 'group_role';
		
		$sql  = "SELECT * ";
		$sql .= "FROM $db_groups_users_link ";
		$sql .= "LEFT JOIN $db_group_role ON $db_groups_users_link.groupid = $db_group_role.groupid ";
		$sql .= "WHERE  uid = $uid";
	
		$user_groups = $xoops_db->get_results($sql);
		$ans['capabillities'] = '';
		$ans['allway_update'] = 0;
		
		foreach($user_groups as $user_group){
			$before_level = get_role_level($ans['capabillities']);
			$now_level = get_role_level($user_group->role);
			if ($now_level > $before_level){
				$ans['capabillities'] = $user_group->role;
				$ans['allway_update'] = $user_group->login_all;
			}
		}
		return $ans;
	}
	
/*
 * Get User ID of WordPress from the login name. 
*/
function get_wp_user_id($login_name){
	global $xoops_db;
	$sql = "SELECT ID FROM " . get_wp_prefix() . "users WHERE user_login = '$login_name'";
	$uid = $xoops_db->get_var($sql);
	return $uid;
}


//if( ! function_exists( 'xpress_usermeta_sync' ) ) :
	function xpress_usermeta_sync($mydirname , $uid,$meta_key,$meta_value, &$message){
		$wp_prefix = get_wp_prefix();
		$meta_key = "'" . $meta_key . "'";
		$meta_value = "'" . $meta_value . "'";
		$xoopsDB =& Database::getInstance();
		$db_xpress_usermeta = $xoopsDB->prefix($wp_prefix . 'usermeta');
		$sql = "SELECT user_id FROM $db_xpress_usermeta WHERE (user_id = $uid) AND (meta_key = $meta_key)";
		$res =  $xoopsDB->query($sql, 0, 0);

		if ($res === false){
			$sql2 = "INSERT INTO $db_xpress_usermeta (user_id,meta_key,meta_value) VALUES ($uid,$meta_key,$meta_value)";
		}else {
			if ($xoopsDB->getRowsNum($res)  > 0){
				
				$sql2 = "UPDATE $db_xpress_usermeta SET meta_value = $meta_value WHERE (user_id = $uid) AND (meta_key = $meta_key)";
			} else {
				$sql2 = "INSERT INTO $db_xpress_usermeta (user_id,meta_key,meta_value) VALUES ($uid,$meta_key,$meta_value)";
			}
		}
		$res = $xoopsDB->queryF($sql2, 0, 0);
		if ($res === false) {
			$message .= "...ERR($sql2)";
			return false;
		} else {
			return true;
		}

	}
//endif;

/*
 * The user data of XOOPS is written in the WordPress user data. 
 * If $sync_uid is 0, all users are written. 
*/
function user_sync_to_wordpress($sync_uid = 0, &$message)
	global $xoops_db;
	global $xoopsModule;

	$mydirname = basename( dirname( dirname( dirname( dirname( dirname( __FILE__ ) ) ) ) ) );

	if( is_object($xoopsModule)) {
		$db_xoops_users = get_xoops_prefix() . 'users';
		$db_xpress_users = get_wp_prefix() . 'users';

		$message = 'Do Sync';
	
		if ($sync_uid == 0) {
			$xu_sql  = "SELECT uid ,name ,uname ,pass ,email, url, user_regdate, user_aim, user_yim FROM $db_xoops_users";
		} else {
			$xu_sql  = "SELECT uid ,name ,uname ,pass ,email, url, user_regdate, user_aim, user_yim FROM $db_xoops_users WHERE uid = $sync_uid";
		}

		$xoops_users = $xoops_db->get_results($xu_sql);
		if (empty($xoops_users)){
			$message .= '...ERR ('. $xu_sql . ')';
			return false;
		}

		foreach($xoops_users as $xoops_user){
			$role = get_xoops_group_role($mydirname , $xoops_user->uid);
			$capabillities_name = $role['capabillities'];
			$allway_update = $role['allway_update'];
			if (empty($capabillities_name)){
					$message .= "...PASS '" . $xoops_user->uname ."'[uid=".$xoops_user->uid ."](not xpress user)";
				if ($sync_uid != 0){
					$message .= '...NOT XPRESS USER ' . $xoops_user->uname;
					return false;
				}
			} else {
				$user_ID = 			$xoops_user->uid;
				$user_login_name = 	$xoops_user->uname;
				$user_pass_md5 = 	$xoops_user->pass;
				$user_email = 		$xoops_user->email;
				$user_url = 		$xoops_user->url;
				$user_regist_time = date('Y-m-d H:i:s' , $xoops_user->user_regdate);
				$user_nicename =	$xoops_user->uname;
				$user_status = 0;
				$user_display_name =empty($xoops_user->name) ? $xoops_user->uname :$xoops_user->name ;
				$user_nickname =	empty($xoops_user->name) ? $xoops_user->uname :$xoops_user->name ;
				$user_aim =			$xoops_user->user_aim;
				$user_yim =			$xoops_user->user_yim;
				$user_first_name = 	$xoops_user->uname;
				$user_last_name = 	'';
				$user_description = '';
				$user_jabber = 		'';
				$user_rich_editing = 'true';

				$is_update = false;
				
				$wp_user_id = get_wp_user_id($user_login_name) ;
				if ($wp_user_id){
					$wu_sql  = 	"UPDATE $db_xpress_users ";
					$wu_sql .= 	'SET ';
					$wu_sql .=		"user_pass  = '$user_pass_md5', ";
					$wu_sql .=		"user_email = '$user_email', ";
					$wu_sql .=		"user_url = '$user_url', ";
					$wu_sql .=		"user_nicename = '$user_nicename', ";
					$wu_sql .=		"user_registered = '$user_regist_time', ";
					$wu_sql .=		"user_status = 0 ";
					$wu_sql .=	"WHERE (user_login = '$user_login_name' )";

					$xoops_db->query($wu_sql);
					if ($allway_update){
						$sycc_user = new WP_User($wp_user_id);
						$sycc_user->set_role($capabillities_name);
						$message .= '...UPDATE ' . $user_login_name . '(' . $capabillities_name . ')';

					} else {
						$message .= '...UPDATE ' . $user_login_name . '(Level Not Change)';
					}
				}else{
					$wu_sql  =	"INSERT INTO $db_xpress_users ";
					$wu_sql .=  	"(user_login , user_pass ,user_email , user_url , user_nicename " ;
					$wu_sql .=		" , user_registered , user_status , display_name) ";
					$wu_sql .=	"VALUES ";
					$wu_sql .=		"('$user_login_name', '$user_pass_md5', '$user_email', '$user_url', '$user_nicename' ";
					$wu_sql .=		" , '$user_regist_time', $user_status, '$user_display_name')";
					$xoops_db->query($wu_sql);
					$wp_user_id = get_wp_user_id($user_login_name) ;					
					$sycc_user = new WP_User($wp_user_id);
					$sycc_user->set_role($capabillities_name);						
					$message .= '...INSERT ' . $user_login_name . '(' . $capabillities_name . ')';
				}

				if(!xpress_usermeta_sync($mydirname, $user_ID,'nickname',$user_nickname,$message) )return false;
				if(!xpress_usermeta_sync($mydirname, $user_ID,'first_name',$user_first_name,$message) )return false;
				if(!xpress_usermeta_sync($mydirname, $user_ID,'last_name',$user_last_name,$message) )return false;
				if(!xpress_usermeta_sync($mydirname, $user_ID,'description',$user_description,$message) )return false;
				if(!xpress_usermeta_sync($mydirname, $user_ID,'jabber',$user_jabber,$message) )return false;
				if(!xpress_usermeta_sync($mydirname, $user_ID,'aim',$user_aim,$message) )return false;
				if(!xpress_usermeta_sync($mydirname, $user_ID,'yim',$user_yim,$message) )return false;
				if ($is_update === false ) {
					if(!xpress_usermeta_sync($mydirname, $user_ID,'rich_editing',$user_rich_editing,$message) )return false;
				}			
			}
		}
		$message .= "...END";
		return true;
	}
}

//if( ! function_exists( 'check_user_role_prefix' ) ) :
	function check_user_role_prefix($mydirname){
		$wp_prefix = get_wp_prefix();
		$xoopsDB =& Database::getInstance();		
		$db_xpress_usermeta = $xoopsDB->prefix($wp_prefix . 'usermeta');
		$user_meta_prefix =$xoopsDB->prefix($wp_prefix);
		
		$sql = "SELECT * FROM $db_xpress_usermeta WHERE meta_key LIKE '%_" . $wp_prefix . "user_level' OR meta_key LIKE '%_" . $wp_prefix . "capabilities' OR meta_key LIKE '%_" . $wp_prefix . "autosave_draft_ids'";
		$result =  $xoopsDB->query($sql, 0, 0);
		if ($result === false){
			return -1;
		}else{
			$i=0;
			while($row = $xoopsDB->fetchArray($result)){
				$meta_key = $row['meta_key'];
				if (strpos($meta_key,$user_meta_prefix) === false) {
					$i++;
				}
			}
			return $i;
		}
	}
//endif;

//if( ! function_exists( 'same_metakey_delete' ) ) :
	function same_metakey_delete($mydirname,$metakey){
		$wp_prefix = get_wp_prefix();
		$xoopsDB =& Database::getInstance();		
		$db_xpress_usermeta = $xoopsDB->prefix($wp_prefix . 'usermeta');
		$user_meta_prefix =$xoopsDB->prefix($wp_prefix);
		
		$sql = "DELETE FROM $db_xpress_usermeta WHERE meta_key LIKE '$metakey'";
		$result =  $xoopsDB->query($sql, 0, 0);
		if ($result === false){
			return false;
		}else{
			return true;
		}
	}
//endif;

//if( ! function_exists( 'repair_user_role_prefix' ) ) :
	function repair_user_role_prefix($mydirname){
		$wp_prefix = get_wp_prefix();
		$xoopsDB =& Database::getInstance();		
		$db_xpress_usermeta = $xoopsDB->prefix($wp_prefix . 'usermeta');
		$user_meta_prefix =$xoopsDB->prefix($wp_prefix);
		$ret = '';
		
		$sql = "SELECT * FROM $db_xpress_usermeta WHERE meta_key LIKE '%_" . $wp_prefix . "user_level' OR meta_key LIKE '%_" . $wp_prefix . "capabilities' OR meta_key LIKE '%_" . $wp_prefix . "autosave_draft_ids'";
		$result =  $xoopsDB->queryF($sql, 0, 0);
		if ($result === false){
			return -1;
		}else{
			$i=0;
			while($row = $xoopsDB->fetchArray($result)){
				$meta_key = $row['meta_key'];
				$umeta_id = $row['umeta_id'];
				if (strpos($meta_key,$user_meta_prefix) === false) {
					$new_meta_key = '';
					if (strpos($meta_key,$wp_prefix.'user_level')){
						$new_meta_key = $xoopsDB->prefix($wp_prefix . 'user_level');
					}
					
					if (strpos($meta_key,$wp_prefix.'capabilities')){
						$new_meta_key = $xoopsDB->prefix($wp_prefix . 'capabilities');
					}
					
					if (strpos($meta_key,$wp_prefix.'autosave_draft_ids')){
						$new_meta_key = $xoopsDB->prefix($wp_prefix . 'autosave_draft_ids');
					}
					
					if (!empty($new_meta_key)){
						same_metakey_delete($mydirname,$new_meta_key);

						$repair_sql  = 	"UPDATE $db_xpress_usermeta ";
						$repair_sql .= 	'SET ';
						$repair_sql .=	"meta_key = '$new_meta_key' ";
						$repair_sql .=	"WHERE (umeta_id = $umeta_id )";
						$repair_res = $xoopsDB->queryF($repair_sql, 0, 0);
						if ($repair_res === false){
							$ret .= '...ERR(' . $meta_key . '->' . $new_meta_key . ')<br>';
						} else {
							$ret .= '...DO(' . $meta_key . '->' . $new_meta_key . ')<br>';
						}
					}
				}
			}
		}
		return $ret;
	}
//endif;		


/*
 * Get User ID of XOOPS from the login name. 
*/
function get_xoops_user_id($login_name){
	global $xoops_db;
	$sql = "SELECT uid FROM " . get_xoops_prefix() . "users WHERE uname = '$login_name'";
	$uid = $xoops_db->get_var($sql);
	return $uid;	
}

/*
 *The user data of wordpress is written in the xoops user data. 
*/
function user_sync_to_xoops($user_ID){
	global $xoops_db;
	
	$user_info = get_userdata($user_ID);
	$xoops_uid = get_xoops_user_id($user_info->user_login);
	$db_xoops_users = get_xoops_prefix() . "users";
	$user_regdate  = strtotime($user_info->user_registered);
	$aim = get_usermeta($user_ID,'aim');
	$yim = get_usermeta($user_ID,'yim');	
	
	if ($xoops_uid){
		$wu_sql  = 	"UPDATE $db_xoops_users ";
		$wu_sql .= 	'SET ';
		$wu_sql .=		"uname  = '$user_info->user_login', ";
		$wu_sql .=		"pass = '$user_info->user_pass', ";
		$wu_sql .=		"email = '$user_info->user_email', ";
		$wu_sql .=		"url = '$user_info->user_url', ";
		$wu_sql .=		"name = '$user_info->display_name', ";
		$wu_sql .=		"user_aim = '$aim', ";
		$wu_sql .=		"user_yim = '$yim', ";
		$wu_sql .=		"user_regdate = $user_regdate ";
		$wu_sql .=	"WHERE (uid = $xoops_uid )";
		$xoops_db->query($wu_sql);
	}else{
		$wu_sql  =	"INSERT INTO $db_xoops_users ";
		$wu_sql .=  	"(uname , pass ,email , url , name , user_aim , user_yim , user_regdate) " ;
		$wu_sql .=	"VALUES ";
		$wu_sql .=		"('$user_info->user_login', '$user_info->user_pass', '$user_info->user_email', '$user_info->user_url', '$user_info->display_name' ";
		$wu_sql .=		" , '$aim' , '$yim' , $user_regdate )";
		$xoops_db->query($wu_sql);
		// get xoops users default groupe ID
		$db_xoops_group = get_xoops_prefix() . 'groups';
		$default_xoops_group_id = $xoops_db->get_var("SELECT groupid FROM $db_xoops_group WHERE group_type = 'User'");
		// get insert users  ID
		$db_xoops_group = get_xoops_prefix() . 'users';
		$user_id = $xoops_db->get_var("SELECT uid FROM $db_xoops_group WHERE uname = '$user_info->user_login'");
		// insert groups_users_link 
		$db_xoops_group_users_link = get_xoops_prefix() . 'groups_users_link';
		$default_xoops_group_id = $xoops_db->get_var("INSERT INTO $db_xoops_group_users_link (groupid , uid ) VALUES ($default_xoops_group_id , $user_id)");
	}
}
?>