<?php
	require_once dirname( __FILE__ ) .'/xml.php' ;
	require_once dirname( __FILE__ ) .'/xpress_cache.php' ;
	
	function xpress_block_cache_write($mydirname,$block_name,$block)
	{
			$xml = xpress_XML_serialize($block);
			$xml_name = $block_name . '.xml';
			xpress_cache_write($mydirname,$xml_name,$xml);
	}
	function xpress_block_cache_read($mydirname,$block_name)
	{
			$xml_name = $block_name . '.xml';
			$xml_data = xpress_cache_read($mydirname,$xml_name);
			return @xpress_XML_unserialize($xml_data);
	}
	
	function get_block_id($mydirname,$func_file,$options)
	{
		$options_string = '';
		foreach ($options as $val){
			if (!empty($options_string)) $options_string .='|';
			$options_string .= $val;
		}
			$xoopsDB =& Database::getInstance();
			$block_tbl = $xoopsDB->prefix('newblocks');	
			$module_dir = XOOPS_ROOT_PATH . '/modules/' . $mydirname;

			$sql = "SELECT bid FROM $block_tbl WHERE (func_file LIKE '$func_file') AND (options LIKE '$options_string')";
			$result =  $xoopsDB->query($sql, 0, 0);
			if ($xoopsDB->getRowsNum($result)  > 0){
				$row = $xoopsDB->fetchArray($result);
				$block_id = $row['bid'];
			}
			return $block_id;
	}

	function get_xpress_theme_name($mydirname)
	{
		global $wpdb;
		
		if (is_null($wpdb)){
			$xoopsDB =& Database::getInstance();
			$wp_prefix = $mydirname;
			if ($wp_prefix == 'wordpress') $wp_prefix = 'wp';

			$module_tbl = $xoopsDB->prefix($wp_prefix).'_options';	
			$theme_name = '';	

			$sql = "SELECT option_value FROM $module_tbl WHERE option_name LIKE 'template'";
			$result =  $xoopsDB->query($sql, 0, 0);
			if ($xoopsDB->getRowsNum($result)  > 0){
				$row = $xoopsDB->fetchArray($result);
				$theme_name = $row['option_value'];
			}
		} else {
			$theme_name = get_option('template');
		}
		return $theme_name;
	}

	function get_block_stylesheet_url($mydirname)
	{
		$mydirpath = XOOPS_ROOT_PATH . '/modules/' . $mydirname;
		$select_theme = get_xpress_theme_name($mydirname);
		$style_file = $mydirpath . '/wp-content/themes/' . $select_theme . '/blocks/style.css';
		if (file_exists($style_file))
			return XOOPS_URL . '/modules/' .$mydirname . '/wp-content/themes/' . $select_theme . '/blocks/style.css';
		else	
			return XOOPS_URL . '/modules/' .$mydirname . '/wp-content/themes/xpress_default/blocks/style.css';
	}

	function xpress_block_css_set($mydirname = '')
	{
		$style_url =  get_block_stylesheet_url($mydirname);
		  
		$tplVars =& $GLOBALS['xoopsTpl']->get_template_vars();
		$csslink = "\n".'<link rel="stylesheet" type="text/css" media="screen" href="'. $style_url .'" />';
			if(array_key_exists('xoops_block_header', $tplVars)) {
				if (!strstr($tplVars['xoops_block_header'],$csslink)) {
					$GLOBALS['xoopsTpl']->assign('xoops_block_header',$tplVars['xoops_block_header'].$csslink);
				}
			} else {
				$GLOBALS['xoopsTpl']->assign('xoops_block_header',$csslink);
			}
	}
	
	function get_block_file_path($mydirname,$file_name)
	{
		$mydirpath = XOOPS_ROOT_PATH . '/modules/' . $mydirname;
		$select_theme = get_xpress_theme_name($mydirname);
		$block_file = $mydirpath . '/wp-content/themes/' . $select_theme . '/blocks/' . $file_name;

		if (!file_exists($block_file))
			$block_file =  XOOPS_ROOT_PATH . '/modules/' .$mydirname . '/wp-content/themes/xpress_default/blocks/' . $file_name;
		return $block_file;
	}
	
	function xpress_block_render($mydirname,$block_function_name,$options)
	{
		global $wpdb;
		$func_file = $block_function_name;
		$call_theme_function_name = str_replace(".php", "", $block_function_name);
		$inc_theme_file_name = $call_theme_function_name . '_theme.php';
		$cache_title = str_replace(".php", "", $block_function_name);
		$blockID =get_block_id($mydirname,$func_file,$options);		

		if (!is_null($wpdb)){
			xpress_block_css_set($mydirname);
			
			$block_theme_file = get_block_file_path($mydirname,$inc_theme_file_name);
			require_once $block_theme_file;
			$block = $call_theme_function_name($options);		//The block name and the called function name should be assumed to be the same name. 

// Not Cache Write Now.  Becose Cache Write On WordPress Event			
//			xpress_block_cache_write($mydirname,$cache_title. $blockID, $block);  
		} else {
			$xml = xpress_block_cache_read($mydirname,$cache_title. $blockID);
			$block = $xml['block'];
		}

		$templates_file = 'db:'.$mydirname. '_' . str_replace(".php", ".html", $block_function_name);
		$tpl =& new XoopsTpl() ;
		$tpl->assign( 'block' , $block ) ;
		$ret['content'] = $tpl->fetch( $templates_file ) ;
		return $ret ;
	}
	
?>