<?php
/*
 * XPressME - WordPress for XOOPS
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @package		module::xpress
 */

/* 
 * The function to acquire only a set value without calling the XOOPS system is here.
 */
class ConfigFromXoops{
	var $xoops_mainfile_path;
	var $define_arry = array();	
	var $xoops_root_path;
	var $xoops_url;
	var $xoops_trust_path;
	var $xoops_db_prefix;
	var $xoops_db_name;
	var $xoops_db_user;
	var $xoops_db_pass;
	var $xoops_db_host;
	var $module_name;
	var $module_path;
	var $module_url;
	
	function __constructor()	//for PHP5
    {
        $this->ConfigFromXoops();
    }

    function ConfigFromXoops()	//for PHP4 constructor
    {  
    	$this->xoops_mainfile_path = $this->get_xoops_mainfile_path();
    	$this->module_path=dirname(dirname(__FILE__));   	
    	$this->module_name=basename($this->module_path);
		if(file_exists($this->xoops_mainfile_path)){
			$array_file = file($this->xoops_mainfile_path);
			for ($i = 0 ; $i <count($array_file) ; $i++){
				$array_file[$i] = trim($array_file[$i]);
				$array_file[$i] = str_replace(' ','',$array_file[$i]);
				
				$array_file[$i] = preg_replace('/\s\s+/', '', $array_file[$i]);
				$array_file[$i] = preg_replace('/^include.*/','',$array_file[$i]);
				$array_file[$i] = preg_replace('/^\/\/.*/','',$array_file[$i]);
				$array_file[$i] = preg_replace('/^if.*/','',$array_file[$i]);
				if (strstr($array_file[$i],'define')!== false){
					$array_file[$i] = preg_replace('/\"/', '', $array_file[$i]);
					$array_file[$i] = preg_replace('/\(/', '', $array_file[$i]);					
					$array_file[$i] = preg_replace('/\)/', '', $array_file[$i]);
					$array_file[$i] = preg_replace('/\;/', '', $array_file[$i]);
					$array_file[$i] = preg_replace('/\'/', '', $array_file[$i]);
					$array_file[$i] = preg_replace('/define/', '', $array_file[$i]);
					$define = explode(',',$array_file[$i] );
					$define[0] = trim($define[0]);
					$define[1] = trim($define[1]);
					switch ($define[0]){
						case  'XOOPS_ROOT_PATH':
							$this->xoops_root_path = $define[1];
							$this->xoops_url . '/modules/' . $this->module_name;
							break;
						case  'XOOPS_URL':
							$this->xoops_url = $define[1];
							$this->module_url = $this->xoops_url . '/modules/' . $this->module_name;
							break;
						case  'XOOPS_TRUST_PATH':
							$this->xoops_trust_path = $define[1];
							break;
						case  'XOOPS_DB_PREFIX':
							$this->xoops_db_prefix = $define[1];
							break;
						case  'XOOPS_DB_NAME':
							$this->xoops_db_name = $define[1];
							break;
						case  'XOOPS_DB_USER':
							$this->xoops_db_user = $define[1];
							break;
						case  'XOOPS_DB_PASS':
							$this->xoops_db_pass = $define[1];
							break;
						case  'XOOPS_DB_HOST':
							$this->xoops_db_host = $define[1];
							break;
						default :
					}
				}
			}
		}
    }
    
    function get_xoops_mainfile_path(){
    	return dirname(dirname(dirname(dirname(__FILE__)))) . '/mainfile.php';
    }

}
?>
