<?php
/*
 * XPressME - WordPress for XOOPS
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @package		module::xpress
 */

/* 
 *	The module loads the XOOPS system only at the time of reading to route index.php. 
 *
 *	When "Media up-loading" is executed, WordPress calls the SWFUpload script. 
 *	After completing up-loading
 *	The SWFUpload script executes wp-admin/async-upload.php. 
 *	At this time, session ID is not succeeded to. 
 *	And, admin/async-upload.php becomes an access inhibit when wordpress is under the management of XOOPS. 
 */

require_once dirname( __FILE__ ).'/specfic_on_call_page.php' ;


if (is_wp_cron_call() ){
	$_SERVER['HTTP_REFERER'] = 'http://'. $_SERVER[HTTP_HOST]  . $_SERVER['PHP_SELF'];
	$_SERVER['REQUEST_METHOD'] = 'POST';
}

if (is_media_upload_page_call() ){
	if ( !defined("XOOPS_ROOT_PATH") ) {
		//Module process will not load any XOOPS Cube classes.
		define('_LEGACY_PREVENT_EXEC_COMMON_', 1);		// for XCL
		$xoopsOption['nocommon'] = 1;					// for XOOPS
		include_once dirname( __FILE__ ).'/../../../mainfile.php';
	}
	if (!defined("XOOPS_UPLOAD_PATH"))
		define("XOOPS_UPLOAD_PATH", XOOPS_ROOT_PATH."/uploads");
	if (!defined("XOOPS_UPLOAD_URL"))
		define("XOOPS_UPLOAD_URL", XOOPS_URL."/uploads");
} else {
	// index page is load xoops
	require dirname( __FILE__ ).'/../../../mainfile.php' ;
}
?>
