<?php

load_plugin_textdomain('xpressme', 'wp-content/plugins/xpressme/language');

class XPressME_Class{
	var $pluginName = 'xpressme';	
	var $is_use_xoops_upload_path;
	var $is_theme_sidebar_disp;
	var $is_save_post_revision;
	var $is_postnavi_title_disp;
	var $is_left_postnavi_old;
	var $old_post_link_text;
	var $newer_post_link_text;
	var $is_author_view_count;
	var $is_sql_debug;
	var $groupe_role;

	//constructor
	function XPressME_Class()
	{
		global $xoops_db;
		
		$this->setdefault();    //not setting propaty load
		$this->SettingValueRead();
	}


	function add_option_page()
	{
		add_options_page('XPressME', __('XPressME Settings', 'xpressme'), 8, 'xpressme_config', array(&$this, 'option_page'));
	}
	
	function add_admin_head()
	{ 
		// add header text
	}

	
		//Set Default Value	
	function setDefault()
	{
		$this->is_use_xoops_upload_path = true;
		$this->is_theme_sidebar_disp = true;
		$this->is_save_post_revision = true;
		$this->is_postnavi_title_disp = true;
		$this->is_left_postnavi_old = true;
		$this->old_post_link_text = __('to Old Post', 'xpressme');
		$this->newer_post_link_text = __('to Newer Post', 'xpressme');
		$this->is_author_view_count = false;
		$this->is_sql_debug = false;
	}
	
	function SettingValueRead()
	{
		global $xoops_db;
		$options = get_option('xpressme_option');
		if (!$options) {
			$this->setDefault();
			$this->SettingValueWrite('add_new');
		} else {
			foreach ($options as $option_name => $option_value){
	        		$this-> {$option_name} = $option_value;
			}
		}
		if (!empty($xoops_db))	// at install trap
			$this->GroupeRoleRead();
	}
	
		// mode 0:add  1:update	
	function SettingValueWrite($mode)
	{
		$write_options = array (
			'is_use_xoops_upload_path' => $this->is_use_xoops_upload_path ,
			'is_theme_sidebar_disp' => $this->is_theme_sidebar_disp ,
			'is_save_post_revision' => $this->is_save_post_revision ,
			'is_postnavi_title_disp' => $this->is_postnavi_title_disp ,
			'is_left_postnavi_old' => $this->is_left_postnavi_old ,
			'old_post_link_text' => $this->old_post_link_text ,
			'newer_post_link_text' => $this->newer_post_link_text,
			'is_author_view_count' => $this->is_author_view_count,
			'is_sql_debug' => $this->is_sql_debug
		);
		if ($mode == 'add_new') {
			add_option('xpressme_option', $write_options);
		} else {			
			update_option("xpressme_option", $write_options);
		}
	}
	
	function GroupeRoleRead() {
 		global $xoops_db;
		
		// table sync
		$table = get_wp_prefix() . 'group_role';
		$xoops_group = get_xoops_prefix() . 'groups';
		$sql=  "SELECT * FROM $table";
		$before_groupes = $xoops_db->get_results($sql);
		
		$sql = "DELETE FROM $table";
		$xoops_db->query($sql);
		
		
		$sql=  "SELECT * FROM $xoops_group WHERE group_type <> 'Anonymous'";
		$groupes = $xoops_db->get_results($sql);
		$insert_sql = '';
		foreach ($groupes as $groupe) {
			$role = '';
			foreach ($before_groupes as $before_groupe) {
				if ($groupe->groupid == $before_groupe->groupid) {
					$role = $before_groupe->role;
					$login_all = $before_groupe->login_all;
				}
			}
			
			$insert_sql  = "INSERT INTO  $table ";
			$insert_sql .= "(groupid , name , description , group_type , role , login_all) ";
			$insert_sql .= "VALUES (";
			$insert_sql .= $groupe->groupid . ', ';
			$insert_sql .= "'" . $groupe->name . "' , ";
			$insert_sql .= "'" . $groupe->description . "' , ";
			$insert_sql .= "'" . $groupe->group_type . "' , ";
			$insert_sql .= "'" . $role . "' , '";
			$insert_sql .= $login_all . "')";
			$xoops_db->query($insert_sql);
		}
		
		$sql=  "SELECT * FROM $table";
		
		$this->groupe_role =  $xoops_db->get_results($sql);
			$sql=  "SELECT * FROM $table";	
	}
	
	function ReadPostData()
	{
		$this->is_use_xoops_upload_path = stripslashes(trim($_POST['ch_is_use_xoops_upload_path']));
		$this->is_theme_sidebar_disp = stripslashes(trim($_POST['ch_is_theme_sidebar_disp']));
		$this->is_save_post_revision = stripslashes(trim($_POST['ch_is_save_post_revision']));
		$this->is_postnavi_title_disp = stripslashes(trim($_POST['ch_is_postnavi_title_disp']));
		$this->is_left_postnavi_old = stripslashes(trim($_POST['ch_is_left_postnavi_old']));
		$this->old_post_link_text = stripslashes($_POST['ch_old_post_link_text']);
		if(empty($this->old_post_link_text)) $this->old_post_link_text = __('to Old Post', 'xpressme');
		$this->newer_post_link_text = stripslashes($_POST['ch_newer_post_link_text']);
		if(empty($this->newer_post_link_text)) $this->newer_post_link_text = __('to Newer Post', 'xpressme');
		$this->is_author_view_count = stripslashes(trim($_POST['ch_is_author_view_count']));
		$this->is_sql_debug = stripslashes(trim($_POST['ch_is_sql_debug']));
		
		global $xoops_db;
		$table = get_wp_prefix() . 'group_role';	
//		$sql=  "SELECT * FROM $table";	
//		$this->groupe_role =  $xoops_db->get_results($sql);  // before Read
		
		foreach ($this->groupe_role as $groupe) {
			$post_name = 'role_gid_' . $groupe->groupid;
			$role = stripslashes(trim($_POST[$post_name]));
			$post_name = 'login_all_gid_' . $groupe->groupid;
			$login_all = stripslashes(trim($_POST[$post_name]));
			if (empty($login_all)) $login_all = '0';
			$groupe->role = $role;
			$groupe->login_all = $login_all;
			$update_sql  = "UPDATE  $table ";
			$update_sql .= 'SET ';
			$update_sql .= "role  = '$role' , ";
			$update_sql .= "login_all  = $login_all ";
			$update_sql .= "WHERE (groupid = '$groupe->groupid' )";
			$xoops_db->query($update_sql);			
		}
	}
	
	function yes_no_radio_option($option_name,$option_desc,$yes = '',$no= ''){
		if (empty( $yes ))  $yes = __('YES','xpressme') ;
		if (empty( $no ))  $no = __('NO','xpressme') ;
		$value = $this->{$option_name};
		$ans_name = 'ch_' . $option_name;
		
		$form  =  "<tr>\n";
		$form .=  '<th><label for="images_to_link">' . $option_desc . "</label></th>\n";
		$form .=  "<td>\n";
		if ($value){
			$form .= "<label><input type='radio' name='". $ans_name . "' value='1' checked='checked' />" . $yes ."</label><br />\n";
			$form .= "<label><input type='radio' name='". $ans_name . "' value='0' />". $no . "</label>\n";
		}else{
			$form .= "<label><input type='radio' name='". $ans_name . "' value='1' />" . $yes . "</label><br />\n";
			$form .= "<label><input type='radio' name='". $ans_name . "' value='0' checked='checked' />". $no ."</label>\n";
		}
		$form .=  "</td>\n";
		$form .=  "</tr><tr>\n";
			
	    return $form;
	
	}

	function text_option($option_name,$option_desc){
		$value = $this->{$option_name};
		$ans_name = 'ch_' . $option_name;
		
		$form  =  "<tr>\n";
		$form .=  '<th><label for="images_to_link">' . $option_desc . "</label></th>\n";
		$form .=  "<td>\n";
		$form .= '<label> <input name="'. $ans_name . '" type="text" size="25" maxlength="50" value="'  . $value . '" /></label>'."\n";
		$form .=  "</td>\n";
		$form .=  "</tr><tr>\n";
			
	    return $form;
	
	}
	
	function groupe_role_option(){
		global $wp_roles , $xoops_db;
		
		$form = '';
		$form .= '<tr><th><label for="role">' .__('Role Setting at Login', 'xpressme') . '</label></th>';
		$form .= '<td>';
		$form .= "<table>\n";
		$form .= '<tr><td>' . __('XOOPS Groupe', 'xpressme') . '</td><td>' . __('WordPress Role', 'xpressme') . '</td><td>' . __('Role is set at each login', 'xpressme') . "</td></tr>\n";
		foreach ($this->groupe_role as $groupe) {
			$form .= "<tr>";
			$form .= "<td> $groupe->name </td>";
			$form .= "<td>\n" . '<select name="role_gid_'.$groupe->groupid . '" id="role_gid_' . $groupe->groupid . '">' . "\n";
			$role_list = '';
			$group_has_role = false;
		
			$select_value = $groupe->role;
		
			foreach($wp_roles->role_names as $role => $name) {
				$name = translate_with_context($name);
				if ( $role == $select_value) {
					$selected = ' selected="selected"';
					$group_has_role = true;
				} else {
					$selected = '';
				}
				$role_list .= "<option value=\"{$role}\"{$selected}>{$name}</option>\n";
			}
			if ( $group_has_role ) {
				$role_list .= '<option value="default">' . __('Default Role of WordPress', 'xpressme') . "</option>\n";
				$role_list .= '<option value="">' . __('Group User Doesn\'t Register', 'xpressme') . "</option>\n";
			} else {
				if ($select_value == 'default'){
					$role_list .= '<option value="default" selected="selected">' . __('Default Role of WordPress', 'xpressme') . "</option>\n";	
					$role_list .= '<option value="">' . __('Group User Doesn\'t Register', 'xpressme') . "</option>\n";
				} else {
					$role_list .= '<option value="default">' . __('Default Role of WordPress', 'xpressme') . "</option>\n";					
					$role_list .= '<option value="" selected="selected">' . __('Group User Doesn\'t Register', 'xpressme') . "</option>\n";
				}
			}
			$form .= $role_list . "</select>\n</td>";
			if ($groupe->login_all){
				$form .= '<td> <input type="checkbox" name="login_all_gid_' . $groupe->groupid . '" value="1" checked ></td>';
			} else {
				$form .= '<td> <input type="checkbox" name="login_all_gid_' . $groupe->groupid . '" value="1"></td>';
			}
			$form .= "</tr>\n";	
		}
		$form .= "</table></td></tr>\n";
	    return $form;

	}
		
	function option_page()
	{

		if (!empty($_POST['submit_update'])) {
			$this->ReadPostData();
			$this->SettingValueWrite('update');
		} else if (isset($_POST['submit_reset'])) {
			$this->fck_setDefault();
			$this->SettingValueWrite('update');
		} 

		
		echo	'<div class="wrap">'."\n";
		echo		'<div id="icon-options-general" class="icon32"><br /></div>'."\n";
		echo		'<h2>' . __('XPressME Configuration Page', 'xpressme') . "</h2>\n";
		echo		'<form method="post" action="' . $_SERVER["REQUEST_URI"] . '">'."\n" ;
		echo			'<table class="form-table">'."\n";
		echo				$this->yes_no_radio_option('is_use_xoops_upload_path',
												__('Media Upload Base Path','xpressme'),
												__('Use XOOPS UPLOAD PATH','xpressme'),
												__('USE WordPress BASE_PATH','xpressme')
												);
		echo				$this->yes_no_radio_option('is_theme_sidebar_disp',
												__('Thema Sidebar Display','xpressme'),
												__('YES','xpressme'),
												__('NO','xpressme')
												);
		echo				$this->yes_no_radio_option('is_save_post_revision',
												__('The change tracking of the post is preserved','xpressme'),
												__('YES','xpressme'),
												__('NO','xpressme')
												);
		echo				$this->text_option('old_post_link_text',
												__('Display Navi Title of Old Post Link','xpressme')
												);
		echo				$this->text_option('newer_post_link_text',
												__('Display Navi Title of Newer Post Link','xpressme')
												);
		echo				$this->yes_no_radio_option('is_postnavi_title_disp',
												__('Select Display name of PostNavi Link','xpressme'),
												__('Title of post','xpressme'),
												__('Title of Navi','xpressme')
												);
		echo				$this->yes_no_radio_option('is_left_postnavi_old',
												__('Adjustment of Navi link display position','xpressme'),
												__("'Old Post Link' is displayed in the left, and 'Newer Post Link' is displayed in the right",'xpressme'),
												__("'Newer Post Link' is displayed in the left, and 'Old Post Link' is displayed in the right",'xpressme')
												);
		echo				$this->yes_no_radio_option('is_author_view_count',
												__('Is the posts author views counted?','xpressme'),
												__('YES','xpressme'),
												__('NO','xpressme')		
												);
		echo				$this->yes_no_radio_option('is_sql_debug',
												__('Is SQL debugging window displayed?','xpressme'),
												__('YES','xpressme'),
												__('NO','xpressme')		
												);
		
		echo				$this->groupe_role_option();				
//		$this->is_use_xoops_upload_path_html();
		echo			"</table>\n";
		
		echo		'<p class="submit">'."\n";
		echo		'<input type="submit" value= "' . __('Update Config', 'xpressme') . '" name="submit_update" />' ."\n";
		echo		'<input type="submit" value= "' . __('Preset Config', 'xpressme') . '" name="submit_reset" />' ."\n";
		echo		"</p>\n";

		echo		"</form>\n" ;
		echo	"</div>\n";
	}
	
	function xpress_upload_filter($uploads)
	{
		global $xoops_config;
		if ($this->is_use_xoops_upload_path){
			$wordpress_dir = ABSPATH ;
			$xoops_dir = $xoops_config->xoops_upload_path . '/';
			$wordpress_base_url = get_option( 'siteurl' );
			$xoops_upload_url = $xoops_config->xoops_upload_url;
			
			$uploads[path] =  str_replace ($wordpress_dir, $xoops_dir, $uploads[path]);
			$uploads[basedir] = str_replace ($wordpress_dir, $xoops_dir, $uploads[basedir]);
			$uploads[url] = str_replace ($wordpress_base_url, $xoops_upload_url, $uploads[url]);
			$uploads[baseurl] = str_replace ($wordpress_base_url, $xoops_upload_url, $uploads[baseurl]);
		}
		return $uploads;
	}

	// SQL DEBUG TEST
	function is_sql_debug_permission()
	{
		global $current_user;

		if (!is_object($current_user)) return false;
		if ($this->is_sql_debug && ($current_user->user_level >= 10))
			return true;
		else
			return false;
	}
	
	function xpress_sql_debug($query_strings)
	{
		if ($this->is_sql_debug_permission()){
			if (empty($GLOBALS['XPress_SQL_Query'])) $GLOBALS['XPress_SQL_Query'] = '';
			$GLOBALS['XPress_SQL_Query'] .= $query_strings . '<br />';
		}
		return $query_strings;
	}
	
	function displayDebugLog()
	{
		if ($this->is_sql_debug_permission()){
			$content = '';
			$content .= '<html><head><meta http-equiv="content-type" content="text/html; charset='._CHARSET.'" />';
			$content .= '<meta http-equiv="content-language" content="'._LANGCODE.'" />' ;
			$content .= '<title>XPressME SQL DEBUG</title>' ;
			$content .= '</head><body>';
			$content .= $GLOBALS['XPress_SQL_Query'];
			$content .= '<div style="text-align:center;"><input class="formButton" value="CLOSE" type="button" onclick="javascript:window.close();" /></div></body></html>';

			echo '<script type="text/javascript">
				<!--//
				xpress_debug_window = window.open("", "xpress_debug", "width=680 , height=600 ,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no");
				xpress_debug_window.document.clear();
				xpress_debug_window.focus();
				';
			$lines = preg_split("/(\r\n|\r|\n)( *)/", $content);
			foreach ($lines as $line) {
				echo 'xpress_debug_window.document.writeln("'.str_replace('"', '\"', $line).'");';
			}
			echo '
				xpress_debug_window.document.close();
				//-->
			</script>';
		}
	}	

}
?>