<?php

function xpress_templates_make($mid,$mydirname)
{
	$msgs = array();
	// TEMPLATES
	$tplfile_handler =& xoops_gethandler( 'tplfile' ) ;
	$tpl_path = XOOPS_ROOT_PATH . '/modules/' . $mydirname . '/templates' ;
	if( $handler = @opendir( $tpl_path . '/source/' ) ) {
		while( ( $file = readdir( $handler ) ) !== false ) {
			if( substr( $file , 0 , 1 ) == '.' ) continue ;
			if(!is_template($file)) continue ;
			$file_path = $tpl_path . '/source/' . $file ;
			if( is_file( $file_path ) ) {
				$target_file_name = $mydirname . '_' . $file;
				$target_file_path = $tpl_path . '/'.$target_file_name;
				$rcd = @unlink($target_file_path);
				if ($mydirname != 'xpress') {		//old version file delete
					$rcd = @unlink($tpl_path . '/xpress'.$file);
				}
//				$rcd = rename($file_path, $target_file_path);
				$rcd = copy($file_path, $target_file_path);
				if ($rcd){
					$msgs[] = 'Template <b>'.htmlspecialchars($target_file_path).'</b> copy from ' . htmlspecialchars($file);
				} else {
					$msgs[] = '<span style="color:#ff0000;">ERROR: Could not copy template <b>'.htmlspecialchars($target_file_name).'</b> from ' . htmlspecialchars($file). '(check templates directory permision (777))</span>';
				}					
				$tplfile =& $tplfile_handler->create() ;
				if ($rcd) {
					$mtime = intval( @filemtime( $target_file_path ) ) ;
					$tplfile->setVar( 'tpl_source' , file_get_contents( $target_file_path ) , true ) ;
				} else {
					$mtime = intval( @filemtime( $file_path ) ) ;
					$tplfile->setVar( 'tpl_source' , file_get_contents( $file_path ) , true ) ;
				}

				$tplfile->setVar( 'tpl_refid' , $mid ) ;
				$tplfile->setVar( 'tpl_tplset' , 'default' ) ;
				$tplfile->setVar( 'tpl_file' , $target_file_name ) ;
				$tplfile->setVar( 'tpl_desc' , '' , true ) ;
				$tplfile->setVar( 'tpl_module' , $mydirname ) ;
				$tplfile->setVar( 'tpl_lastmodified' , $mtime ) ;
				$tplfile->setVar( 'tpl_lastimported' , 0 ) ;
				$tplfile->setVar( 'tpl_type' , 'module' ) ;
				if( ! $tplfile_handler->insert( $tplfile ) ) {
					$msgs[] = '<span style="color:#ff0000;">ERROR: Could not insert template <b>'.htmlspecialchars($target_file_name).'</b> to the database.</span><br />';
				} else {
					$tplid = $tplfile->getVar( 'tpl_id' ) ;
					$msgs[] = 'Template <b>'.htmlspecialchars($target_file_name) .'</b> added to the database. (ID: <b>'.$tplid.'</b>)<br />';
					// generate compiled file
					include_once XOOPS_ROOT_PATH.'/class/xoopsblock.php' ;
					include_once XOOPS_ROOT_PATH.'/class/template.php' ;
					if( ! xoops_template_touch( $tplid ) ) {
						$msgs[] = '<span style="color:#ff0000;">ERROR: Failed compiling template <b>'.htmlspecialchars($target_file_name).'</b>.</span><br />';
					} else {
						$msgs[] = 'Template <b>'.htmlspecialchars($target_file_name).'</b> compiled.</span><br />';
					}
				}
			}
		}
		closedir( $handler ) ;
	}
	include_once XOOPS_ROOT_PATH.'/class/xoopsblock.php' ;
	include_once XOOPS_ROOT_PATH.'/class/template.php' ;
	xoops_template_clear_module_cache( $mid ) ;

	return $msgs;
}


function is_template($file_name){
	if (empty($file_name)) return false;
	
	$temp_list = array(
		'recent_comments_block.html',
		'recent_posts_content_block.html',
		'recent_posts_list_block.html',
		'calender_block.html',
		'popular_posts_block.html',
		'archives_block.html',
		'authors_block.html',
		'page_block.html',
		'search_block.html',
		'index.html',
	);
	foreach($temp_list as $ck_file){
		if (strcmp($ck_file,$file_name) ==  0) return true;
	}
	return false;
}


?>