<?php
/**
 * XPress - WordPress for XOOPS
 *
 * Adding multi-author features to XPressME
 *
 * @copyright	The XPressME project
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @since		2.05
 * @version		$Id$
 * @package		module::xpress
 */

// ***********************************  Start Pluggable Function Edit (wp-include/pluggable.php) ************************************

if ( !function_exists('get_currentuserinfo') ) :
function get_currentuserinfo() {
	global $current_user;
	global $xoopsModule,$xoopsUser,$xoopsUserIsAdmin;


	if ($xoopsModule){
		if (!is_object($xoopsUser)){
				wp_set_current_user(0);
				wp_logout();
			 	return false;
		}
		if ( defined('XMLRPC_REQUEST') && XMLRPC_REQUEST )
			return false;

		if ( ! empty($current_user) ){
			$xoops_user = $xoopsUser->getVar("uname");
			if ($current_user->user_login == $xoops_user)
				return;
		}

		if (check_xpress_auth_cookie()){	//The cookie is login user's or it checks it
			if ( $user = wp_validate_auth_cookie() ) {
				wp_set_current_user($user);
				return ;
			}
		}				
		xpress_login();	

	} else {
		// WP2.7 original
		if ( defined('XMLRPC_REQUEST') && XMLRPC_REQUEST )
			return false;

		if ( ! empty($current_user) )
			return;

		if ( ! $user = wp_validate_auth_cookie() ) {
			 if ( empty($_COOKIE[LOGGED_IN_COOKIE]) || !$user = wp_validate_auth_cookie($_COOKIE[LOGGED_IN_COOKIE], 'logged_in') ) {
			 	wp_set_current_user(0);
			 	return false;
			 }
		}

		wp_set_current_user($user);
	}
}
endif;

if ( !function_exists('xpress_login') ) :
function xpress_login(){
	global $current_user;
	
	if(is_object($GLOBALS["xoopsUser"])){
		$u_name = $GLOBALS["xoopsUser"]->getVar("uname");
		$u_pass_md5 = $GLOBALS["xoopsUser"]->getVar("pass");	
		if ( ! empty($u_name) && ! empty($u_pass_md5) ) {
			include_once dirname( __FILE__ ).'/user_sync_xoops.php';
			repair_user_meta_prefix();  //Repair when data base prefix is changed on XOOPS side
			$messege = '';
			$ret = user_sync_to_wordpress($GLOBALS["xoopsUser"]->getVar("uid"),$messege);
			if ($ret){
				$user = new WP_User(0, $u_name);
				if ( wp_login($u_name, $u_pass_md5) ) {
					wp_setcookie($u_name, $u_pass_md5, true, '', '', false);
					do_action('wp_login', $u_name);
					wp_set_current_user($user->ID);
					return  true;
				}
			}
		}
	}
	wp_set_current_user(0);
	return 0;	
}
endif;

if ( !function_exists('check_xpress_auth_cookie') ) :
function check_xpress_auth_cookie() {		// for wp2.5
	if ( empty($_COOKIE[AUTH_COOKIE]) ){
		return false;
	}
	$cookie = $_COOKIE[AUTH_COOKIE];

	$cookie_elements = explode('|', $cookie);
	if ( count($cookie_elements) != 3 ){
			return false;
	}
					
	if(is_object($GLOBALS["xoopsModule"])){
//		&& WP_BLOG_DIRNAME == $GLOBALS["xoopsModule"]->getVar("dirname")){
		if(is_object($GLOBALS["xoopsUser"])){
			$u_name = $GLOBALS["xoopsUser"]->getVar("uname");
			list($username, $expiration, $hmac) = $cookie_elements;
			if ($u_name == $username) {
				return true;
			}
		}
	} else {
		$mydirname = basename( dirname( dirname( __FILE__ ) ) ) ;
		$org_url = $_SERVER['REQUEST_URI'];
		$needle = '/modules/' . $mydirname . '/wp-admin/';
		if (strstr($org_url , $needle)){
			return true;				
		}
	}
	return false;
}
endif;

if ( !function_exists('wp_check_password') ) :
// for wordpress2.5
function wp_check_password($password, $hash, $user_id = '') {
	global $wp_hasher;

	// If the hash is still md5...
	if ( strlen($hash) <= 32 ) {
		if (( $hash == md5($password)) || ($hash == $password)) {  // The password taken out of XOOPS is hash value.
			$check = true;
		} else {
			$check = false;
		}

/* A new hash is not used because it differs from the hash on the XOOPS password. 
 *		if ( $check && $user_id ) {
 *			// Rehash using new hash.
 *			wp_set_password($password, $user_id);
 *			$hash = wp_hash_password($password);
 *		}
 */
		return apply_filters('check_password', $check, $password, $hash, $user_id);
	}

	// If the stored hash is longer than an MD5, presume the
	// new style phpass portable hash.
	if ( empty($wp_hasher) ) {
		require_once( ABSPATH . 'wp-includes/class-phpass.php');
		// By default, use the portable hash from phpass
		$wp_hasher = new PasswordHash(8, TRUE);
	}

	$check = $wp_hasher->CheckPassword($password, $hash);

	return apply_filters('check_password', $check, $password, $hash, $user_id);
}
endif;

if ( !function_exists('wp_redirect') ) :
function wp_redirect($location, $status = 302) {
	global $is_IIS,$xoops_config,$action;
	
	if ($location == 'wp-login.php?loggedout=true') $location = $xoops_config->xoops_url.'/user.php?op=logout'; //xoops logout at wp logout
	if ($location == 'wp-login.php?action=register') $location = $xoops_config->xoops_url."/register.php";  //wp-register to xoops register
	if ($action == 'logout') $location = $xoops_config->xoops_url.'/user.php?op=logout'; //xoops logout at comment logout

	$location = apply_filters('wp_redirect', $location, $status);
	$status = apply_filters('wp_redirect_status', $status, $location);

	if ( !$location ) // allows the wp_redirect filter to cancel a redirect
		return false;

	$location = wp_sanitize_redirect($location);

	if ( $is_IIS ) {
		header("Refresh: 0;url=$location");
	} else {
		if ( php_sapi_name() != 'cgi-fcgi' )
			status_header($status); // This causes problems on IIS and some FastCGI setups
		header("Location: $location");
	}
}
endif;

if ( !function_exists('wp_hash_password') ) :
function wp_hash_password($password) {
	global $wp_hasher;
	return md5($password); // A new hash is not used because it differs from the hash on the XOOPS password.
/*
	if ( empty($wp_hasher) ) {
		require_once( ABSPATH . 'wp-includes/class-phpass.php');
		// By default, use the portable hash from phpass
		$wp_hasher = new PasswordHash(8, TRUE);
	}

	return $wp_hasher->HashPassword($password);
*/
}
endif;
// ***********************************  End Of Pluggable Function Edit (wp-include/pluggable.php) ************************************

?>