<?php
	
function xpress_list_pings($comment, $args, $depth) {
       $GLOBALS['comment'] = $comment;
        echo '<li id="comment-<?php comment_ID(); ?>">';
        comment_author_link();
}
	
function xpress_credit($show = false)
{
	global $wp_version , $xoops_config;
	
	$xpress_version = $xoops_config->module_version;
	$xpress_codename = $xoops_config->module_codename;
	$ret = '<a href="http://www.toemon.com"'. " target='_blank'" . '>XPressME Ver.' . sprintf('%.2f %s',$xpress_version,$xpress_codename) .'</a>';
	if (strstr($wp_version,'ME')){
		$ret .= '(included <a href="http://wpme.sourceforge.jp/" title="Powered by WordPress"'." target='_blank'". '>WordPress ' . $wp_version . '</a>)';
	} else {
		$ret .= '(included <a href="http://ja.wordpress.org/" title="Powered by WordPress"'." target='_blank'". '>WordPress ' . $wp_version . '</a>)';
	}

	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_convert_time($show = false)
{
	$ret =  timer_stop(0) .'sec. ';
	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_is_theme_sidebar_disp(){
	global $xpress_config;
	if (is_wordpress_style()) return true;
	return $xpress_config->is_theme_sidebar_disp;
}	

function xpress_left_arrow_post_link($show = false)
{
	global $xpress_config;
	$ret = '';
		
	if($xpress_config->is_left_postnavi_old){
		$link_title = $xpress_config->old_post_link_text;
		ob_start();
		if ($xpress_config->is_postnavi_title_disp)
			previous_post_link('&laquo; %link');
		else 
			previous_post_link('&laquo; %link',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
	} else {
		$link_title = $xpress_config->newer_post_link_text;
		ob_start();
		if ($xpress_config->is_postnavi_title_disp)
			next_post_link('&laquo; %link');
		else
			next_post_link('&laquo; %link',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
	}
	
	if ($xpress_config->is_postnavi_title_disp){
		$on_mouse_show = $link_title;
	} else  {
		if($xpress_config->is_left_postnavi_old){
			ob_start();
				previous_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		} else {
			ob_start();
				next_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		}
		$pattern = "<a[^>]*?>(.*)<\/a>";
		preg_match("/".$pattern."/s",  $on_mouse_show, $body_matches);
		$on_mouse_show = $body_matches[1];
	}
	$ret = str_replace('">','" title="'.$on_mouse_show . '">' , $ret);

	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_right_arrow_post_link($show = false)
{
	global $xpress_config;
	$ret = '';		
	
	if($xpress_config->is_left_postnavi_old){
		$link_title = $xpress_config->newer_post_link_text;
		ob_start();
		if ($xpress_config->is_postnavi_title_disp)
			next_post_link('%link &raquo;');
		else
			next_post_link('%link &raquo;',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
	} else {
		$link_title = $xpress_config->old_post_link_text;
		ob_start();
		if ($xpress_config->is_postnavi_title_disp)
			previous_post_link('%link &raquo;');
		else 
			previous_post_link('%link &raquo;',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
	}
	
	if ($xpress_config->is_postnavi_title_disp){
		$on_mouse_show = $link_title;
	} else  {
		if($xpress_config->is_left_postnavi_old){
			ob_start();
				next_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		} else {
			ob_start();
				previous_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		}
		$pattern = "<a[^>]*?>(.*)<\/a>";
		preg_match("/".$pattern."/s",  $on_mouse_show, $body_matches);
		$on_mouse_show = $body_matches[1];
	}
	$ret = str_replace('">','" title="'.$on_mouse_show . '">' , $ret);

	if (empty($show))
		return $ret;
	else
		echo $ret;	
}
// page link
function xpress_left_arrow_posts_link($show = false)
{
	global $xpress_config;
	$ret = '';
		
	if($xpress_config->is_left_page_navi_old){
		$link_title = $xpress_config->old_page_link_text;
		ob_start();
		next_posts_link("&laquo; $link_title");
		$ret = ob_get_contents();
		ob_end_clean();
	} else {
		$link_title = $xpress_config->newer_page_link_text;
		ob_start();
		previous_posts_link("&laquo; $link_title");
		$ret = ob_get_contents();
		ob_end_clean();
	}

	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_right_arrow_posts_link($show = false)
{
	global $xpress_config;
	$ret = '';		
	
	if($xpress_config->is_left_page_navi_old){
		$link_title = $xpress_config->newer_page_link_text;
		ob_start();
		previous_posts_link("$link_title &raquo;");
		$ret = ob_get_contents();
		ob_end_clean();
	} else {
		$link_title = $xpress_config->old_page_link_text;
		ob_start();
		next_posts_link("$link_title &raquo;");
		$ret = ob_get_contents();
		ob_end_clean();
	}

	if (empty($show))
		return $ret;
	else
		echo $ret;	
}


function xpress_is_author_view_count(){
	global $xpress_config;
	return $xpress_config->is_author_view_count;
}

function xpress_substr($str, $start, $length, $trimmarker = '...')
{
    if (function_exists('mb_substr')){
        $str2 = mb_substr( $str , $start , $length);
        return $str2 . ( mb_strlen($str)!=mb_strlen($str2) ? $trimmarker : '' );
    } else {
        return ( strlen($str) - $start <= $length ) ? substr( $str, $start, $length ) : substr( $str, $start, $length - strlen($trimmarker) ) . $trimmarker;
    }
}


// views count
// Set and retrieves post views given a post ID or post object. 
// Retrieves post views given a post ID or post object. 
function xpress_post_views_count($post_id=0,$format= '',$show = true) {
	global $xoops_db,$wpdb;

	static $post_cache_views;

	if ( empty($post_id) ) {
		if ( isset($GLOBALS['post']) )
			$post_id = $GLOBALS['post']->ID;
	}

	$post_id = intval($post_id);
	if($post_id==0) return null;
	if(!isset($post_cache_views[$post_id])){
        $sql = "SELECT post_views FROM " . get_wp_prefix() . "views" . " WHERE post_id=$post_id";
        $post_views = $xoops_db->get_var($sql);
        if (!$post_views) {
	        $post_cache_views[$post_id] = 0;
        }else{
	        $post_cache_views[$post_id] = $post_views;
        }
	}
	$v_count = intval($post_cache_views[$post_id]);
	
	if (empty($format)) $format = __('views :%d','xpressme');
	
	$ret = sprintf($format,$v_count);

	if ($show) echo $ret; else return $ret;
}

function set_post_views_count(&$content) {
	if ( empty($_GET["feed"]) &&  empty($GLOBALS["feed"]) && empty($GLOBALS["doing_trackback"]) && empty($GLOBALS["doing_rss"]) && empty($_POST) && is_single() ){
		post_views_counting();
	}
	return $content;
}

// Set post views given a post ID or post object. 
function post_views_counting($post_id = 0) {
	global $xoops_db,$wpdb;
	global $table_prefix;
	static $views;
	
	$post_id = intval($post_id);
	if ( empty($post_id) && isset($GLOBALS['post']) ){
		$post_id = $GLOBALS['post']->ID;
	}


	$views_db = get_wp_prefix() . 'views';

	if($post_id==0 || !empty($views[$post_id])) return null;
	
	if(!xpress_is_author_view_count()){
		$current_user_id = $GLOBALS['current_user']->ID;
		$post_author_id = $GLOBALS['post']->post_author;
		if ($current_user_id ==$post_author_id) return null;
	}

    $sql = "SELECT post_views FROM " . $views_db . " WHERE post_id=$post_id";
	$post_views_found = $xoops_db->get_var($sql);
	if($post_views_found){
        $sql = "UPDATE " . $views_db . " SET post_views=post_views+1 WHERE post_id=$post_id";
    }else{
        $sql = "INSERT INTO " . $views_db . " (post_id, post_views) VALUES ($post_id, 1)";
    }
    $xoops_db->query($sql);
	return true;
}

function get_xpress_excerpt_contents($excerpt_length_word,$excerpt_length_character,$more_link_text = '') {
	global $post,$xpress_config;
	
	$blog_encoding = get_option('blog_charset');
	$text = get_the_content('');
	$text = strip_shortcodes( $text );
	$text = apply_filters('the_content', $text);
	$text = str_replace(']]>', ']]&gt;', $text);
	$text = strip_tags($text);
	$is_almost_ascii = ($xpress_config->ascii_judged_rate < round(@(mb_strlen($text, $blog_encoding) / strlen($text)) * 100)) ? true : false;
	if($is_almost_ascii) {
		$words = explode(' ', $text, $excerpt_length_word + 1);

		if(count($words) > $excerpt_length_word) {
			array_pop($words);
			array_push($words, ' ... ');
			$text = implode(' ', $words);
			if (!empty($more_link_text)) $text .= '<p align="center"><a href="'. get_permalink() . "\">".$more_link_text .'</a></p>';

		}
	}
	elseif(mb_strlen($text, $blog_encoding) > $excerpt_length_character) {
		$text = mb_substr($text, 0, $xpress_config->excerpt_length_character, $blog_encoding) . ' ... ';
		if (!empty($more_link_text)) $text .= '<p align="center"><a href="'. get_permalink() . "\">".$more_link_text .'</a></p>';
	}

	return $text;
}

function xpress_the_content($more_link_text = null, $stripteaser = 0, $more_file = '',$show = true)
{
	global $post,$xpress_config;
	
	
	if ($xpress_config->is_content_excerpt){
		$excerpt_length_word = $xpress_config->excerpt_length_word;
		$excerpt_length_character = $xpress_config->excerpt_length_character;
		$more_link_text = $xpress_config->more_link_text;
		$content = get_xpress_excerpt_contents($excerpt_length_word,$excerpt_length_character,$more_link_text);
	} else {
		$content = get_the_content($more_link_text,$stripteaser,$more_file);
		$content = apply_filters('the_content', $content);
		$content = str_replace(']]>', ']]&gt;', $content);
	}	
	if(empty($show)) return $content;
	echo $content;
}

function is_xpress_contributor()
{
	global $current_user;
	get_currentuserinfo();
	if ($current_user->user_level > 3)
		return true;
	else
		return false;
}

function xpress_post_new_link($link_title,$display = true)
{
	$output = '<a href="'. get_xpress_url() . '/wp-admin/post-new.php' . '">' . $link_title . '</a>';
	if ($display) 
		echo $output;
	else
		return $output;
}

function xpress_conditional_title($display = true)
{
	$output = __('Main', 'xpressme');
	if (is_category())
		$output = sprintf(__('Archive for the &#8216;%s&#8217; Category', 'xpressme'), single_cat_title('', false));
	if (is_tag())
		$output = sprintf(__('Posts Tagged &#8216;%s&#8217;', 'xpressme'), single_tag_title('', false) );
	if (is_day())
		$output = sprintf(__('Archive for %s|Daily archive page', 'xpressme'), get_the_time(__('F jS, Y', 'xpressme')));
	if (is_month())
		$output = sprintf(__('Archive for %s|Monthly archive page', 'xpressme'), get_the_time(__('F, Y', 'xpressme')));
	if (is_year())
		$output = sprintf(__('Archive for %s|Yearly archive page', 'xpressme'), get_the_time(__('Y', 'xpressme')));
	if (is_author())
		$output = sprintf(__('Archive for the &#8216;%s&#8217; Author', 'xpressme'), get_author_name( get_query_var('author')));
	if (is_search())
		$output = sprintf(__('Search Results of word &#8216;%s&#8217;', 'xpressme'), get_search_query());
		
	if ($display) 
		echo $output;
	else
		return $output;
}

?>