<?php
function xpress_selected_author($show=true ) {
	$output = '';
  	$author_cookie = get_xpress_dir_name() . "_select_author" ;
  	if (!empty($_COOKIE[$author_cookie])){
  		$uid = intval($_COOKIE[$author_cookie]);
  		$user_info = get_userdata($uid);
  		$output = $user_info->display_name;
  	}
	if (empty($show))
		return $output;
	else
		echo $output;
		
}
function xpress_selected_author_id($show=true ) {
	$output = '';
  	$author_cookie = get_xpress_dir_name() . "_select_author" ;
  	if (!empty($_COOKIE[$author_cookie])){
  		$output = intval($_COOKIE[$author_cookie]);
  	} else {
  		$output = '';
  	}
	if (empty($show))
		return $output;
	else
		echo $output;
		
}

function xpress_now_user_level($show=true ) {
	global $current_user;
	$output = @$current_user->user_level;
	if (empty($show))
		return $output;
	else
		echo $output;		
}


function xpress_list_pings($trackback, $args, $depth) {
       $GLOBALS['comment'] = $trackback;
        echo '<li id="comment-<?php comment_ID(); ?>">';
        comment_author_link();
}
	
function xpress_credit($show = false)
{
	global $wp_version , $xoops_config;
	
	$xpress_version = $xoops_config->module_version;
	$xpress_codename = $xoops_config->module_codename;
	$ret = '<a href="http://www.toemon.com"'. " target='_blank'" . '>XPressME Ver.' . sprintf('%.2f %s',$xpress_version,$xpress_codename) .'</a>';
	if (strstr($wp_version,'ME')){
		$ret .= '(included <a href="http://wpme.sourceforge.jp/" title="Powered by WordPress"'." target='_blank'". '>WordPress ' . $wp_version . '</a>)';
	} else {
		$ret .= '(included <a href="http://ja.wordpress.org/" title="Powered by WordPress"'." target='_blank'". '>WordPress ' . $wp_version . '</a>)';
	}

	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_convert_time($show = false)
{
	$ret =  timer_stop(0) .'sec. ';
	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_is_theme_sidebar_disp(){
	global $xpress_config;
	if (is_wordpress_style()) return true;
	return $xpress_config->is_theme_sidebar_disp;
}	

function xpress_left_arrow_post_link($show = false)
{
	global $xpress_config;
	$ret = '';
		
	if($xpress_config->is_left_postnavi_old){
		$link_title = $xpress_config->old_post_link_text;
		ob_start();
		if ($xpress_config->is_postnavi_title_disp)
			previous_post_link('&laquo; %link');
		else 
			previous_post_link('&laquo; %link',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
		ob_start();
			previous_post_link('%link',$link_title);
			$GLOBALS['left_arrow_post_link'] = ob_get_contents();
		ob_end_clean();

	} else {
		$link_title = $xpress_config->newer_post_link_text;
		ob_start();
		if ($xpress_config->is_postnavi_title_disp)
			next_post_link('&laquo; %link');
		else
		$GLOBALS['left_arrow_post_link'] = 
		$ret = ob_get_contents();
		ob_end_clean();
		ob_start();
			next_post_link('%link',$link_title);
			$GLOBALS['left_arrow_post_link'] = ob_get_contents();
		ob_end_clean();

	}
	
	if ($xpress_config->is_postnavi_title_disp){
		$on_mouse_show = $link_title;
	} else  {
		if($xpress_config->is_left_postnavi_old){
			ob_start();
				previous_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		} else {
			ob_start();
				next_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		}
		$pattern = "<a[^>]*?>(.*)<\/a>";
		preg_match("/".$pattern."/s",  $on_mouse_show, $body_matches);
		$on_mouse_show = $body_matches[1];
	}
	$ret = str_replace('">','" title="'.$on_mouse_show . '">' , $ret);

	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_right_arrow_post_link($show = false)
{
	global $xpress_config;
	$ret = '';		
	
	if($xpress_config->is_left_postnavi_old){
		$link_title = $xpress_config->newer_post_link_text;
		ob_start();
		if ($xpress_config->is_postnavi_title_disp)
			next_post_link('%link &raquo;');
		else
			next_post_link('%link &raquo;',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
		ob_start();
			next_post_link('%link',$link_title);
			$GLOBALS['right_arrow_post_link'] = ob_get_contents();
		ob_end_clean();

	} else {
		$link_title = $xpress_config->old_post_link_text;
		ob_start();
		if ($xpress_config->is_postnavi_title_disp)
			previous_post_link('%link &raquo;');
		else 
			previous_post_link('%link &raquo;',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
		ob_start();
			previous_post_link('%link',$link_title);
			$GLOBALS['right_arrow_post_link'] = ob_get_contents();
		ob_end_clean();

	}
	
	if ($xpress_config->is_postnavi_title_disp){
		$on_mouse_show = $link_title;
	} else  {
		if($xpress_config->is_left_postnavi_old){
			ob_start();
				next_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		} else {
			ob_start();
				previous_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		}
		$pattern = "<a[^>]*?>(.*)<\/a>";
		preg_match("/".$pattern."/s",  $on_mouse_show, $body_matches);
		$on_mouse_show = $body_matches[1];
	}
	$ret = str_replace('">','" title="'.$on_mouse_show . '">' , $ret);

	if (empty($show))
		return $ret;
	else
		echo $ret;	
}
// page link
function xpress_left_arrow_posts_link($show = false)
{
	global $xpress_config;
	$ret = '';
		
	if($xpress_config->is_left_page_navi_old){
		$link_title = $xpress_config->old_page_link_text;
		ob_start();
		next_posts_link("&laquo; $link_title");
		$ret = ob_get_contents();
		ob_end_clean();
	} else {
		$link_title = $xpress_config->newer_page_link_text;
		ob_start();
		previous_posts_link("&laquo; $link_title");
		$ret = ob_get_contents();
		ob_end_clean();
	}

	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_right_arrow_posts_link($show = false)
{
	global $xpress_config;
	$ret = '';		
	
	if($xpress_config->is_left_page_navi_old){
		$link_title = $xpress_config->newer_page_link_text;
		ob_start();
		previous_posts_link("$link_title &raquo;");
		$ret = ob_get_contents();
		ob_end_clean();
	} else {
		$link_title = $xpress_config->old_page_link_text;
		ob_start();
		next_posts_link("$link_title &raquo;");
		$ret = ob_get_contents();
		ob_end_clean();
	}

	if (empty($show))
		return $ret;
	else
		echo $ret;	
}


function xpress_is_author_view_count(){
	global $xpress_config;
	return $xpress_config->is_author_view_count;
}

function xpress_is_multi_user(){
	global $xpress_config;
	return $xpress_config->is_multi_user;
}


function xpress_substr($str, $start, $length, $trimmarker = '...')
{
    if (function_exists('mb_substr')){
        $str2 = mb_substr( $str , $start , $length);
        return $str2 . ( mb_strlen($str)!=mb_strlen($str2) ? $trimmarker : '' );
    } else {
        return ( strlen($str) - $start <= $length ) ? substr( $str, $start, $length ) : substr( $str, $start, $length - strlen($trimmarker) ) . $trimmarker;
    }
}


// views count
// Set and retrieves post views given a post ID or post object. 
// Retrieves post views given a post ID or post object. 
function xpress_post_views_count($post_id=0,$format= '',$show = true) {
	global $xoops_db,$wpdb;

	static $post_cache_views;

	if ( empty($post_id) ) {
		if ( isset($GLOBALS['post']) )
			$post_id = $GLOBALS['post']->ID;
	}

	$post_id = intval($post_id);
	if($post_id==0) return null;
	if(!isset($post_cache_views[$post_id])){
        $sql = "SELECT post_views FROM " . get_wp_prefix() . "views" . " WHERE post_id=$post_id";
        $post_views = $xoops_db->get_var($sql);
        if (!$post_views) {
	        $post_cache_views[$post_id] = 0;
        }else{
	        $post_cache_views[$post_id] = $post_views;
        }
	}
	$v_count = intval($post_cache_views[$post_id]);
	
	if (empty($format)) $format = __('views :%d','xpressme');
	
	$ret = sprintf($format,$v_count);

	if ($show) echo $ret; else return $ret;
}

function set_post_views_count(&$content) {
	if ( empty($_GET["feed"]) &&  empty($GLOBALS["feed"]) && empty($GLOBALS["doing_trackback"]) && empty($GLOBALS["doing_rss"]) && empty($_POST) && is_single() ){
		post_views_counting();
	}
	return $content;
}

// Set post views given a post ID or post object. 
function post_views_counting($post_id = 0) {
	global $xoops_db,$wpdb;
	global $table_prefix;
	static $views;
	
	$post_id = intval($post_id);
	if ( empty($post_id) && isset($GLOBALS['post']) ){
		$post_id = $GLOBALS['post']->ID;
	}


	$views_db = get_wp_prefix() . 'views';

	if($post_id==0 || !empty($views[$post_id])) return null;
	
	if(!xpress_is_author_view_count()){
		$current_user_id = $GLOBALS['current_user']->ID;
		$post_author_id = $GLOBALS['post']->post_author;
		if ($current_user_id ==$post_author_id) return null;
	}

    $sql = "SELECT post_views FROM " . $views_db . " WHERE post_id=$post_id";
	$post_views_found = $xoops_db->get_var($sql);
	if($post_views_found){
        $sql = "UPDATE " . $views_db . " SET post_views=post_views+1 WHERE post_id=$post_id";
    }else{
        $sql = "INSERT INTO " . $views_db . " (post_id, post_views) VALUES ($post_id, 1)";
    }
    $xoops_db->query($sql);
	return true;
}

function get_xpress_excerpt_contents($excerpt_length_word,$excerpt_length_character,$more_link_text = '') {
	global $post,$xpress_config;
	
	$blog_encoding = get_option('blog_charset');
	$text = get_the_content('');
	$text = strip_shortcodes( $text );
	$text = apply_filters('the_content', $text);
	$text = str_replace(']]>', ']]&gt;', $text);
	$text = strip_tags($text);
	$is_almost_ascii = ($xpress_config->ascii_judged_rate < round(@(mb_strlen($text, $blog_encoding) / strlen($text)) * 100)) ? true : false;
	if($is_almost_ascii) {
		$words = explode(' ', $text, $excerpt_length_word + 1);

		if(count($words) > $excerpt_length_word) {
			array_pop($words);
			array_push($words, ' ... ');
			$text = implode(' ', $words);
			if (!empty($more_link_text)) $text .= '<p align="center"><a href="'. get_permalink() . "\">".$more_link_text .'</a></p>';

		}
	}
	elseif(mb_strlen($text, $blog_encoding) > $excerpt_length_character) {
		$text = mb_substr($text, 0, $xpress_config->excerpt_length_character, $blog_encoding) . ' ... ';
		if (!empty($more_link_text)) $text .= '<p align="center"><a href="'. get_permalink() . "\">".$more_link_text .'</a></p>';
	}

	return $text;
}

function xpress_the_content($more_link_text = null, $stripteaser = 0, $more_file = '',$show = true)
{
	global $post,$xpress_config;
	
	
	if ($xpress_config->is_content_excerpt){
		$excerpt_length_word = $xpress_config->excerpt_length_word;
		$excerpt_length_character = $xpress_config->excerpt_length_character;
		$more_link_text = $xpress_config->more_link_text;
		$content = get_xpress_excerpt_contents($excerpt_length_word,$excerpt_length_character,$more_link_text);
	} else {
		$content = get_the_content($more_link_text,$stripteaser,$more_file);
		$content = apply_filters('the_content', $content);
		$content = str_replace(']]>', ']]&gt;', $content);
	}	
	if(empty($show)) return $content;
	echo $content;
}

function is_xpress_contributor()
{
	global $current_user;
	get_currentuserinfo();
	if ($current_user->user_level > 3)
		return true;
	else
		return false;
}

function xpress_post_new_link($link_title,$display = true)
{
	$output = '<a href="'. get_xpress_url() . '/wp-admin/post-new.php' . '">' . $link_title . '</a>';
	if ($display) 
		echo $output;
	else
		return $output;
}

function xpress_conditional_title($display = true)
{
	$selected_author = xpress_selected_author(false);
	
	$output = __('Main', 'xpressme');
	$output = '';
	if (is_category())
		$output = sprintf(__('Archive for the &#8216;%s&#8217; Category', 'xpressme'), single_cat_title('', false));
	if (is_tag())
		$output = sprintf(__('Posts Tagged &#8216;%s&#8217;', 'xpressme'), single_tag_title('', false) );
	if (is_day())
		$output = sprintf(__('Archive for %s|Daily archive page', 'xpressme'), get_the_time(__('F jS, Y', 'xpressme')));
	if (is_month())
		$output = sprintf(__('Archive for %s|Monthly archive page', 'xpressme'), get_the_time(__('F, Y', 'xpressme')));
	if (is_year())
		$output = sprintf(__('Archive for %s|Yearly archive page', 'xpressme'), get_the_time(__('Y', 'xpressme')));
	if (is_author()){
		if (empty($selected_author))
			$output = sprintf(__('Archive for the &#8216;%s&#8217; Author', 'xpressme'), get_author_name( get_query_var('author')));
	}
	if (is_search())
		$output = sprintf(__('Search Results of word &#8216;%s&#8217;', 'xpressme'), get_search_query());
	
	if (!empty($selected_author)){
		$selected_id = xpress_selected_author_id(false);
//		$output = get_avatar($selected_id,$size = '32') . sprintf(__('Article of %s', 'xpressme'), $selected_author) . ' - ' . $output;
		if (empty($output))
			$output = sprintf(__('Article of %s', 'xpressme'), $selected_author) ;
		else
			$output = sprintf(__('Article of %s', 'xpressme'), $selected_author) . ' - ' . $output;
	}	
	if ($display) 
		echo $output;
	else
		return $output;
}

function xpress_pings_list($show = false){
	
	$trackbacks = xpress_get_pings();
	if (! empty($trackbacks)) {
		$output = '<ol id="xpress_pingslist"> ';

		foreach ($trackbacks as $trackback){
			$list = date(get_settings('date_format'),$trackback['date']) . ' <a target="_blank" href="' . $trackback['site_url'] . '" rel="external nofollow">' . sprintf(__('From %1$s on site %2$s','xpressme'),$trackback['title'],$trackback['site_name']) . "</a>\n" ;

			$output .=  '<li>';
			$output .=  $list ;
			$output .=  '</li>';

		}
		$output .= '</ol>' ;
	} else {
		$output = '';
	}
	
	if ($show) echo $output; else return $output;
}

function xpress_pings_number( $zero = false, $one = false, $more = false, $deprecated = '' ) {
	$pings = xpress_get_pings();
	if (empty($pings)){
		$number = 0;
	}else {
		$number = count($pings);
	}
	if ( $number > 1 )
		$output = str_replace('%', number_format_i18n($number), ( false === $more ) ? __('% TrackBack/Pingback', 'xpressme') : $more);
	elseif ( $number == 0 )
		$output = ( false === $zero ) ? __('No Trackback/Pingback', 'xpressme') : $zero;
	else // must be one
		$output = ( false === $one ) ? __('One Trackback/Pingback', 'xpressme') : $one;

	echo $output;
}


function xpress_get_pings()
{
	global $withcomments, $post, $wpdb, $id, $trackback, $user_login, $user_ID, $user_identity;

	if ( ! (is_single() || is_page() || $withcomments) )
		return;

	/** @todo Use API instead of SELECTs. */
	if ( $user_ID) {
		$trackbacks = $wpdb->get_results(sprintf("SELECT * FROM $wpdb->comments WHERE comment_post_ID = %d AND (comment_approved = '1' OR ( user_id = %d AND comment_approved = '0' ) ) AND ( comment_type = 'trackback' OR comment_type = 'pingback' ) ORDER BY comment_date", $post->ID, $user_ID));
	} else if ( empty($trackback_author) ) {
		$trackbacks = $wpdb->get_results(sprintf("SELECT * FROM $wpdb->comments WHERE comment_post_ID = %d AND comment_approved = '1' AND ( comment_type = 'trackback' OR comment_type = 'pingback' ) ORDER BY comment_date", $post->ID));
	} else {
		$trackbacks = $wpdb->get_results(sprintf("SELECT * FROM $wpdb->comments WHERE comment_post_ID = %d AND ( comment_approved = '1' OR ( comment_author = %s AND comment_author_email = %s AND comment_approved = '0' ) ) AND ( comment_type = 'trackback' OR comment_type = 'pingback' ) ORDER BY comment_date", $post->ID, $trackback_author, $trackback_author_email));
	}

	if ($trackbacks){
		$ret = array();
		foreach ($trackbacks as $trackback){

			$pattern = '<strong>(.*)<\/strong>(.*)';
			if ( preg_match ( "/".$pattern."/i", $trackback->comment_content , $match ) ){
				$title = $match[1];
				$content = $match[2];
			}
			if (empty($title)) $title = $trackback->comment_author;


			$row_data = array(
				'ID'		=> $trackback->comment_ID ,
				'post_ID'	=> $trackback->comment_post_ID ,
				'site_name' => $trackback->comment_author ,
				'site_url' => $trackback->comment_author_url ,
				'title' => $title ,
				'content' => $content ,
				'date'		=> $trackback->comment_date ,
				'date_gmt'		=> $trackback->comment_date_gmt ,
				'agent'		=> $trackback->comment_agent ,
				'type'		=> $trackback->comment_type ,
				'IP'		=> $trackback->comment_author_IP ,
			);
			array_push($ret,$row_data);
		}
		return $ret;
	}
			return false;
}
?>
