<?php
if( ! function_exists( 'xpress_mu_install_defaults' ) ) :
function xpress_mu_install_defaults($domain,$base,$site_name,$admin_user_id,$admin_user_name,$admin_email){
		global $xoops_config,$wpdb,$wp_rewrite, $wp_queries, $table_prefix, $wp_db_version, $wp_roles, $wp_query;
		
		// set up MU site tables
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'site_name', '" . $site_name . "')" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'admin_email', '".$admin_email."')" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'admin_user_id', '". $admin_user_id ."')" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'registration', 'none')" );
		$wpdb->query( "INSERT INTO ".$wpdb->site." ( id, domain, path ) VALUES ( NULL, '$domain', '$base' )" );
		$wpdb->query( "INSERT INTO " . $wpdb->sitecategories . " ( cat_ID, cat_name, category_nicename, last_updated ) VALUES (1, 'Uncategorized', 'uncategorized', NOW())" );
		$wpdb->query( "INSERT INTO " . $wpdb->sitecategories . " ( cat_ID, cat_name, category_nicename, last_updated ) VALUES (2, 'Blogroll', 'blogroll', NOW())" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'upload_filetypes', 'jpg jpeg png gif mp3 mov avi wmv midi mid pdf' )" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'blog_upload_space', '10' )" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'fileupload_maxk', '1500' )" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'site_admins', '" . serialize( array( $admin_user_name ) ) . "' )" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'allowedthemes', '" . serialize( array( 'classic' => 1, 'default' => 1, 'xpress_default' => 1 ) ) . "' )" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'illegal_names', '" . serialize( array(  "www", "web", "root", "admin", "main", "invite", "administrator" ) ) . "' )" );
		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'welcome_email', 'Dear User,

Your new $site_name blog has been successfully set up at:
BLOG_URL

You can log in to the administrator account with the following information:
Username: USERNAME
Password: PASSWORD
Login Here: BLOG_URLwp-login.php

We hope you enjoy your new blog.
Thanks!

--The Team @ SITE_NAME')" );

		$wpdb->query( "INSERT INTO ".$wpdb->sitemeta." (meta_id, site_id, meta_key, meta_value) VALUES (NULL, 1, 'first_post', 'Welcome to <a href=\"$site_url\">$site_name</a>. This is your first post. Edit or delete it, then start blogging!' )" );
		$weblog_title = $site_name;


		$current_site->domain = $domain;
		$current_site->path = $base;
		$current_site->site_name = $site_name;

		update_blog_option( 1, 'template', 'xpress_mu_home');
		update_blog_option( 1, 'stylesheet', 'xpress_mu_home');
		
		mu_create_blog( $domain, $base, $weblog_title, $user_id, array( 'blog_public' => 1, 'public' => 1 ) );
}
endif;

if( ! function_exists( 'do_htaccess' ) ) :
function do_htaccess( $oldfilename, $newfilename, $base, $url ) {
	// remove ending slash from $base and $url
	$htaccess = '';
	if( substr($base, -1 ) == '/') {
		$base = substr($base, 0, -1);
	}

	if( substr($url, -1 ) == '/') {
		$url = substr($url, 0, -1);
	}
	$err = '';
	if( is_file( $oldfilename ) ) {
		$fp = @fopen( $oldfilename, "r" );
		if( $fp ) {
			while( !feof( $fp ) )
			{
				$htaccess .= fgets( $fp, 4096 );
			}
			fclose( $fp );
			$htaccess = str_replace( "BASE", $base, $htaccess );
			if( touch( $newfilename ) ) {
				$fp = fopen( $newfilename, "w" );
				if( $fp ) {
					fwrite( $fp, $htaccess );
					fclose( $fp );
				} else {
					$err = "could not open $newfilename for writing";
				}
			} else {
				$err = "could not open $newfilename for writing";
			}
		} else {
			$err = "could not open $oldfilename for reading";
		}
	} else {
		$err = "$oldfilename not found";
	}

	if( $err != '' ) {
		print "<h2>Warning!</h2>";
		print "<p><strong>There was a problem creating the .htaccess file.</strong> </p>";
		print "<p style='color: #900'>Error: ";
		if( $err == "could not open $newfilename for writing" ) {
			print "Could Not Write To $newfilename.";
		} elseif( $err == "could not open $oldfilename for reading" ) {
			print "I could not read from $oldfilename. ";
		} elseif( $err == "$oldfilename not found" ) {
			print "The file, $oldfilename, is missing.";
		}
		print "</p>";
		filestats( $err );

		print "<p>Please ensure that the webserver can write to this directory.</p>";
		print "<p>If you use Cpanel then read <a href='http://mu.wordpress.org/forums/topic.php?id=99'>this post</a>. Cpanel creates files that I need to overwrite and you have to fix that.</p>";
		print "<p>If all else fails then you'll have to create it by hand:";
		print "<ul>
			<li> Download htaccess.dist to your computer and open it in your favourite text editor.</li>
			<li> Replace the following text:
			<ul>
			<li>BASE by '$base'</li>
			<li>HOST by '$url'</li>
			</ul>
			</li>
			<li> Rename htaccess.dist to .htaccess and upload it back to the same directory.</li>
			</ul>";
		die( "Installation Aborted!" );
	}
}
endif;

// this function is used to change wpmu_create_blog()
// wpmu_create_blog() of wp_includes/wpmu_functions.php has the bug 
// when install_blog_defaults is called.
if( ! function_exists( 'mu_create_blog' ) ) :
function mu_create_blog($domain, $path, $title, $user_id, $meta = '', $site_id = 1) {
	global $wpdb,$wp_rewrite, $wp_queries, $table_prefix, $wp_db_version, $wp_roles, $wp_query;
	global $xoops_config;
	global $base,$current_site, $dirs, $wpmu_version;

	if(!is_object($wp_rewrite)){
		$wp_rewrite   =& new WP_Rewrite();
	}
	
	$domain = preg_replace( "/\s+/", '', sanitize_user( $domain, true ) );
	if( constant( 'VHOST' ) == 'yes' )
		$domain = str_replace( '@', '', $domain );
	$title = strip_tags( $title );
	$user_id = (int) $user_id;

	if( empty($path) )
		$path = '/';

	// Check if the domain has been used already. We should return an error message.
	if ( domain_exists($domain, $path, $site_id) )
		return new WP_Error('blog_taken', __('Blog already exists.'));

	if ( !defined("WP_INSTALLING") )
		define( "WP_INSTALLING", true );

	if ( ! $blog_id = insert_blog($domain, $path, $site_id) )
		return new WP_Error('insert_blog', __('Could not create blog.'));

	switch_to_blog($blog_id);

	install_blog($blog_id, $title);

	install_mu_blog_defaults($blog_id, $user_id);

	add_user_to_blog($blog_id, $user_id, 'administrator');

	if ( is_array($meta) ) foreach ($meta as $key => $value) {
		if( $key == 'public' || $key == 'archived' || $key == 'mature' || $key == 'spam' || $key == 'deleted' || $key == 'lang_id' ) {
			update_blog_status( $blog_id, $key, $value );
		} else {
			update_option( $key, $value );
		}
	}

	add_option( 'WPLANG', get_site_option( 'WPLANG' ) );

	update_option( 'blog_public', $meta['public'] );

	if(get_usermeta( $user_id, 'primary_blog' ) == 1 )
		update_usermeta( $user_id, 'primary_blog', $blog_id );


	restore_current_blog();

	do_action( 'wpmu_new_blog', $blog_id, $user_id );

	return $blog_id;
}
endif;

// this function is used to change install_blog_defaults()
// When install_blog_defaults is called, $wp_rewrite is not object. 
if( ! function_exists( 'install_mu_blog_defaults' ) ) :
function install_mu_blog_defaults($blog_id, $user_id) {
	global $wpdb, $wp_rewrite, $current_site, $table_prefix;
	if(!is_object($wp_rewrite)){
		$wp_rewrite   =& new WP_Rewrite();
	}

	$wpdb->suppress_errors();

	// Cast for security
	$user_id = (int) $user_id;
	$blog_id = (int) $blog_id;

	// Default links
	$wpdb->insert( $wpdb->links,  array('link_url' => 'http://wordpress.com/', 'link_name' => 'WordPress.com', 'link_category' => '1356', 'link_owner' => $user_id, 'link_rss' => 'http://wordpress.com/feed/') );
	$wpdb->insert( $wpdb->links,  array('link_url' => 'http://wordpress.org/', 'link_name' => 'WordPress.org', 'link_category' => '1356', 'link_owner' => $user_id, 'link_rss' => 'http://wordpress.org/development/feed/') );
	$wpdb->insert( $wpdb->term_relationships, array('object_id' => 1, 'term_taxonomy_id' => 2));
	$wpdb->insert( $wpdb->term_relationships, array('object_id' => 2, 'term_taxonomy_id' => 2));

	// First post
	$now = date('Y-m-d H:i:s');
	$now_gmt = gmdate('Y-m-d H:i:s');
	$first_post = get_site_option( 'first_post' );
	if( $first_post == false ) {
		$first_post = stripslashes( __( 'Welcome to <a href="SITE_URL">SITE_NAME</a>. This is your first post. Edit or delete it, then start blogging!' ) );
	}
	$first_post = str_replace( "SITE_URL", clean_url("http://" . $current_site->domain . $current_site->path), $first_post );
	$first_post = str_replace( "SITE_NAME", $current_site->site_name, $first_post );
	$wpdb->insert( $wpdb->posts, array(
		'post_author' => $user_id, 
		'post_date' => $now, 
		'post_date_gmt' => $now_gmt,
		'post_content' => stripslashes( $first_post ), 
		'post_excerpt' => '', 
		'post_title' => __('Hello world!'),
		'post_category' => 0, 
		'post_name' => __('hello-world'),
		'post_modified' => $now,
		'post_modified_gmt' => $now_gmt,
		'comment_count' => 1
	) );	
	$wpdb->insert( $wpdb->term_relationships, array('object_id' => 1, 'term_taxonomy_id' => 1));
	update_option( "post_count", 1 );

	// First page
	$wpdb->insert( $wpdb->posts, array(
		'post_author' => $user_id, 
		'post_date' => $now, 
		'post_date_gmt' => $now_gmt,
		'post_content' => __('This is an example of a WordPress page, you could edit this to put information about yourself or your site so readers know where you are coming from. You can create as many pages like this one or sub-pages as you like and manage all of your content inside of WordPress.'), 
		'post_excerpt' => '', 
		'post_title' => __('About'),
		'post_category' => 0, 
		'post_name' => __('about'),
		'post_modified' => $now,
		'post_modified_gmt' => $now_gmt,
		'post_status' => 'publish',
		'post_type' => 'page',
		'to_ping' => '',
		'pinged' => '',
		'post_content_filtered' => ''
	) );
	
	// Flush rules to pick up the new page.
	$wp_rewrite->init();
	$wp_rewrite->flush_rules();

	// Default comment
	$wpdb->insert( $wpdb->comments, array(
		'comment_post_ID' => '1', 
		'comment_author' => __('Mr WordPress'), 
		'comment_author_email' => '',
		'comment_author_url' => 'http://' . $current_site->domain . $current_site->path, 
		'comment_author_IP' => '127.0.0.1', 
		'comment_date' => $now,
		'comment_date_gmt' => $now_gmt, 
		'comment_content' => __("Hi, this is a comment.<br />To delete a comment, just log in, and view the posts' comments, there you will have the option to edit or delete them.") 
	) );
	
	$user = new WP_User($user_id);
	$wpdb->update( $wpdb->options, array('option_value' => $user->user_email), array('option_name' => 'admin_email') );

	// Remove all perms except for the login user.
	$wpdb->query( $wpdb->prepare("DELETE FROM $wpdb->usermeta WHERE user_id != %d AND meta_key = %s", $user_id, $table_prefix.'user_level') );
	$wpdb->query( $wpdb->prepare("DELETE FROM $wpdb->usermeta WHERE user_id != %d AND meta_key = %s", $user_id, $table_prefix.'capabilities') );
	
	// Delete any caps that snuck into the previously active blog. (Hardcoded to blog 1 for now.) TODO: Get previous_blog_id.
	if ( !is_site_admin( $user->user_login ) && $user_id != 1 )
		$wpdb->query( $wpdb->prepare("DELETE FROM $wpdb->usermeta WHERE user_id = %d AND meta_key = %s", $user_id, $wpdb->base_prefix.'1_capabilities') );

	$wpdb->suppress_errors( false );
}
endif;

?>