<?php
require_once dirname( __FILE__ ).'/include/xpress_debug_log.php' ;
require_once dirname( __FILE__ ).'/class/config_from_xoops.class.php' ;
$xoops_config = new ConfigFromXoops;
require_once dirname( __FILE__ ).'/include/set_cash_cookie_path.php' ;

/**
 * mb_language() sets language. If language  is omitted, it returns current language as string.
 * language setting is used for encoding e-mail messages. 
 * Valid languages are "Japanese", "ja","English","en" and "uni" (UTF-8). 
 * mb_send_mail() uses this setting to encode e-mail.
 * Language and its setting is ISO-2022-JP/Base64 for Japanese, UTF-8/Base64 for uni, ISO-8859-1/quoted printable for English. 
 */
 if (function_exists("mb_language")) mb_language('uni');


// ** MySQL settings - You can get this info from your web host ** //
// Do not change  'DB_NAME','DB_USER','DB_PASSWORD' & 'DB_HOST'
// because copies a set value of XOOPS. 

/** Do not change. The name of the database for WordPress */
define('DB_NAME', $xoops_config->xoops_db_name);

/** Do not change. MySQL database username */
define('DB_USER', $xoops_config->xoops_db_user);

/** Do not change. MySQL database password */
define('DB_PASSWORD', $xoops_config->xoops_db_pass);

/** Do not change. MySQL hostname */
define('DB_HOST', $xoops_config->xoops_db_host);
	
/** Database Charset to use in creating database tables. */
define('DB_CHARSET', 'utf8');

/** The Database Collate type. Don't change this if in doubt. */
define('DB_COLLATE', '');

//define('WP_DEBUG' ,true);

/**#@+
 * Authentication Unique Keys.
 *
 * Change these to different unique phrases!
 * You can generate these using the {@link https://api.wordpress.org/secret-key/1.1/ WordPress.org secret-key service}
 *
 * @since 2.6.0
 */
define('AUTH_KEY', 'put your unique phrase here');
define('SECURE_AUTH_KEY', 'put your unique phrase here');
define('LOGGED_IN_KEY', 'put your unique phrase here');
define('NONCE_KEY', 'put your unique phrase here');

if ($xoops_config->is_wpmu){	//for WordPressMU
	define('VHOST', 'no'); 
	$base = $xoops_config->mu_path_current_site;
	define('DOMAIN_CURRENT_SITE', $xoops_config->mu_domain_current_site );
	define('PATH_CURRENT_SITE', $xoops_config->mu_path_current_site );
	define('SITE_ID_CURRENT_SITE', 1);
	define('BLOGID_CURRENT_SITE', '1' );

	define('AUTH_SALT', 'put your unique phrase here');
	define('LOGGED_IN_SALT', 'put your unique phrase here');
	define('SECURE_AUTH_SALT', 'put your unique phrase here');
}

/**
 * WordPress Database Table prefix.
 *
 * You can have multiple installations in one database if you give each a unique
 * prefix. Only numbers, letters, and underscores please!
 */
// Do not change. $table_prefix is generated from XOOPS DB Priefix and the module directory name. 
$table_prefix  = $xoops_config->module_db_prefix;

/**
 * WordPress Localized Language, defaults to Japanese.
 *
 * Change this to localize WordPress.  A corresponding MO file for the chosen
 * language must be installed to wp-content/languages. For example, install
 * de.mo to wp-content/languages and set WPLANG to 'de' to enable German
 * language support.
 *
 * Example:
 * define ('WPLANG', '');		// language support to English
 */
define ('WPLANG', 'ja');		// language support to Japanese

/* That's all, stop editing! Happy blogging. */

/** WordPress absolute path to the Wordpress directory. */
if ( !defined('ABSPATH') )
	define('ABSPATH', dirname(__FILE__).'/');

require_once( ABSPATH .'/include/request_url.php');
if (is_xpress_index_page_call()){
	require_once $xoops_config->xoops_mainfile_path; //It is necessary to execute it for the user attestation before wp-settings.php. 
	require_once(ABSPATH.'wp-settings.php');
	wp();
	
	if (!function_exists('is_wordpress_style')){	// When the XPressME plug-in is invalid
		require_once dirname( __FILE__ ).'/include/xpress_active_plugin.php' ;
		xpress_pulugin_activation('xpressme/xpressme.php');
		// reloaded 
		header('Location: ' . $xoops_config->module_url . '/');
		
		$err_str = "The activation of the XPressME plugin was executed.<br />\n";
		$err_str .= "Because the XPressME plugin was invalid.<br />\n";
		$err_str .= "Please do the rereading seeing on the page.\n";			
		die($err_str);
	}

	ob_start();	
		if($xoops_config->is_wp20 )
			require_once dirname( __FILE__ ).'/include/old_template-loader.php' ;
		else
			require_once( ABSPATH . WPINC . '/template-loader.php' );
		$wp_output = ob_get_contents();
	ob_end_clean();
	// It judges it here because it does in is_index_page() through feed to which the permalink is set. 
	if (is_wordpress_style() || is_feed()) {
		echo $wp_output;
	} else {
		require_once( ABSPATH .'/include/xpress_render.php' );
		xpress_render($wp_output);
	}

	//When there is no block cache, and an optional block is different, cache is refreshed. 
	//When adding, and changing and deleting Post & Comment, block cache is refreshed by add_action at any time. 
	// This Function in xpressme plugin
	require_once( ABSPATH .'/include/xpress_block_render.php' );	
	xpress_unnecessary_block_cache_delete($xoops_config->module_name);
	if (is_home()) xpress_block_cache_refresh($xoops_config->module_name);
	exit();		// The return to wp-blog-header.php is stolen here
}
if (is_admin_post_call()) require_once $xoops_config->xoops_mainfile_path;
if (is_xpress_comments_post_call()) require_once $xoops_config->xoops_mainfile_path;
require_once(ABSPATH.'wp-settings.php');
?>