<?php

load_plugin_textdomain('xpressme', 'wp-content/plugins/xpressme/language');

class XPressME_Class{
	var $pluginName = 'xpressme';	
	var $is_use_xoops_upload_path;
	var $is_theme_sidebar_disp;
	var $is_save_post_revision;
	var $is_postnavi_title_disp;
	var $is_left_postnavi_old;
	var $old_post_link_text;
	var $newer_post_link_text;

	//constructor
	function XPressME_Class()
	{
		$this->setdefault();    //not setting propaty load
		$this->SettingValueRead();
	}


	function add_option_page()
	{
		add_options_page('XPressME', __('XPressME Settings', 'xpressme'), 8, 'xpressme_config', array(&$this, 'option_page'));
	}
	
	function add_admin_head()
	{ 
		// add header text
	}

	
		//Set Default Value	
	function setDefault()
	{
		$this->is_use_xoops_upload_path = true;
		$this->is_theme_sidebar_disp = true;
		$this->is_save_post_revision = true;
		$this->is_postnavi_title_disp = true;
		$this->is_left_postnavi_old = true;
		$this->old_post_link_text = __('to Old Post');
		$this->newer_post_link_text = __('to Newer Post');
	}
	
	function SettingValueRead()
	{
		$options = get_option('xpressme_option');
		if (!$options) {
			$this->setDefault();
			$this->SettingValueWrite('add_new');
		} else {
			foreach ($options as $option_name => $option_value){
	        		$this-> {$option_name} = $option_value;
			}
		}
	}
	
		// mode 0:add  1:update	
	function SettingValueWrite($mode)
	{
		$write_options = array (
			'is_use_xoops_upload_path' => $this->is_use_xoops_upload_path ,
			'is_theme_sidebar_disp' => $this->is_theme_sidebar_disp ,
			'is_save_post_revision' => $this->is_save_post_revision ,
			'is_postnavi_title_disp' => $this->is_postnavi_title_disp ,
			'is_left_postnavi_old' => $this->is_left_postnavi_old ,
			'old_post_link_text' => $this->old_post_link_text ,
			'newer_post_link_text' => $this->newer_post_link_text 
		);
		if ($mode == 'add_new') {
			add_option('xpressme_option', $write_options);
		} else {			
			update_option("xpressme_option", $write_options);
		}
	}
	
	function ReadPostData()
	{
		$this->is_use_xoops_upload_path = stripslashes(trim($_POST['ch_is_use_xoops_upload_path']));
		$this->is_theme_sidebar_disp = stripslashes(trim($_POST['ch_is_theme_sidebar_disp']));
		$this->is_save_post_revision = stripslashes(trim($_POST['ch_is_save_post_revision']));
		$this->is_postnavi_title_disp = stripslashes(trim($_POST['ch_is_postnavi_title_disp']));
		$this->is_left_postnavi_old = stripslashes(trim($_POST['ch_is_left_postnavi_old']));
		$this->old_post_link_text = stripslashes($_POST['ch_old_post_link_text']);
		if(empty($this->old_post_link_text)) $this->old_post_link_text = __('to Old Post');
		$this->newer_post_link_text = stripslashes($_POST['ch_newer_post_link_text']);
		if(empty($this->newer_post_link_text)) $this->newer_post_link_text = __('to Newer Post');
		
	}
	
	function yes_no_radio_option($option_name,$option_desc,$yes = '',$no= ''){
		if (empty( $yes ))  $yes = __('YES','xpressme') ;
		if (empty( $no ))  $no = __('NO','xpressme') ;
		$value = $this->{$option_name};
		$ans_name = 'ch_' . $option_name;
		
		$form  =  "<tr>\n";
		$form .=  '<th><label for="images_to_link">' . $option_desc . "</label></th>\n";
		$form .=  "<td>\n";
		if ($value){
			$form .= "<label><input type='radio' name='". $ans_name . "' value='1' checked='checked' />" . $yes ."</label><br />\n";
			$form .= "<label><input type='radio' name='". $ans_name . "' value='0' />". $no . "</label>\n";
		}else{
			$form .= "<label><input type='radio' name='". $ans_name . "' value='1' />" . $yes . "</label><br />\n";
			$form .= "<label><input type='radio' name='". $ans_name . "' value='0' checked='checked' />". $no ."</label>\n";
		}
		$form .=  "</td>\n";
		$form .=  "</tr><tr>\n";
			
	    return $form;
	
	}

	function text_option($option_name,$option_desc){
		$value = $this->{$option_name};
		$ans_name = 'ch_' . $option_name;
		
		$form  =  "<tr>\n";
		$form .=  '<th><label for="images_to_link">' . $option_desc . "</label></th>\n";
		$form .=  "<td>\n";
		$form .= '<label> <input name="'. $ans_name . '" type="text" size="25" maxlength="50" value="'  . $value . '" /></label>'."\n";
		$form .=  "</td>\n";
		$form .=  "</tr><tr>\n";
			
	    return $form;
	
	}
		
	function option_page()
	{
		if (!empty($_POST['submit_update'])) {
			$this->ReadPostData();
			$this->SettingValueWrite('update');
		} else if (isset($_POST['submit_reset'])) {
			$this->fck_setDefault();
			$this->SettingValueWrite('update');
		} 

		
		echo	'<div class="wrap">'."\n";
		echo		'<div id="icon-options-general" class="icon32"><br /></div>'."\n";
		echo		'<h2>' . __('XPressME Configuration Page', 'xpressme') . "</h2>\n";
		echo		'<form method="post" action="' . $_SERVER["REQUEST_URI"] . '">'."\n" ;
		echo			'<table class="form-table">'."\n";
		echo				$this->yes_no_radio_option('is_use_xoops_upload_path',
												__('Media Upload Base Path','xpressme'),
												__('Use XOOPS UPLOAD PATH','xpressme'),
												__('USE WordPress BASE_PATH','xpressme')
												);
		echo				$this->yes_no_radio_option('is_theme_sidebar_disp',
												__('Thema Sidebar Display','xpressme'),
												__('YES','xpressme'),
												__('NO','xpressme')
												);
		echo				$this->yes_no_radio_option('is_save_post_revision',
												__('The change tracking of the post is preserved','xpressme'),
												__('YES','xpressme'),
												__('NO','xpressme')
												);
		echo				$this->yes_no_radio_option('is_postnavi_title_disp',
												__('Select Display name of PostNavi Link','xpressme'),
												__('Title of post','xpressme'),
												__('Next and Previous','xpressme')
												);
		echo				$this->yes_no_radio_option('is_left_postnavi_old',
												__('Adjustment of Navi link display position','xpressme'),
												__("'Old Post Link' is displayed in the left, and 'Newer Post Link' is displayed in the right",'xpressme'),
												__("'Newer Post Link' is displayed in the left, and 'Old Post Link' is displayed in the right",'xpressme')
												);
		echo				$this->text_option('old_post_link_text',
												__('Display Title of Old Post Link','xpressme')
												);
		echo				$this->text_option('newer_post_link_text',
												__('Display Title of Newer Post Link','xpressme')
												);
		
			
//		$this->is_use_xoops_upload_path_html();
		echo			"</table>\n";
		
		echo		'<p class="submit">'."\n";
		echo		'<input type="submit" value= "' . __('Update Config', 'xpressme') . '" name="submit_update" />' ."\n";
		echo		'<input type="submit" value= "' . __('Preset Config', 'xpressme') . '" name="submit_reset" />' ."\n";
		echo		"</p>\n";

		echo		"</form>\n" ;
		echo	"</div>\n";
	}
	
	function xpress_upload_filter($uploads)
	{
		if ($this->is_use_xoops_upload_path){
			if (!defined("XOOPS_UPLOAD_PATH"))
				define("XOOPS_UPLOAD_PATH", XOOPS_ROOT_PATH."/uploads");
			if (!defined("XOOPS_UPLOAD_URL"))
				define("XOOPS_UPLOAD_URL", XOOPS_URL."/uploads");

			$wordpress_dir = ABSPATH ;
			$xoops_dir = XOOPS_UPLOAD_PATH . '/';
			$wordpress_base_url = get_option( 'siteurl' );
			$xoops_upload_url = XOOPS_UPLOAD_URL;
			
			$uploads[path] =  str_replace ($wordpress_dir, $xoops_dir, $uploads[path]);
			$uploads[basedir] = str_replace ($wordpress_dir, $xoops_dir, $uploads[basedir]);
			$uploads[url] = str_replace ($wordpress_base_url, $xoops_upload_url, $uploads[url]);
			$uploads[baseurl] = str_replace ($wordpress_base_url, $xoops_upload_url, $uploads[baseurl]);
		}
		return $uploads;
	}	

}
?>