<?php

load_plugin_textdomain('xpressme', 'wp-content/plugins/xpressme/language');

class XPressME_Class{
	var $pluginName = 'xpressme';	
	var $is_use_xoops_upload_path;
	var $is_theme_sidebar_disp;
	var $is_save_post_revision;
	var $is_postnavi_title_disp;
	var $is_left_postnavi_old;
	var $old_post_link_text;
	var $newer_post_link_text;
	var $is_left_page_navi_old;
	var $old_page_link_text;
	var $newer_page_link_text;
	var $is_author_view_count;
	var $is_sql_debug;
	var $groupe_role;
	var $is_use_d3forum;
	var $d3forum_module_dir;
	var $d3forum_forum_id;
	var $d3forum_external_link_format;
	var $is_content_excerpt;
	var $ascii_judged_rate;
	var $excerpt_length_word;
	var $excerpt_length_character;
	var $excerpt_more_link_text;
	var $more_link_text;
	var $viewer_type;
	var $is_multi_user;
	var $meta_keyword_type;
	var $meta_description_type;
	var $meta_robot_type;
	var $is_dashboard_blog_disp;
	var $is_dashboard_forum_disp;
	//constructor
	function XPressME_Class()
	{
		global $xoops_db;
		
		$this->setdefault();    //not setting propaty load
		$this->SettingValueRead();
	}
	
	//Set Default Value	
	function setDefault()
	{
		$this->is_use_xoops_upload_path = true;
		$this->is_theme_sidebar_disp = false;
		$this->is_save_post_revision = true;
		$this->is_postnavi_title_disp = true;
		$this->is_left_postnavi_old = true;
		$this->old_post_link_text = __('Older Post', 'xpressme');
		$this->newer_post_link_text = __('Newer Post', 'xpressme');
		$this->is_left_page_navi_old = true;
		$this->old_page_link_text = __('Older Entries', 'xpressme');
		$this->newer_page_link_text = __('Newer Entries', 'xpressme');
		$this->is_author_view_count = false;
		$this->is_sql_debug = false;
		$this->is_use_d3forum = false;
		$this->d3forum_module_dir = '';
		$this->d3forum_forum_id = '';
		$this->d3forum_external_link_format = get_xpress_dir_name() . '::xpressD3commentContent';
		$this->is_d3forum_flat = true;
		$this->is_d3forum_desc = true;
		$this->d3forum_views_num = 10;
		$this->is_content_excerpt = true;
		$this->ascii_judged_rate = 90;
		$this->excerpt_length_word = 40;
		$this->excerpt_length_character = 120;
		$this->excerpt_more_link_text = __('Read the rest of this entry &raquo;', 'xpressme');
		$this->more_link_text = __('Read the rest of this entry &raquo;', 'xpressme');
		$this->viewer_type = 'xoops';
		$this->is_multi_user = false;
		$this->meta_keyword_type = 'xoops';
		$this->meta_description_type = 'xoops';
		$this->meta_robot_type = 'xoops';	
		$this->is_dashboard_blog_disp = true;
		$this->is_dashboard_forum_disp = true;
	}
	
	function SettingValueRead()
	{
		global $xoops_db;
		$options = get_option('xpressme_option');
		if (!$options) {
			$this->setDefault();
			$this->SettingValueWrite('add_new');
		} else {
			foreach ($options as $option_name => $option_value){
	        		$this-> {$option_name} = $option_value;
			}
		}
		if (!empty($xoops_db))	// at install trap
			$this->GroupeRoleRead();
	}
	
		// mode 0:add  1:update	
	function SettingValueWrite($mode)
	{
		$write_options = array (
			'is_use_xoops_upload_path' => $this->is_use_xoops_upload_path ,
			'is_theme_sidebar_disp' => $this->is_theme_sidebar_disp ,
			'is_save_post_revision' => $this->is_save_post_revision ,
			'is_postnavi_title_disp' => $this->is_postnavi_title_disp ,
			'is_left_postnavi_old' => $this->is_left_postnavi_old ,
			'old_post_link_text' => $this->old_post_link_text ,
			'newer_post_link_text' => $this->newer_post_link_text,
			'is_left_page_navi_old' => $this->is_left_page_navi_old ,
			'old_page_link_text' => $this->old_page_link_text ,
			'newer_page_link_text' => $this->newer_page_link_text,
			'is_author_view_count' => $this->is_author_view_count,
			'is_sql_debug' => $this->is_sql_debug,
			'is_use_d3forum' =>	$this->is_use_d3forum,
			'd3forum_module_dir' => $this->d3forum_module_dir,
			'd3forum_forum_id' => $this->d3forum_forum_id,
			'd3forum_external_link_format' => $this->d3forum_external_link_format,
			'is_d3forum_flat' => $this->is_d3forum_flat,
			'is_d3forum_desc' => $this->is_d3forum_desc,
			'd3forum_views_num' =>$this->d3forum_views_num,
			'is_content_excerpt' => $this->is_content_excerpt,
			'ascii_judged_rate' => $this->ascii_judged_rate,
			'excerpt_length_word' => $this->excerpt_length_word,
			'excerpt_length_character' => $this->excerpt_length_character,
			'excerpt_more_link_text' => $this->excerpt_more_link_text,
			'more_link_text' => $this->more_link_text,
			'viewer_type' => $this->viewer_type,
			'is_multi_user' => $this->is_multi_user,
			'meta_keyword_type' => $this->meta_keyword_type,
			'meta_description_type' => $this->meta_description_type,
			'meta_robot_type' => $this->meta_robot_type,
			'is_dashboard_blog_disp' => $this->is_dashboard_blog_disp,
			'is_dashboard_forum_disp' => $this->is_dashboard_forum_disp
		);
		if ($mode == 'add_new') {
			add_option('xpressme_option', $write_options);
		} else {			
			update_option("xpressme_option", $write_options);
		}
	}
	
	function GroupeRoleRead() {
 		global $xoops_db;
		
		// table sync
		$table = get_wp_prefix() . 'group_role';
		$xoops_group = get_xoops_prefix() . 'groups';
		$xoops_group_permission = get_xoops_prefix() . 'group_permission';
		
		$module_id = get_xpress_modid();
		
		$sql=  "SELECT * FROM $table";
		$before_groupes = $xoops_db->get_results($sql);
		
		$sql = "DELETE FROM $table";
		$xoops_db->query($sql);
		
		$sql =  "SELECT *  FROM $xoops_group_permission WHERE gperm_itemid = $module_id";
		$gperms = $xoops_db->get_results($sql);
		
		$sql =  "SELECT * FROM $xoops_group WHERE group_type <> 'Anonymous'";
		$groupes = $xoops_db->get_results($sql);
		$insert_sql = '';
		foreach ($groupes as $groupe) {
			$parmsql =  "SELECT *  FROM $xoops_group_permission WHERE gperm_itemid = $module_id AND gperm_groupid = $groupe->groupid";
			$gperms = $xoops_db->get_results($parmsql);
			$parmission = '';
			foreach ($gperms as $gperm) {
				$parmission = $gperm->gperm_name;
				if ($parmission == 'module_admin') break;
			}
			
			if (!empty($parmission)){
				$role = ''; 
				foreach ($before_groupes as $before_groupe) {
					if ($groupe->groupid == $before_groupe->groupid) {
						$role = $before_groupe->role;
						$login_all = $before_groupe->login_all;
					}
				}
				if ($parmission == 'module_admin') $role = 'administrator';
				
				$insert_sql  = "INSERT INTO  $table ";
				$insert_sql .= "(groupid , name , description , group_type , role , login_all) ";
				$insert_sql .= "VALUES (";
				$insert_sql .= $groupe->groupid . ', ';
				$insert_sql .= "'" . $groupe->name . "' , ";
				$insert_sql .= "'" . $groupe->description . "' , ";
				$insert_sql .= "'" . $parmission . "' , ";
				$insert_sql .= "'" . $role . "' , '";
				$insert_sql .= $login_all . "')";
				$xoops_db->query($insert_sql);
			}
		}
		
		$sql=  "SELECT * FROM $table";
		
		$this->groupe_role =  $xoops_db->get_results($sql);
			$sql=  "SELECT * FROM $table";	
	}
	
	function ReadPostData($post_data = null)
	{
		global $xoops_db;
		
		foreach ( (array) $post_data as $index_key => $value ){
			if (preg_match('/^ch_/',$index_key)){  // case ch_
				$indedx = preg_replace('/^ch_/', '', $index_key);
				$set_value = stripslashes(trim($value));
				// post d3forum
				if ($indedx === 'd3forum') {
					if ($value == 'none'){
						$this->is_use_d3forum = false;
						$this->d3forum_module_dir = '';
						$this->d3forum_forum_id = '';
						$this->d3forum_external_link_format = get_xpress_dir_name() . '::xpressD3commentContent';
					} else {
						$d3f_set = explode('|', $value);
						$this->is_use_d3forum = true;
						$this->d3forum_module_dir = $d3f_set[1];
						$this->d3forum_forum_id = $d3f_set[2];
						$this->d3forum_external_link_format = get_xpress_dir_name() . '::xpressD3commentContent';
					}
				} else { //post other
					if(empty($set_value)){
						switch ($indedx) {
							case 'old_post_link_text':
								$set_value = __('Older Post', 'xpressme');
								break;
							case 'newer_post_link_text':
								$set_value = __('Newer Post', 'xpressme');
								break;
							case 'old_page_link_text':
								$set_value = __('Older Entries', 'xpressme');
								break;
							case 'newer_page_link_text':
								$set_value = __('Newer Entries', 'xpressme');
								break;
							case 'excerpt_more_link_text':
								$set_value = __('Read the rest of this entry &raquo;', 'xpressme');
								break;
								
							default:
						}
					}
					$this->$indedx = $value;
				}
			} // end of case 'ch_'
		} // end of loop

		global $xoops_db;
		$table = get_wp_prefix() . 'group_role';	
//		$sql=  "SELECT * FROM $table";	
//		$this->groupe_role =  $xoops_db->get_results($sql);  // before Read
		
		foreach ($this->groupe_role as $groupe) {
			$post_role_gid = 'role_gid_' . $groupe->groupid;
			$login_all_gid = 'login_all_gid_' . $groupe->groupid;
			if (isset($post_data[$post_role_gid])){
				$role = stripslashes(trim($post_data[$post_role_gid]));
				$login_all = stripslashes(trim($post_data[$login_all_gid]));
				if (empty($login_all)) $login_all = '0';
				$groupe->role = $role;
				$groupe->login_all = $login_all;
				$update_sql  = "UPDATE  $table ";
				$update_sql .= 'SET ';
				$update_sql .= "role  = '$role' , ";
				$update_sql .= "login_all  = $login_all ";
				$update_sql .= "WHERE (groupid = '$groupe->groupid' )";
				$xoops_db->query($update_sql);	
			}		
		}
	}
	
	function yes_no_radio_option($option_name,$option_desc,$yes = '',$no= ''){
		if (empty( $yes ))  $yes = __('YES','xpressme') ;
		if (empty( $no ))  $no = __('NO','xpressme') ;
		$value = $this->{$option_name};
		$ans_name = 'ch_' . $option_name;
		
		$form  =  "<tr>\n";
		$form .=  '<th><label for="images_to_link">' . $option_desc . "</label></th>\n";
		$form .=  "<td>\n";
		$form .=  $this->yes_no_radio_option_sub($option_name,$yes,$no);
		$form .=  "</td>\n";
		$form .=  "</tr>\n";
			
	    return $form;
	
	}
	function yes_no_radio_option_sub($option_name,$yes = '',$no= ''){
		if (empty( $yes ))  $yes = __('YES','xpressme') ;
		if (empty( $no ))  $no = __('NO','xpressme') ;
		$value = $this->{$option_name};
		$ans_name = 'ch_' . $option_name;
		
		if ($value){
			$form .= "<label><input type='radio' name='". $ans_name . "' value='1' checked='checked' />" . $yes ."</label><br />\n";
			$form .= "<label><input type='radio' name='". $ans_name . "' value='0' />". $no . "</label>\n";
		}else{
			$form .= "<label><input type='radio' name='". $ans_name . "' value='1' />" . $yes . "</label><br />\n";
			$form .= "<label><input type='radio' name='". $ans_name . "' value='0' checked='checked' />". $no ."</label>\n";
		}
	    return $form;
	}


	function text_option($option_name,$option_desc){
		$value = $this->{$option_name};
		$ans_name = 'ch_' . $option_name;
		
		$form  =  "<tr>\n";
		$form .=  '<th><label for="images_to_link">' . $option_desc . "</label></th>\n";
		$form .=  "<td>\n";
		$form .= $this->text_option_sub($option_name);
		$form .=  "</td>\n";
		$form .=  "</tr>\n";
			
	    return $form;
	
	}
	
	function text_option_sub($option_name){
		$value = $this->{$option_name};
		$ans_name = 'ch_' . $option_name;
		
		$form = '<label> <input name="'. $ans_name . '" type="text" size="25" maxlength="50" value="'  . $value . '" /></label>'."\n";
	    return $form;
	
	}

	
	function single_post_navi_option(){
		$form = '';
		$form .= '<tr><th><label for="single_page_navi">' .__('Single Post Navi Setting', 'xpressme') . '</label></th>';
		$form .= "<td>\n";
		$form .= "<table>\n";
		$form .= "<tr>\n";
		
		$form .= "<td>" . __('Adjustment of Navi link display position','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->yes_no_radio_option_sub('is_left_postnavi_old',
												__("'Old Post Link' is displayed in the left, and 'Newer Post Link' is displayed in the right",'xpressme'),
												__("'Newer Post Link' is displayed in the left, and 'Old Post Link' is displayed in the right",'xpressme')
												);
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		$form .= "<td>" . __('Select Display name of PostNavi Link','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->yes_no_radio_option_sub('is_postnavi_title_disp',
												__('Title of post','xpressme'),
												__('Title of Navi','xpressme')
												);
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		$form .= "<td>" . __('Display Navi Title of Old Post Link','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->text_option_sub('old_post_link_text');
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		$form .= "<td>" . __('Display Navi Title of Newer Post Link','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->text_option_sub('newer_post_link_text');
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "</table></td></tr>\n";
	    return $form;

	}

	function posts_page_navi_option(){
		$form = '';
		$form .= '<tr><th><label for="posts_page_navi">' .__('Posts List Page Navi Setting', 'xpressme') . '</label></th>';
		$form .= "<td>\n";
		$form .= "<table>\n";
		$form .= "<tr>\n";
		
		$form .= "<td>" . __('Adjustment of Navi link display position','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->yes_no_radio_option_sub('is_left_page_navi_old',
												__("'Old Page Link' is displayed in the left, and 'Newer Page Link' is displayed in the right",'xpressme'),
												__("'Newer Page Link' is displayed in the left, and 'Old Page Link' is displayed in the right",'xpressme')
												);
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		$form .= "<td>" . __('Display Navi Title of Old Page Link','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->text_option_sub('old_page_link_text');
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		$form .= "<td>" . __('Display Navi Title of Newer Page Link','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->text_option_sub('newer_page_link_text');
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "</table></td></tr>\n";
	    return $form;

	}
	
	function dashboard_display_option(){
		$form = '';
		$form .= '<tr><th><label for="posts_page_navi">' .__('Dashboard feed Display Setting', 'xpressme') . '</label></th>';
		$form .= "<td>\n";
		$form .= "<table>\n";
		
		$form .= "<tr>\n";
		
		$form .= "<td>" . __('Display XPressMe Integration Kit Blog','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->yes_no_radio_option_sub('is_dashboard_blog_disp',
												__('YES','xpressme'),
												__('NO','xpressme')
												);
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		
		$form .= "<td>" . __('Display XPressMe Integration Kit Forum','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->yes_no_radio_option_sub('is_dashboard_forum_disp',
												__('YES','xpressme'),
												__('NO','xpressme')
												);
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "</table></td></tr>\n";
	    return $form;
	}

	function groupe_role_option(){
		global $wp_roles , $xoops_db;
		
		$form = '';
		$form .= '<tr><th><label for="role">' .__('Role Setting at Login', 'xpressme') . '</label></th>';
		$form .= '<td>';
		$form .= "<table>\n";
		$form .= '<tr><td>' . __('XOOPS Groupe', 'xpressme') . '</td><td>' . __('WordPress Role', 'xpressme') . '</td><td>' . __('Role is set at each login', 'xpressme') . "</td></tr>\n";
		foreach ($this->groupe_role as $groupe) {
			$form .= "<tr>";
			$form .= "<td> $groupe->name </td>";
			$form .= "<td>\n" . '<select name="role_gid_'.$groupe->groupid . '" id="role_gid_' . $groupe->groupid . '">' . "\n";
			$role_list = '';
			$group_has_role = false;
		
			$select_value = $groupe->role;


				
			foreach($wp_roles->role_names as $role => $name) {
				$name = translate_with_context($name);
				if ( $role == $select_value) {
					$selected = ' selected="selected"';
					$group_has_role = true;
				} else {
					$selected = '';
				}
				if ($groupe->group_type != 'module_admin'|| !empty($selected)) {
					$role_list .= "<option value=\"{$role}\"{$selected}>{$name}</option>\n";
				}
			}
			if ($groupe->group_type != 'module_admin') {
				if ( $group_has_role ) {
					$role_list .= '<option value="default">' . __('Default Role of WordPress', 'xpressme') . "</option>\n";
					$role_list .= '<option value="">' . __('Group User Doesn\'t Register', 'xpressme') . "</option>\n";
				} else {
					if ($select_value == 'default'){
						$role_list .= '<option value="default" selected="selected">' . __('Default Role of WordPress', 'xpressme') . "</option>\n";	
						$role_list .= '<option value="">' . __('Group User Doesn\'t Register', 'xpressme') . "</option>\n";
					} else {
						$role_list .= '<option value="default">' . __('Default Role of WordPress', 'xpressme') . "</option>\n";					
						$role_list .= '<option value="" selected="selected">' . __('Group User Doesn\'t Register', 'xpressme') . "</option>\n";
					}
				}
			}
			$form .= $role_list . "</select>\n</td>";
			if ($groupe->login_all){
				$form .= '<td> <input type="checkbox" name="login_all_gid_' . $groupe->groupid . '" value="1" checked ></td>';
			} else {
				$form .= '<td> <input type="checkbox" name="login_all_gid_' . $groupe->groupid . '" value="1"></td>';
			}
			$form .= "</tr>\n";	
		}
		$form .= "</table></td></tr>\n";
	    return $form;

	}
	
	function d3forum_option($do_message = ''){
		global $xoops_db,$xoops_config;
		
		$d3frum_list = array();
		$module_dir_path = get_xoops_root_path();
		
		$forum_list  = '<select name="ch_d3forum">' . "\n";
		
		if ($this->is_use_d3forum != true)
			$selected = ' selected="selected"';
		else
			$selected = '';
		
		if ($xoops_config->is_wpmu) {
			$forum_list .= '<option value="none"' . $selected . '>' . __('WordPress MU cannot integrate the comments.', 'xpressme') . "</option>\n";
		} else {	
			$forum_list .= '<option value="none"' . $selected . '>' . __('Do Not Comment Integration.', 'xpressme') . "</option>\n";

			// Form making for forum selection of D3forum
			$modules_table = get_xoops_prefix() .'modules';
			$sql = "SELECT mid,name,isactive,dirname FROM $modules_table WHERE isactive = 1";
			$modules = $xoops_db->get_results($sql);
			foreach ($modules as $module) {
				$file_path = $module_dir_path . '/modules/' . $module->dirname . '/mytrustdirname.php';			
				if (! file_exists($file_path)) continue;
				$array_files = file($file_path);
				// It is checked whether there is character string "$mytrustdirname ='d3forum'"in the file.
				foreach ($array_files as $aeey_file){
					if( preg_match( "/\s*(mytrustdirname)\s*(=)\s*([\"'])(d3forum)([\"'])/", $aeey_file ) ) {
						$forums_tb = get_xoops_prefix() . $module->dirname . '_forums';
						$cat_tb = get_xoops_prefix() . $module->dirname . '_categories';
						$sql= "SELECT * FROM $forums_tb LEFT JOIN $cat_tb ON $forums_tb.cat_id = $cat_tb.cat_id";
						$forums = $xoops_db->get_results($sql);
						foreach ($forums as $forum) {
							if (($module->dirname == $this->d3forum_module_dir) &&  ($forum->forum_id == $this->d3forum_forum_id))
								$selected = ' selected="selected"';
							else
								$selected = '';
							$forum_div = 'forum|' . $module->dirname . '|' .  $forum->forum_id;
							$forum_select = "$module->name($module->dirname) $forum->cat_title-$forum->forum_title(ID=$forum->forum_id)";
							$forum_list .= '<option value="' . $forum_div . '" ' . $selected . '>' . $forum_select . "</option>\n";
						}
						break;
					}
				}
				$forum_list .= '<br>';			
			}
		}
		$forum_list .= '</select>' . "\n";

		$form  = '<tr>' . "\n";
		$form .= '<th><label for="d3forum">' .__('Comment integration with D3Forum', 'xpressme') . '</label></th>' . "\n";
		$form .=  "<td>\n";
		$form .=  __('Select the forum of D3Forum that does the comment integration from the following lists.', 'xpressme') ."<br />\n";
		$form .=  $forum_list."\n";
		$form .= '<br /><br />';
		if ($this->is_use_d3forum) {
			if ($this->is_use_d3forum)  $disible = ''; else $disible = 'disabled';
			$form .=  __('Select the Type of display of D3Forum comment.', 'xpressme') . " \n&emsp";
			if ($this->is_d3forum_flat){
				$form .= "&ensp<label><input type='radio' name='ch_is_d3forum_flat' value='1' checked='checked' />" . __('Flat','xpressme') ."</label>\n";
				$form .= "&ensp<label><input type='radio' name='ch_is_d3forum_flat' value='0' />". __('Threaded','xpressme') . "</label>\n";
			}else{
				$form .= "&ensp<label><input type='radio' name='ch_is_d3forum_flat' value='1' />" . __('Flat','xpressme') . "</label>\n";
				$form .= "&ensp<label><input type='radio' name='ch_is_d3forum_flat' value='0' checked='checked' />". __('Threaded','xpressme') ."</label>\n";
			}
			$form .= '<br />';
			$form .=  __('Select the order of display of D3Forum comment.', 'xpressme') . " \n&emsp";
			if ($this->is_d3forum_desc){
				$form .= "&ensp<label><input type='radio' name='ch_is_d3forum_desc' value='1' checked='checked' />" . __('DESC','xpressme') ."</label>\n";
				$form .= "&ensp<label><input type='radio' name='ch_is_d3forum_desc' value='0' />". __('ASC','xpressme') . "</label>\n";
			}else{
				$form .= "&ensp<label><input type='radio' name='ch_is_d3forum_desc' value='1' />" . __('DESC','xpressme') . "</label>\n";
				$form .= "&ensp<label><input type='radio' name='ch_is_d3forum_desc' value='0' checked='checked' />". __('ASC','xpressme') ."</label>\n";
			}
			$form .= '<br />';
			$form .=  __('Number of displays of D3Forum comments.', 'xpressme') ." \n";
			$form .= '&emsp<label> <input name="ch_d3forum_views_num" type="text" size="3" maxlength="3" value="'  . $this->d3forum_views_num . '" /></label>'."\n";
			$form .= '<div class="submit">'."\n";		
			$form .=  __('The import and the export between Wordpress Comments and the D3Forum Posts can be done. ', 'xpressme') ."<br />\n";
			$form .= '<input type="submit" value= "' . __('Export to D3Forum', 'xpressme') . '" name="export_d3f" ' . $disible . ' >' ."\n";
			$form .= '<input type="submit" value= "' . __('Import from D3Forum', 'xpressme') . '" name="inport_d3f" ' . $disible . ' >' ."<br />\n";
			$form .= '</div>'."\n";
			if (!empty($do_message)){
				$form .= '<div>' . $do_message . '</div>';
			}
		}
		$form .=  "</td>\n";
		$form .=  "</tr><tr>\n";
		return $form;
	}
	
	function excerpt_option(){
		$form = '';
		$form .= '<tr><th><label for="excerpt">' .__('Contents Excerpt Setting', 'xpressme') . '</label></th>';
		$form .= "<td>\n";
		$form .= "<table>\n";
		$form .= "<tr>\n";
		
		$form .= "<td>" . __('Is the excerpt display done with the archive of contents?','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->yes_no_radio_option_sub('is_content_excerpt');
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		$form .= "<td>" . __('When ASCII character more than the set ratio is included, it is judged ASCII contents. ','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->text_option_sub('ascii_judged_rate');
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		$form .= "<td>" . __('Excerpt length of word for ASCII contents','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->text_option_sub('excerpt_length_word');
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		$form .= "<td>" . __('Excerpt length of character for multibyte contents','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->text_option_sub('excerpt_length_character');
		$form .= "</td>\n";
		$form .= "</tr>\n";

		$form .= "<tr>\n";
		$form .= "<td>" . __('This text is displayed in the link that reads contents not excerpted.(Is not displayed for the blank.)','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->text_option_sub('excerpt_more_link_text');
		$form .= "</td>\n";
		$form .= "</tr>\n";

		$form .= "<tr>\n";
		$form .= "<td>" . __('This text is displayed in the link that more tag (&lt;!--more--&gt;). ','xpressme') . "</td>\n";		
		$form .= "<td>\n";
		$form .=  $this->text_option_sub('more_link_text');
		$form .= "</td>\n";
		$form .= "</tr>\n";

		$form .= "</table></td></tr>\n";
	    return $form;
	}

	function viewer_type_option(){
		$form  = "<tr>\n";
		$form .= '<th><label for="viewer_type">' .__('Display Mode Setting', 'xpressme') . '</label></th>';
		$form .= "<td>\n";
		
		$form .=  __('Select the XPressME Display Mode.', 'xpressme') ."\n";
		$form .= '<select name="ch_viewer_type">' . "\n";
		
		$form .= '<option value="xoops" ';
		if ($this->viewer_type == 'xoops') $form .= ' selected="selected"';
		$form .= '>'.__('Xoops Mode', 'xpressme') ."</option>\n";

		$form .= '<option value="wordpress" ';
		if ($this->viewer_type == 'wordpress') $form .= ' selected="selected"';
		$form .= '>'.__('WordPress Mode', 'xpressme') ."</option>\n";
		
		$form .= '<option value="user_select" ';
		if ($this->viewer_type == 'user_select') $form .= ' selected="selected"';
		$form .= '>'.__('User select', 'xpressme') ."</option>\n";

		$form .= "</select><br />\n";
		
		$form .= "</td></tr>\n";
	    return $form;
	}
	
	function header_meta_option(){
		$form  = "<tr>\n";
		$form .= '<th><label for="header_type">' .__('Header Meta Option', 'xpressme') . '</label></th>';
		$form .= "<td>\n";
		$form .= "<table>\n";
		$form .= "<tr>\n";
		
		$form .=  "<td>" . __('Select the Header keyword.', 'xpressme')  . "</td>\n";
		$form .= "<td>\n";
		$form .= '<select name="ch_meta_keyword_type">' . "\n";		
		$form .= '<option value="xoops" ';
		if ($this->meta_keyword_type == 'xoops') $form .= ' selected="selected"';
		$form .= '>'.__('Xoops KeyWord', 'xpressme') ."</option>\n";
		$form .= '<option value="wordpress" ';
		if ($this->meta_keyword_type == 'wordpress') $form .= ' selected="selected"';
		$form .= '>'.__('WordPress KeyWord', 'xpressme') ."</option>\n";		
		$form .= '<option value="wordpress_xoops" ';
		if ($this->meta_keyword_type == 'wordpress_xoops') $form .= ' selected="selected"';
		$form .= '>'.__('WordPress & Xoops KeyWord', 'xpressme') ."</option>\n";
		$form .= "</select><br />\n";
		$form .= "</td>\n";
		$form .= "</tr>\n";
		
		$form .= "<tr>\n";
		$form .=  "<td>" . __('Select the Header Description.', 'xpressme') . "</td>\n";
		$form .= "<td>\n";
		$form .= '<select name="ch_meta_description_type">' . "\n";
		$form .= '<option value="xoops" ';
		if ($this->meta_description_type == 'xoops') $form .= ' selected="selected"';
		$form .= '>'.__('Xoops Description', 'xpressme') ."</option>\n";
		$form .= '<option value="wordpress" ';
		if ($this->meta_description_type == 'wordpress') $form .= ' selected="selected"';
		$form .= '>'.__('WordPress Description', 'xpressme') ."</option>\n";
		$form .= '<option value="wordpress_xoops" ';
		if ($this->meta_description_type == 'wordpress_xoops') $form .= ' selected="selected"';
		$form .= '>'.__('WordPress & Xoops Description', 'xpressme') ."</option>\n";
		$form .= "</select><br />\n";
		$form .= "</td>\n";
		$form .= "</tr>\n";

		$form .= "<tr>\n";
		$form .=  "<td>" . __('Select the Header Robots Index.', 'xpressme') . "</td>\n";
		$form .= "<td>\n";
		$form .= '<select name="ch_meta_robot_type">' . "\n";
		$form .= '<option value="xoops" ';
		if ($this->meta_robot_type == 'xoops') $form .= ' selected="selected"';
		$form .= '>'.__('Xoops Robots Index', 'xpressme') ."</option>\n";
		$form .= '<option value="wordpress" ';
		if ($this->meta_robot_type == 'wordpress') $form .= ' selected="selected"';
		$form .= '>'.__('WordPress Robots Index', 'xpressme') ."</option>\n";
		$form .= "</select><br />\n";
		$form .= "</td>\n";
		$form .= "</tr>\n";

		$form .= "</table>\n";
		
		$form .= "</tr>\n";
	    return $form;
	}

	function xpress_upload_filter($uploads)
	{
		global $xoops_config;
		if ($this->is_use_xoops_upload_path){
			$wordpress_dir = ABSPATH ;
			$xoops_dir = $xoops_config->xoops_upload_path . '/';
			$wordpress_base_url = get_option( 'siteurl' );
			$xoops_upload_url = $xoops_config->xoops_upload_url;
			
			@rmdir($uploads[path]);  //remove wordpress side uploads_dir 
			
			$uploads[path] =  str_replace ($wordpress_dir, $xoops_dir, $uploads[path]);
			$uploads[basedir] = str_replace ($wordpress_dir, $xoops_dir, $uploads[basedir]);
			$uploads[url] = str_replace ($wordpress_base_url, $xoops_upload_url, $uploads[url]);
			$uploads[baseurl] = str_replace ($wordpress_base_url, $xoops_upload_url, $uploads[baseurl]);
			
			// Make sure we have an uploads dir
			if ( ! wp_mkdir_p( $uploads[path] ) ) {
				$message = sprintf( __( 'Unable to create directory %s. Is its parent directory writable by the server?' ), $uploads[path] );
				return array( 'error' => $message );
			}
		}
		return $uploads;
	}

	// SQL DEBUG TEST
	function is_sql_debug_permission()
	{
		global $current_user;

		if (!is_object($current_user)) return false;
		if ($this->is_sql_debug && ($current_user->user_level >= 10))
			return true;
		else
			return false;
	}
	
	function xpress_sql_debug($query_strings)
	{
		if ($this->is_sql_debug_permission()){
			if (empty($GLOBALS['XPress_SQL_Query'])) $GLOBALS['XPress_SQL_Query'] = '';
			$GLOBALS['XPress_SQL_Query'] .= $query_strings . '<br /><br />';
		}
		return $query_strings;
	}
	
	function displayDebugLog()
	{
		if ($this->is_sql_debug_permission()){
			$content = '';
			$content .= '<html><head><meta http-equiv="content-type" content="text/html; charset='._CHARSET.'" />';
			$content .= '<meta http-equiv="content-language" content="'._LANGCODE.'" />' ;
			$content .= '<title>XPressME SQL DEBUG</title>' ;
			$content .= '</head><body>';
			$content .= $GLOBALS['XPress_SQL_Query'];
			$content .= '<div style="text-align:center;"><input class="formButton" value="CLOSE" type="button" onclick="javascript:window.close();" /></div></body></html>';

			echo '<script type="text/javascript">
				<!--//
				xpress_debug_window = window.open("", "xpress_debug", "width=680 , height=600 ,toolbar=no,location=no,directories=no,status=no,menubar=no,scrollbars=yes,resizable=yes,copyhistory=no");
				xpress_debug_window.document.clear();
				xpress_debug_window.focus();
				';
			$lines = preg_split("/(\r\n|\r|\n)( *)/", $content);
			foreach ($lines as $line) {
				echo 'xpress_debug_window.document.writeln("'.str_replace('"', '\"', $line).'");';
			}
			echo '
				xpress_debug_window.document.close();
				//-->
			</script>';
		}
	}
}
?>