<?php
if(!defined('XPRESS_BLOCK_RENDER_FUNCTION_READ')){
	define('XPRESS_BLOCK_RENDER_FUNCTION_READ',1);
	require_once dirname( __FILE__ ) .'/xml.php' ;
	require_once dirname( __FILE__ ) .'/xpress_cache.php' ;
	global $xoops_config;
	
	if (!is_object($xoops_config)){ // is call other modules
		require_once dirname(dirname( __FILE__ )) .'/class/config_from_xoops.class.php' ;
		$xoops_config = new ConfigFromXoops;
	}
	
	function xpress_block_cache_write($mydirname,$block_name,$block)
	{
			$xml = xpress_XML_serialize($block);
			$xml_name = $block_name . '.xml';
			if (WPLANG == 'ja_EUC'){
				$xml = str_replace('<?xml version="1.0" ?>', '<?xml version="1.0" encoding="EUC-JP" ?>' , $xml);
			}
			xpress_cache_write($mydirname,$xml_name,$xml);
	}
	function xpress_block_cache_read($mydirname,$block_name)
	{
			$xml_name = $block_name . '.xml';
			$xml_data = xpress_cache_read($mydirname,$xml_name);
			
			$GLOBALS['DO_LIBXML_PATCH'] = get_xpress_mod_config($mydirname,'libxml_patch');
			
			$ret = @xpress_XML_unserialize($xml_data);
			if (strstr($xml_data, '<?xml version="1.0" encoding="EUC-JP" ?>') !== false){
				$ans = mb_convert_variables('EUC-JP' , 'UTF-8', &$ret);
			}
			return $ret;
	}
	
	function get_block_id($mydirname,$func_file,$options)
	{
		$options_string = '';
		foreach ($options as $val){
			if (!empty($options_string)) $options_string .='|';
			$options_string .= $val;
		}
			$xoopsDB =& Database::getInstance();
			$block_tbl = $xoopsDB->prefix('newblocks');	
			$module_dir = XOOPS_ROOT_PATH . '/modules/' . $mydirname;

			$sql = "SELECT bid FROM $block_tbl WHERE (func_file LIKE '$func_file') AND (options LIKE '$options_string')";
			$result =  $xoopsDB->query($sql, 0, 0);
			if ($xoopsDB->getRowsNum($result)  > 0){
				$row = $xoopsDB->fetchArray($result);
				$block_id = $row['bid'];
			}
			return $block_id;
	}

	function get_xpress_theme_name($mydirname)
	{
		global $wpdb;
		
		if (is_null($wpdb)){
			$xoopsDB =& Database::getInstance();
			$wp_prefix = $mydirname;
			if ($wp_prefix == 'wordpress') $wp_prefix = 'wp';

			$module_tbl = $xoopsDB->prefix($wp_prefix).'_options';	
			$theme_name = '';	

			$sql = "SELECT option_value FROM $module_tbl WHERE option_name LIKE 'template'";
			$result =  $xoopsDB->query($sql, 0, 0);
			if ($xoopsDB->getRowsNum($result)  > 0){
				$row = $xoopsDB->fetchArray($result);
				$theme_name = $row['option_value'];
			}
		} else {
			$theme_name = get_option('template');
		}
		return $theme_name;
	}

	function get_block_stylesheet_url($mydirname)
	{
		global $xoops_config;
		$mydirpath = $xoops_config->xoops_root_path . '/modules/' . $mydirname;
		$select_theme = get_xpress_theme_name($mydirname);
		$style_file = $mydirpath . '/wp-content/themes/' . $select_theme . '/blocks/block_style.css';
		if (file_exists($style_file))
			return $xoops_config->xoops_url . '/modules/' .$mydirname . '/wp-content/themes/' . $select_theme . '/blocks/block_style.css';
		else	
			return $xoops_config->xoops_url . '/modules/' .$mydirname . '/wp-content/themes/xpress_default/blocks/block_style.css';
	}
	
	function get_stylesheet_url($mydirname)
	{
		global $xoops_config;
		$mydirpath = $xoops_config->xoops_root_path . '/modules/' . $mydirname;
		$select_theme = get_xpress_theme_name($mydirname);
		$style_file = $mydirpath . '/wp-content/themes/' . $select_theme . '/style.css';
		if (file_exists($style_file))
			return $xoops_config->xoops_url . '/modules/' .$mydirname . '/wp-content/themes/' . $select_theme . '/style.css';
		else	
			return $xoops_config->xoops_url . '/modules/' .$mydirname . '/wp-content/themes/xpress_default/style.css';
	}
	
	function xpress_get_plugin_css($mydirname = '')
	{
		$this_url = '/modules/'. $mydirname;
		$call_url = $_SERVER['REQUEST_URI'];
		if (!strstr($call_url,$this_url)){			
			global $xoops_config;
			
			// Module Main CSS
			$output = "\n".'<style type="text/css">@import url('.get_stylesheet_url($mydirname).');</style>';
			
			// hotDate
			$output .= "\n".'<style type="text/css">@import url('.$xoops_config->module_url.'/wp-content/plugins/hotDates/hotDates.css);</style>';
			return $output;	
		} 
		return '';
	}

	function xpress_block_css_set($mydirname = '')
	{
		$style_url =  get_block_stylesheet_url($mydirname);
		
		$tplVars =& $GLOBALS['xoopsTpl']->get_template_vars();
		$csslink = "\n".'<link rel="stylesheet" type="text/css" media="screen" href="'. $style_url .'" />';
		// Module Main CSS Plugin Css
		$csslink .= xpress_get_plugin_css($mydirname);

			if(array_key_exists('xoops_block_header', $tplVars)) {
				if (!strstr($tplVars['xoops_block_header'],$csslink)) {
					$GLOBALS['xoopsTpl']->assign('xoops_block_header',$tplVars['xoops_block_header'].$csslink);
				}
			} else {
				$GLOBALS['xoopsTpl']->assign('xoops_block_header',$csslink);
			}
	}
	
	function get_block_file_path($mydirname,$file_name)
	{
		global $xoops_config;
		$mydirpath = $xoops_config->xoops_root_path . '/modules/' . $mydirname;
		$select_theme = get_xpress_theme_name($mydirname);
		$block_file = $mydirpath . '/wp-content/themes/' . $select_theme . '/blocks/' . $file_name;

		if (!file_exists($block_file))
			$block_file =  $xoops_config->xoops_root_path . '/modules/' .$mydirname . '/wp-content/themes/xpress_default/blocks/' . $file_name;
		return $block_file;
	}
	
    function xpress_block_cache_found($mydirname,$block_name)
    {
    	global $xoops_config;
    	if(defined('XOOPS_ROOT_PATH')){
    		$cache_dir = XOOPS_ROOT_PATH . '/cache/';
    	} else {
    		$cache_dir = $xoops_config->xoops_root_path . '/cache/';
    	}
    	$xml_name = $block_name . '.xml';

        $filename = $cache_dir .$mydirname . '_' . $xml_name;
		$cache_time = 0;
//        if (file_exists($filename) && ((time() - filemtime($filename)) < $cache_time)) {
        if (file_exists($filename)) {
            return true;
       } else {
			return false;
		}
    } 
	
	function xpress_block_render($mydirname,$block_function_name,$options)
	{
		global $wpdb;
		$func_file = $block_function_name;
		$call_theme_function_name = str_replace(".php", "", $block_function_name);
		$inc_theme_file_name = $call_theme_function_name . '_theme.php';
		$cache_title = str_replace(".php", "", $block_function_name);
		$blockID =get_block_id($mydirname,$func_file,$options);		

		$this_url = '/modules/'. $mydirname;
		$call_url = $_SERVER['REQUEST_URI'];
		
		xpress_block_css_set($mydirname);
		if (strstr($call_url,$this_url)){			
			$block_theme_file = get_block_file_path($mydirname,$inc_theme_file_name);
			require_once $block_theme_file;
			$block = $call_theme_function_name($options);		//The block name and the called function name should be assumed to be the same name. 
		} else {
			if (xpress_block_cache_found($mydirname,$cache_title. $blockID)){
				$xml = xpress_block_cache_read($mydirname,$cache_title. $blockID);
				$block = $xml['block'];
			} else {
				$block['err_message'] = sprintf(_MB_XP2_BLOCK_CACHE_ERR, '<a href="' . XOOPS_URL . '/modules/' . $mydirname . '">' . $mydirname .'</a>');
			}
		}

		$templates_file = 'db:'.$mydirname. '_' . str_replace(".php", ".html", $block_function_name);
		$tpl =& new XoopsTpl() ;
		$tpl->assign( 'block' , $block ) ;
		$ret['content'] = $tpl->fetch( $templates_file ) ;
		return $ret ;
	}
	
	function xpress_block_cache_refresh($mydirname)
	{
		global $xoops_db;
		$mid = get_xpress_modid();
		$sql = "SELECT bid,options,func_file FROM " . get_xoops_prefix() . "newblocks WHERE mid = $mid AND visible = 1";
		$blocks = $xoops_db->get_results($sql);
		require_once get_xpress_dir_path() . '/include/xpress_block_render.php';

		foreach($blocks as $block){
			$func_file = $block->func_file;
			$call_theme_function_name = str_replace(".php", "", $func_file);
			$inc_theme_file_name = str_replace(".php", "", $func_file) . '_theme.php';
			$cache_title = str_replace(".php", "", $func_file);
			$blockID = $block->bid;
			$options = explode("|", $block->options);

			$block_theme_file = get_block_file_path($mydirname,$inc_theme_file_name);
			require_once $block_theme_file;
			$render = $call_theme_function_name($options);		//The block name and the called function name should be assumed to be the same name. 			
			$render_array['block'] = $render;
			$render_array['block']['options'] = $block->options;
			if (xpress_block_cache_found($mydirname,$cache_title. $blockID)){	
				$render_serialize = xpress_XML_serialize($render_array);
				$render_md5 = md5($render_serialize);

				$cache_serialize = xpress_cache_read($mydirname,$cache_title. $blockID.'.xml');
				$cache_md5 = md5($cache_serialize);
				
				if ($render_md5 != $cache_md5){
					xpress_block_cache_write($mydirname,$cache_title. $blockID, $render_array);
				}
			} else {
				xpress_block_cache_write($mydirname,$cache_title. $blockID, $render_array);
			}
		}
	}
	
	function xpress_unnecessary_block_cache_delete($mydirname)
	{
		global $xoops_db,$xoops_config;
		$mid = get_xpress_modid();
		$sql = "SELECT bid,options,func_file FROM " . get_xoops_prefix() . "newblocks WHERE mid = $mid AND visible = 1";
		$blocks = $xoops_db->get_results($sql);
		require_once get_xpress_dir_path() . '/include/xpress_block_render.php';

		$pattern ='';
		foreach($blocks as $block){
			$cache_file_name = $mydirname . '_'. str_replace(".php", "", $block->func_file) . $block->bid;
			if (!empty($pattern))  $pattern .= '|';
			$pattern .= $cache_file_name;
		}
		$pattern = '(' . $pattern . ')';
		
		$cache_dir = $xoops_config->xoops_root_path . '/cache/';
		$cache_time = 0;
        if ($dh = opendir($cache_dir)) {
            while (($file = readdir($dh)) !== false) {
                if (preg_match('/^' . preg_quote($mydirname) . '/', $file)) {
                	if(! preg_match('/' . $pattern . '/', $file)) {
                    	unlink($cache_dir.$file);
                    }
                } 
            } 
            closedir($dh);
        } 
    } 
    
    function get_xpress_mod_config($mydirname,$conf_name=''){
		$module_handler =& xoops_gethandler('module');
		$xoopsModule =& $module_handler->getByDirname($mydirname);
		$mid = $xoopsModule->getVar('mid');
		$xoopsDB =& Database::getInstance();
		$db_config = $xoopsDB->prefix('config');
	    
		$wu_sql  = 	"SELECT conf_value FROM  $db_config ";
		$wu_sql .=	"WHERE (conf_modid = $mid ) AND (conf_name LIKE '$conf_name')";
		$wu_res = $xoopsDB->queryF($wu_sql, 0, 0);
			
		if ($wu_res === false){
			return 0;
		} else {
			$xu_row = $xoopsDB->fetchArray($wu_res);
			return $xu_row['conf_value'];
		}
	}

}	
?>