<?php
/*
 * Plugin Name: XPressME MENU
 * Version: 1.0
 * Plugin URI: http://jessealtman.com/2009/06/08/tutorial-wordpress-28-widget-api/
 * Description: XPressME MENU widget using the the WordPress 2.8 widget API. This is meant strictly as a means of showing the new API using the <a href="http://jessealtman.com/2009/06/08/tutorial-wordpress-28-widget-api/">tutorial</a>.
 * Author: toemon
 * Author URI: http://ja.xpressme.info
 */
class XPress_Menu_Widget extends WP_Widget
{
	/**
	* Declares the XPress_Menu_Widget class.
	*
	*/
	function XPress_Menu_Widget(){
		$widget_ops = array('classname' => 'widget_xpress', 'description' => __( "XPressME User Menu Widget") );
		$control_ops = array('width' => 400, 'height' => 300);
		$this->WP_Widget('XPress_Menu', __('XPressME MENU'), $widget_ops, $control_ops);
	}

	/**
	* Displays the Widget
	*
	*/
	function widget($args, $instance){
		global $xpress_config,$xoops_config;

		extract($args);
		$title = apply_filters('widget_title', empty($instance['title']) ? '&nbsp;' : $instance['title']);

		# Before the widget
		echo $before_widget;

		# The title
		if ( $title )
		echo $before_title . $title . $after_title;

		# Make the XPressME MENU widget
		echo '<ul>';
		for($i = 0; $i < 10; $i++) {
			$link_name = $instance['name' . $i];
			$link_url = $instance['link' . $i];
			if (!empty($link_name))	echo '<li><a href="' . $link_url . '">' . $link_name . '</a></li>';
		}
		echo '</ul>';
		# After the widget
		echo $after_widget;
	}

	/**
	* Saves the widgets settings.
	*
	*/
	function update($new_instance, $old_instance){
		$instance = $old_instance;
		$instance['title'] = strip_tags(stripslashes($new_instance['title']));
		
		for($i = 0; $i < 10; $i++) {
			$instance['name'. $i] = strip_tags(stripslashes($new_instance['name'. $i]));
			$instance['link' . $i] = strip_tags(stripslashes($new_instance['link'. $i]));
		}

		return $instance;
	}

	/**
	* Creates the edit form for the widget.
	*
	*/
	function form($instance){
		global $xpress_config,$xoops_config;
		//Defaults
		$instance = wp_parse_args( (array) $instance, 
		array(
			'title'=> __('User Menu'),
			'name0' => __('Site Home'),
			'link0' => $xoops_config->xoops_url,
			'name1' => '',
			'link1' => '',
			'name2' => '',
			'link2' => '',
			'name3' => '',
			'link3' => '',
			'name4' => '',
			'link4' => '',
			'name5' => '',
			'link5' => '',
			'name6' => '',
			'link6' => '',
			'name7' => '',
			'link7' => '',
			'name8' => '',
			'link8' => '',
			'name9' => '',
			'link9' => ''
		) );

		$title = htmlspecialchars($instance['title']);

		// Output the options
		echo '<p><label for="' . $this->get_field_name('title') . '">'. "\n";
		echo __('Title:') . '<input style="width: 200px;" id="' . $this->get_field_id('title') . '" name="' . $this->get_field_name('title') . '" type="text" value="' . $title . '" /></label></p>'. "\n";
		echo '<label>' . __('Title') . '</label>' . '<label style="margin-left:120px;">' . __('URL') . '</label>' . "\n";
		for($i = 0; $i < 10; $i++) {
		echo '<p><input style="width: 100px;" id="' . $this->get_field_id('name' . $i) . '" name="' . $this->get_field_name('name' . $i) . '" type="text" value="' . $instance['name'. $i] . '" />:'. "\n";
		echo '<input style="width: 280px;" id="' . $this->get_field_id('link' . $i) . '" name="' . $this->get_field_name('link' . $i) . '" type="text" value="' . $instance['link'. $i] . '" /></p>'. "\n";
		}
	}

}// END class

/**
* Register Hello World widget.
*
* Calls 'widgets_init' action after the Hello World widget has been registered.
*/
function XPress_MenuInit() {
	register_widget('XPress_Menu_Widget');
}
add_action('widgets_init', 'XPress_MenuInit');
?>
