<?php
/**
 * XPressME - WordPress for XOOPS
 *
 * Adding multi-author features to XPress
 *
 * @copyright	toemon
 * @license		GNU public license
 * @author		"toemon ( http://www.toemon.com)"
 * @package		module::xpressme
 */
 
if( ! defined( 'XOOPS_ROOT_PATH' ) ) exit ;

$mydirpath = dirname(__FILE__);
$mydirname = basename($mydirpath);

$lang = @$GLOBALS["xoopsConfig"]['language'];

// language file (modinfo.php)

if( file_exists( $mydirpath .'/language/'.$lang.'/modinfo.php' ) ) {
	include_once $mydirpath .'/language/'.$lang.'/modinfo.php' ;
} else if( file_exists(  $mydirpath .'/language/english/modinfo.php' ) ) {
	include_once $mydirpath .'/language/english/modinfo.php' ;
}
global $wp_db_version,$wp_version;

include $mydirpath .'/wp-includes/version.php' ;

$modversion['name'] = ucfirst($mydirname) . ' ' . constant('_MI_XPRESS_NAME') ;
$modversion['description'] = constant( '_MI_XPRESS_DESC');
$modversion['version'] = "0.02";
$modversion['credits'] = "Wordpress DEV (http://wordpress.org/) XPressME DEV Toemon) (http://www.toemon.com) ;";
$modversion['author'] = "toemon (http://www.toemon.com)";
$modversion['license'] = "GPL see LICENSE";
$modversion['official'] = 0 ;
$modversion['image'] =  'module_icon.php' ;
$modversion['dirname'] = $mydirname;

// status
$modversion['codename'] = "r48";

// onInstall, onUpdate, onUninstall
$modversion['onInstall'] = 'include/oninstall.php' ;
$modversion['onUpdate'] = 'include/onupdate.php' ;
$modversion['onUninstall'] = 'include/onuninstall.php' ;

// Sql file (must contain sql generated by phpMyAdmin or phpPgAdmin)
//$modversion['sqlfile']['mysql'] = "sql/mysql.sql";

$db_prefix = $mydirname;
if ($mydirname == 'wordpress') {
	$db_prefix = 'wp';
}
	$modversion['tables'] = array(
	$db_prefix . "_comments",
	$db_prefix . "_links",
	$db_prefix . "_options",
	$db_prefix . "_postmeta",
	$db_prefix . "_posts",
	$db_prefix . "_users",
	$db_prefix . "_usermeta",
	$db_prefix . "_terms",
	$db_prefix . "_term_relationships",
	$db_prefix . "_term_taxonomy",
	$db_prefix . "_views",	
	$db_prefix . "_d3forum_link"
	);


// Search
$modversion['hasSearch'] = 1 ;
$modversion['search']['file'] = 'include/search.php' ;
$modversion['search']['func'] = $mydirname.'_global_search' ;
//Admin things
$modversion['hasAdmin'] = 0;
//$modversion['adminindex'] = "admin/index.php";
//$modversion['adminmenu'] = "admin/menu.php";

$modversion['hasMain'] = 1;
if(is_object($GLOBALS["xoopsUser"])){
	$modversion['sub'][1]['name'] = constant( '_MI_XPRESS_MENU_POST_NEW');
	$modversion['sub'][1]['url'] = "wp-admin/post-new.php";
	$modversion['sub'][2]['name'] = constant( '_MI_XPRESS_MENU_EDIT');
	$modversion['sub'][2]['url'] = "wp-admin/edit.php";
}

// Use smarty
//$modversion["use_smarty"] = 1;

/**
* Templates
*/
// All Templates can't be touched by modulesadmin.
$modversion['templates'] = array() ;

$modversion['hasconfig'] = 0;

//BLOCKS
$modversion['blocks'][1] = array(
	'file' 			=> 'recent_comments_block.php' ,
	'name' 			=> constant('_MI_XPRESS_BLOCK_COMMENTS') ,
	'description'	=> '' ,
	'show_func' 	=> "b_". $mydirname . "_comments_show" ,
	'edit_func' 	=> "b_". $mydirname . "_comments_edit" ,
	'template'		=> 'recent_comments_block.html' , 
	'options'		=> $mydirname. '|10|30|0|' ,
	'can_clone'		=> true ,
	'func_num'		=> 1,	
);
$modversion['blocks'][2] = array(
	'file' 			=> 'recent_posts_content_block.php' ,
	'name' 			=> constant('_MI_XPRESS_BLOCK_CONTENT') ,
	'description'	=> '' ,
	'show_func' 	=> "b_". $mydirname . "_content_show" ,
	'edit_func' 	=> "b_". $mydirname . "_content_edit" ,
	'template'		=> 'recent_posts_content_block.html' , 
	'options'		=> $mydirname. '|10|0|100||0' ,
	'can_clone'		=> true ,
	'func_num'		=> 2,
);
?>