<?php
	
function xpress_credit($show = false)
{
	global $xoopsModule,$wp_version;
	
	$ret = '<a href="http://www.toemon.com"'. " target='_blank'" . '>XPressME Ver.' . sprintf('%.2f %s',$xoopsModule->getInfo('version'),$xoopsModule->getInfo('codename')) .'</a>';
	if (strstr($wp_version,'ME')){
		$ret .= '(included <a href="http://wpme.sourceforge.jp/" title="Powered by WordPress"'." target='_blank'". '>WordPress ' . $wp_version . '</a>)';
	} else {
		$ret .= '(included <a href="http://ja.wordpress.org/" title="Powered by WordPress"'." target='_blank'". '>WordPress ' . $wp_version . '</a>)';
	}

	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_convert_time($show = false)
{
	$ret =  timer_stop(0) .'sec. ';
	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_is_theme_sidebar_disp(){
	$config = new XPressME_Class();
	return $config->is_theme_sidebar_disp;
}	

function xpress_left_arrow_post_link($show = false)
{
	$config = new XPressME_Class();
	$ret = '';
		
	if($config->is_left_postnavi_old){
		$link_title = $config->old_post_link_text;
		ob_start();
		if ($config->is_postnavi_title_disp)
			previous_post_link('&laquo; %link');
		else 
			previous_post_link('&laquo; %link',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
	} else {
		$link_title = $config->newer_post_link_text;
		ob_start();
		if ($config->is_postnavi_title_disp)
			next_post_link('&laquo; %link');
		else
			next_post_link('&laquo; %link',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
	}
	
	if ($config->is_postnavi_title_disp){
		$on_mouse_show = $link_title;
	} else  {
		if($config->is_left_postnavi_old){
			ob_start();
				previous_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		} else {
			ob_start();
				next_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		}
		$pattern = "<a[^>]*?>(.*)<\/a>";
		preg_match("/".$pattern."/s",  $on_mouse_show, $body_matches);
		$on_mouse_show = $body_matches[1];
	}
	$ret = str_replace('">','" title="'.$on_mouse_show . '">' , $ret);

	if (empty($show))
		return $ret;
	else
		echo $ret;
}

function xpress_right_arrow_post_link($show = false)
{
	$config = new XPressME_Class();
	$ret = '';		
	
	if($config->is_left_postnavi_old){
		$link_title = $config->newer_post_link_text;
		ob_start();
		if ($config->is_postnavi_title_disp)
			next_post_link('%link &raquo;');
		else
			next_post_link('%link &raquo;',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
	} else {
		$link_title = $config->old_post_link_text;
		ob_start();
		if ($config->is_postnavi_title_disp)
			previous_post_link('%link &raquo;');
		else 
			previous_post_link('%link &raquo;',$link_title);
		$ret = ob_get_contents();
		ob_end_clean();
	}
	
	if ($config->is_postnavi_title_disp){
		$on_mouse_show = $link_title;
	} else  {
		if($config->is_left_postnavi_old){
			ob_start();
				next_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		} else {
			ob_start();
				previous_post_link('%link');
				$on_mouse_show = ob_get_contents();
			ob_end_clean();
		}
		$pattern = "<a[^>]*?>(.*)<\/a>";
		preg_match("/".$pattern."/s",  $on_mouse_show, $body_matches);
		$on_mouse_show = $body_matches[1];
	}
	$ret = str_replace('">','" title="'.$on_mouse_show . '">' , $ret);

	if (empty($show))
		return $ret;
	else
		echo $ret;	
}

function xpress_is_author_view_count(){
	$config = new XPressME_Class();
	return $config->is_author_view_count;
}

function xpress_substr($str, $start, $length, $trimmarker = '...')
{
    if (function_exists('mb_substr')){
        $str2 = mb_substr( $str , $start , $length);
        return $str2 . ( mb_strlen($str)!=mb_strlen($str2) ? $trimmarker : '' );
    } else {
        return ( strlen($str) - $start <= $length ) ? substr( $str, $start, $length ) : substr( $str, $start, $length - strlen($trimmarker) ) . $trimmarker;
    }
}
// xoops db
function get_xpress_dir_path()
{
	return ABSPATH;
}

function get_xpress_dir_name()
{
	return basename(ABSPATH);
}

function get_wp_prefix_only()
{
	$dir_name = get_xpress_dir_name();
	$prefix = $dir_name;
	if ($prefix == 'wordpress') $prefix = 'wp';
	
	$prefix = $prefix . '_';
	return $prefix;
}

function get_xoops_prefix()
{
	global $wpdb;
	
	$prefix = $wpdb->prefix;
	$ret = str_replace(get_wp_prefix_only(),'',$prefix);
	return $ret;
}

function get_xpress_modid()
{
	global $xoops_db;
	
	$modulename = get_xpress_dir_name();	
	$sql = "SELECT mid FROM " . get_xoops_prefix() . "modules WHERE dirname = '$modulename'";
	$mid = $xoops_db->get_var($sql);
	return $mid;	
}

function block_cache_refresh()
{
	global $xoops_db;
	$mid = get_xpress_modid();
	$sql = "SELECT bid,options,func_file FROM " . get_xoops_prefix() . "newblocks WHERE mid = $mid";
	$blocks = $xoops_db->get_results($sql);
	$mydirname = get_xpress_dir_name();
	require_once get_xpress_dir_path() . '/include/xpress_block_render.php';


	foreach($blocks as $block){
		$func_file = $block->func_file;
		$call_theme_function_name = str_replace(".php", "", $func_file);
		$inc_theme_file_name = str_replace(".php", "", $func_file) . '_theme.php';
		$cache_title = str_replace(".php", "", $func_file);
		$blockID = $block->bid;
		$options = explode("|", $block->options);
					
		$block_theme_file = get_block_file_path($mydirname,$inc_theme_file_name);
		require_once $block_theme_file;
		$block_render = $call_theme_function_name($options);		//The block name and the called function name should be assumed to be the same name. 			
		$xml['block'] = $block_render;
		xpress_block_cache_write($mydirname,$cache_title. $blockID, $xml);
	}
}

// views count
// Set and retrieves post views given a post ID or post object. 
// Retrieves post views given a post ID or post object. 
function xpress_post_views_count($post_id=0,$format= '',$show = true) {
	global $xoops_db;

	static $post_cache_views;

	if ( empty($post_id) ) {
		if ( isset($GLOBALS['post']) )
			$post_id = $GLOBALS['post']->ID;
	}

	$post_id = intval($post_id);
	if($post_id==0) return null;
	if(!isset($post_cache_views[$post_id])){
        $sql = "SELECT post_views FROM " . get_xoops_prefix() . "views" . " WHERE post_id=$post_id";
        $post_views = $xoops_db->get_var($sql);
        if (!$post_views) {
	        $post_cache_views[$post_id] = 0;
        }else{
	        $post_cache_views[$post_id] = $post_views;
        }
	}
	$v_count = intval($post_cache_views[$post_id]);
	
	if (empty($format)) $format = __('views :%d','xpressme');
	
	$ret = sprintf($format,$v_count);

	if ($show) echo $ret; else return $ret;
}

function set_post_views_count(&$content) {
	if ( empty($_GET["feed"]) &&  empty($GLOBALS["feed"]) && empty($GLOBALS["doing_trackback"]) && empty($GLOBALS["doing_rss"]) && empty($_POST) && is_single() ){
		post_views_counting();
	}
	return $content;
}

// Set post views given a post ID or post object. 
function post_views_counting($post_id = 0) {
	global $table_prefix;
	static $views;
	
	$post_id = intval($post_id);
	if ( empty($post_id) && isset($GLOBALS['post']) ){
		$post_id = $GLOBALS['post']->ID;
	}


	$views_db = $table_prefix . "views";

	if($post_id==0 || !empty($views[$post_id])) return null;
	
	if(!xpress_is_author_view_count()){
		$current_user_id = $GLOBALS['current_user']->ID;
		$post_author_id = $GLOBALS['post']->post_author;
		if ($current_user_id ==$post_author_id) return null;
	}

    $sql = "SELECT post_views FROM " . $views_db . " WHERE post_id=$post_id";
    $exist = false;
    if ($result = $GLOBALS["xoopsDB"]->query($sql)) {
        while($row = $GLOBALS["xoopsDB"]->fetchArray($result)){
        	$exist = true;
	        break;
    	}
	}
	if($exist){
        $sql = "UPDATE " . $views_db . " SET post_views=post_views+1 WHERE post_id=$post_id";
    }else{
        $sql = "INSERT INTO " . $views_db . " (post_id, post_views) VALUES ($post_id, 1)";
    }
    if ($result = $GLOBALS["xoopsDB"]->queryF($sql)) {
    	$views[$post_id] = 1;
    }
    
	return true;
}


?>