<?php
/**
 * XPress - WordPress for XOOPS
 *
 * Adding multi-author features to XPressME
 *
 * @copyright	The XPressME project
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @since		2.05
 * @version		$Id$
 * @package		module::xpress
 */

// ***********************************  Start Pluggable Function Edit (wp-include/pluggable.php) ************************************

if ( !function_exists('get_currentuserinfo') ) :
function get_currentuserinfo() {
	global $current_user;

	if (is_root_index_page_call()){
		if ( defined('XMLRPC_REQUEST') && XMLRPC_REQUEST )
			return false;

		if ( ! empty($current_user) )
			return;

		if (check_xpress_auth_cookie()){
			if ( $user = wp_validate_auth_cookie() ) {
				wp_set_current_user($user);
				return ;
			}
		}				
		xpress_login();		
	}else {
		// WP2.7 original
		if ( defined('XMLRPC_REQUEST') && XMLRPC_REQUEST )
			return false;

		if ( ! empty($current_user) )
			return;

		if ( ! $user = wp_validate_auth_cookie() ) {
			 if ( empty($_COOKIE[LOGGED_IN_COOKIE]) || !$user = wp_validate_auth_cookie($_COOKIE[LOGGED_IN_COOKIE], 'logged_in') ) {
			 	wp_set_current_user(0);
			 	return false;
			 }
		}

		wp_set_current_user($user);
	}
}
endif;

function xpress_login(){
	global $current_user;
	
			if(is_object($GLOBALS["xoopsUser"])){
				$u_name = $GLOBALS["xoopsUser"]->getVar("uname");
				$u_pass_md5 = $GLOBALS["xoopsUser"]->getVar("pass");		
				if ( ! empty($u_name) && ! empty($u_pass_md5) ) {		
//					include_once dirname( __FILE__ ).'/xpress_user.php';
//					$mess = xpress_user_sync($GLOBALS["xoopsUser"]->getVar("uid"));
//					if ($mess != 'NOT XPRESS USER'){
						$user = new WP_User(0, $u_name);
						if ( wp_login($u_name, $u_pass_md5, true) ) {
							wp_setcookie($u_name, $u_pass_md5, true, '', '', false);
							do_action('wp_login', $u_name);
							wp_set_current_user($user->ID);
							return  true;
						}
//					}
				}
			}
		wp_set_current_user(0);
		return 0;	
}

function check_xpress_auth_cookie() {		// for wp2.5
	if ( empty($_COOKIE[AUTH_COOKIE]) ){
		return false;
	}
	$cookie = $_COOKIE[AUTH_COOKIE];

	$cookie_elements = explode('|', $cookie);
	if ( count($cookie_elements) != 3 ){
			return false;
	}
					
	if(is_object($GLOBALS["xoopsModule"]) && WP_BLOG_DIRNAME == $GLOBALS["xoopsModule"]->getVar("dirname")){
		if(is_object($GLOBALS["xoopsUser"])){
			$u_name = $GLOBALS["xoopsUser"]->getVar("uname");
			list($username, $expiration, $hmac) = $cookie_elements;
			if ($u_name == $username) {
				return true;
			}
		}
	} else {
		$mydirname = basename( dirname( dirname( __FILE__ ) ) ) ;
		$org_url = $_SERVER['REQUEST_URI'];
		$needle = '/modules/' . $mydirname . '/wp-admin/';
		if (strstr($org_url , $needle)){
			return true;				
		}
	}
	return false;
}


/*

function wp_login($username, $password, $already_md5 = false) {
	global $wpdb, $error;

	$username = sanitize_user($username);

	if ( '' == $username )
		return false;

	if ( '' == $password ) {
		$error = __('<strong>ERROR</strong>: The password field is empty.');
		return false;
	}

	$login = get_userdatabylogin($username);
	//$login = $wpdb->get_row("SELECT ID, user_login, user_pass FROM $wpdb->users WHERE user_login = '$username'");

	if (!$login) {
		$error = __('<strong>ERROR</strong>: Invalid username.');
		return false;
	} else {
		if ($login->user_login == $username) {
				if ($login->user_pass == $password) return true;
				if ($login->user_pass == md5($password)) return true;
		}

		$error = __('<strong>ERROR</strong>: Incorrect password.');
		$pwd = '';
		return false;
	}
}
*/

// for wordpress2.5
function wp_check_password($password, $hash, $user_id = '') {
	global $wp_hasher;

	// If the hash is still md5...
	if ( strlen($hash) <= 32 ) {
		if (( $hash == md5($password)) || ($hash == $password)) {  // The password taken out of XOOPS is hash value.
			$check = true;
		} else {
			$check = false;
		}

/* A new hash is not used because it differs from the hash on the XOOPS password. 
 *		if ( $check && $user_id ) {
 *			// Rehash using new hash.
 *			wp_set_password($password, $user_id);
 *			$hash = wp_hash_password($password);
 *		}
 */
		return apply_filters('check_password', $check, $password, $hash, $user_id);
	}

	// If the stored hash is longer than an MD5, presume the
	// new style phpass portable hash.
	if ( empty($wp_hasher) ) {
		require_once( ABSPATH . 'wp-includes/class-phpass.php');
		// By default, use the portable hash from phpass
		$wp_hasher = new PasswordHash(8, TRUE);
	}

	$check = $wp_hasher->CheckPassword($password, $hash);

	return apply_filters('check_password', $check, $password, $hash, $user_id);
}


/*

function wp_mail($to, $subject, $message, $from_email="", $from_name="") {
    $xoopsMailer =& getMailer();
    $xoopsMailer->useMail();
    $xoopsMailer->setToEmails($to);
    $xoopsMailer->setFromEmail( empty($from_email) ? $GLOBALS["xoopsConfig"]['adminmail'] : $from_email);
    $xoopsMailer->setFromName( empty($from_name) ? $GLOBALS["xoopsConfig"]['sitename'] : $from_name );
    $xoopsMailer->setSubject($subject);
    $xoopsMailer->setBody($message);
    return $xoopsMailer->send();
}

*/
/*
function auth_redirect($force = false, $message = "") {
	if(!is_object($GLOBALS["xoopsUser"])){
		header('Expires: Wed, 11 Jan 1984 05:00:00 GMT');
		header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
		header('Cache-Control: no-cache, must-revalidate, max-age=0');
		header('Pragma: no-cache');
	
		header('Location: ' . get_settings('siteurl') . '/wp-login.php?redirect_to=' . urlencode($_SERVER['REQUEST_URI']));
		exit();
	}elseif(!empty($force)){
		$redirect = xoops_getenv("HTTP_REFERER");
		$redirect = (strpos($redirect, XOOPS_URL) === 0)? $redirect: XOOPS_URL."/".$redirect;
		redirect_header($redirect, 2, $message);
	}
}
*/
// ***********************************  End Of Pluggable Function Edit (wp-include/pluggable.php) ************************************

?>