<?php
/*
 * XPressME - WordPress for XOOPS
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @package		module::xpress
 */

/* 
 *	The module loads the XOOPS system only at the time of reading to route index.php. 
 *
 *	When "Media up-loading" is executed, WordPress calls the SWFUpload script. 
 *	After completing up-loading
 *	The SWFUpload script executes wp-admin/async-upload.php. 
 *	At this time, session ID is not succeeded to. 
 *	And, admin/async-upload.php becomes an access inhibit when wordpress is under the management of XOOPS. 
 */

function is_xpress_index_page_call(){
	$xpress_root_index = basename(dirname(dirname( __FILE__ ))) . '/index.php';
	$php_script_name = $_SERVER['SCRIPT_NAME'];
	$php_query_string = $_SERVER['QUERY_STRING'];
	if (strstr($php_script_name,$xpress_root_index) !== false) {
		if (strstr($php_query_string,'preview') === false) return true; else return false;;
	} else  {
		return false;
	}
}

function is_admin_page_call(){
	$xpress_root_index = basename(dirname(dirname( __FILE__ ))) . '/wp-admin';
	$php_script_name = $_SERVER['SCRIPT_NAME'];
	if (strstr($php_script_name,$xpress_root_index) !== false) return true; else  return false;
}

function is_media_upload_page_call(){
	$xpress_root_indexs[0] = basename(dirname(dirname( __FILE__ ))) . '/wp-admin/async-upload.php';
	$php_script_name = $_SERVER['SCRIPT_NAME'];
	foreach ($xpress_root_indexs as $xpress_root_index) {
		if (strstr($php_script_name,$xpress_root_index) !== false) return true;
	}
	return false;
}

if (is_media_upload_page_call() ){
	if ( !defined("XOOPS_ROOT_PATH") ) {
		//Module process will not load any XOOPS Cube classes.
		define('_LEGACY_PREVENT_EXEC_COMMON_', 1);		// for XCL
		$xoopsOption['nocommon'] = 1;					// for XOOPS
		include_once dirname( __FILE__ ).'/../../../mainfile.php';
	}
	if (!defined("XOOPS_UPLOAD_PATH"))
		define("XOOPS_UPLOAD_PATH", XOOPS_ROOT_PATH."/uploads");
	if (!defined("XOOPS_UPLOAD_URL"))
		define("XOOPS_UPLOAD_URL", XOOPS_URL."/uploads");
} else {
	// index page is load xoops
	require dirname( __FILE__ ).'/../../../mainfile.php' ;
}
?>
