<?php
/*
 * XPressME - WordPress for XOOPS
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @package		module::xpress
 */
class wpInfo {
	var	$mod_dirpath;
	var	$mod_name;
	var $mod_url;

	var $xoops_Lang;
	var $wp_Lang;
	var $php_version;
	var $mysql_version;
	// The language of XOOPS is set as Key of the array. 
	// The language of WP is set as Value of the array. 
	var $wp_lang_array = array(
		'english' => 	'en_US',
		'japanese' => 	'ja',
		'ja_utf8' => 	'ja',
		'pt-br_utf8' =>	'pt_BR',
		// The key(language of XOOPS) of the following lists has not been set yet. 
		'Afrikaans' =>	'af',
		'Albanian' =>	'al',
		'Arabic' =>		'ar',
		'Bangla' =>		'bn_BD',
		'Basque' =>		'eu',
		'Belarusian' =>	'be_BY',
		'Bosnian' =>	'bs_BA',
		'Bulgarian' =>	'bg_BG',
		'Catalan' =>	'ca',
		'Chinese' =>	'zh_CN',
		'Hong Kong' =>	'zh_HK',
		'Taiwan' =>		'zh_TW',
		'Croatian' =>	'hr',
		'Czech' =>		'cs_CZ',
		'Danish' =>		'da_DK',
		'Dutch' =>		'nl_NL',
		'Esperanto' =>	'eo',
		'Estonian' =>	'et',
		'Faroese' =>	'fo',
		'Finnish' =>	'fi',
		'Galician' =>	'gl_ES',
		'Georgian' =>	'ge_GE',
		'German' =>		'de_DE',
		'Greek' =>		'el',
		'Hebrew' =>		'he_IL',
		'Hungarian' =>	'hu_HU',
		'Icelandic' =>	'is_IS',
		'Indonesian' =>	'id_ID',
		'Italian' =>	'it_IT',
		'Khmer' =>		'km_KH',
		'ko_utf8' =>	'ko_KR',
		'Latvian' =>	'lv',
		'Lithuanian' =>	'lt_LT',
		'Macedonian' =>	'mk_MK',
		'Malagasy' =>	'mg_MG',
		'Malay' =>		'ms_MY',
		'Nias' =>		'ni_ID',
		'Norwegian' =>	'nb_NO',
		'Persian' =>	'fa_IR',
		'Polish' =>		'pl_PL',
		'European Portuguese' =>	'pt_PT',
		'Romanian' =>	'ro',
		'Russian' =>	'ru_RU',
		'Serbian' =>	'sr_RS',
		'Sinhala' =>	'si_LK',
		'Slovak' =>		'sk_SK',
		'Slovenian' =>	'sl_SI',
		'Spanish' =>	'es_ES',
		'Sundanese' =>	'su_ID',
		'Swedish' =>	'sv_SE',
		'Tajik' =>		'tg',
		'Thai' =>		'th',
		'Turkish' =>	'tr',
		'Ukrainian' =>	'uk',
		'Uzbek' =>		'uz_UZ',
		'Vietnamse' =>	'vi',
		'Welsh' =>		'cy',
	);

	function wpInfo(){
		$this->__construct();
	}
	function __construct() {
		$this->mod_dirpath = dirname(dirname(__FILE__));
		$this->mod_name = basename(dirname(dirname(__FILE__)));
		$this->mod_url = XOOPS_URL . '/modules/'.$this->mod_name;
		$this->load_lang();
		$this->xoops_Lang = @$GLOBALS["xoopsConfig"]['language'];
		$this->php_version    = phpversion();
		$xoopsDB =& Database::getInstance();
		list($SV) = $xoopsDB->fetchRow($xoopsDB->query('SELECT version()'));
		$this->mysql_version = $SV;

		$this->get_wpLang();
	}
	function text_indent($text,$num = 1,$css_option='')
	{
		$ret = '';
		$px = 24 * $num;
		$ret = '<div style="padding-left:' .$px .'px;'.$css_option.'">';
		$ret .= $text . '</div>';
		return $ret;
	}
	public function load_lang()
	{
		$lang = @$GLOBALS["xoopsConfig"]['language'];

		// language file (modinfo.php)
		if( file_exists( $this->mod_dirpath .'/language/'.$lang.'/admin.php' ) ) {
			include_once $this->mod_dirpath .'/language/'.$lang.'/admin.php' ;
		} else if( file_exists(  $this->mod_dirpath .'/language/english/admin.php' ) ) {
			include_once $this->mod_dirpath .'/language/english/admin.php' ;
		}
	}
	
	public function get_php_version()
	{
		return $this->php_version;
	}
	public function get_mysql_version()
	{
		return $this->mysql_version;
	}
	public function get_wpLang($xoops_Lang = '') 
	{
		if(!empty($xoops_Lang)) $this->xoops_Lang = $xoops_Lang;
		$this->wp_Lang = $this->wp_lang_array[$this->xoops_Lang];
		if (empty($this->wp_Lang)) $this->wp_Lang =  'en_US';
		return $this->wp_Lang;
	}
	public function get_mod_image_link($file_name='') 
	{
		$link_url = '';
		if(!empty($file_name)){
			if(file_exists($this->mod_dirpath.'/images/'.$file_name)){
				$link_url = '<img alt="'.$file_name.'" src="'. $this->mod_url .'/images/'.$file_name.'" title="'.$file_name.'" align=top>';
			}
		}
		return $link_url;
	}

	function is_wpdb_installed(){
		$prefix_mod = XOOPS_DB_PREFIX .'_' . preg_replace('/wordpress/','wp',$this->mod_name) . '_';
		$xoopsDB =& Database::getInstance();
		$sql = "SHOW TABLES LIKE '$prefix_mod%'";
		if ($result = $xoopsDB->queryf($sql)){
			if($xoopsDB->getRowsNum($result))  return true;
		}
		return false;
	}
	
	public function is_wp_file_found()
	{
		if (!file_exists($this->mod_dirpath . '/wp-settings.php')){
			return false;
		}
		return true;
	}
	public function get_download_info($locale='')
	{
		$local_package = '';
		$mysql_version = preg_replace('/[^0-9.].*/', '', $this->mysql_version);
		$php_version = $this->php_version;

		if (empty($locale)) $locale = $this->wp_Lang;

/* test		
		$mysql_version='4.0.27';
		$php_version = '4.1.1';
*/
		// wprdpress original option
		// ?version=$wp_version&php=$php_version&locale=$locale&mysql=$mysql_version&local_package=$local_package";
		$option = "?php=$php_version&locale=$locale&mysql=$mysql_version&local_package=$local_package";
		$url = "http://api.wordpress.org/core/version-check/1.5/" .$option;
		$handle = @fopen($url,'r');
		if ($handle) {
			$ans = array();
			$num = 0;
			$pos = 0;
	    	while (($buffer = fgets($handle, 4096)) !== false) {
	    		$buffer = trim($buffer);
	    		if (strlen($buffer) == 0) {
	    			$num++;
	    			$pos=0;
	    		} else {
	    			$ans[$num][$pos] = $buffer;
	    			$pos++;
	    		}
	    	}
	    	if (!feof($handle)) {
	        	echo "Error: unexpected fgets() fail\n";
	    	}
	    	fclose($handle);
		}
			$ressponce = $ans[0][0];
			$site_url = $ans[0][1];
			$download_url = $ans[0][2];
			$wp_version = $ans[0][3];
			$download_lang = $ans[0][4];
//			print_r($ans);
			if (isset($ans[1])){
				$en_download_url = $ans[1][2];
			}
			$ret = $this->text_indent('(Check URL: '.$url.')',3);
			if ($locale == $download_lang){
				$ret .= $this->text_indent(sprintf(_AM_XP2_WP_INFO_1,$locale),2);
				$ret .= $this->text_indent('<a href="'.$download_url.'">' . $download_url .'</a>' ,3);
				if (!empty($en_download_url)){
					$ret .= $this->text_indent(_AM_XP2_WP_INFO_4,2);
					$ret .= $this->text_indent('<a href="'.$en_download_url .'">' . $en_download_url .'</a>' ,3);
				}
			} else {
				$ret .= $this->text_indent(sprintf(_AM_XP2_WP_INFO_2,$locale));
				$ret .= $this->text_indent(_AM_XP2_WP_INFO_3,2);
				$ret .= $this->text_indent('<a href="http://codex.wordpress.org/WordPress_in_Your_Language" target="	_blank">WordPress_in_Your_Language</a>' ,3);
				$ret .= $this->text_indent(_AM_XP2_WP_INFO_4,2);
				$ret .= $this->text_indent('<a href="'.$download_url.'">' . $download_url .'</a>' ,3);
			}
			echo $ret;
		}
	}
?>