<?php
/*
 * XPressME - WordPress for XOOPS
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @package		module::xpress
 */

/* 
 * The function to acquire only a set value without calling the XOOPS system is here.
 */

class modInfo{
	var $xoops_mainfile_path;
	var $xoops_root_path;
	var $xoops_url;
	var $xoops_trust_path;
	var $xoops_var_path;
	var $xoops_cache_path;
	var $xoops_upload_path;
	var $xoops_upload_url;
	var $xoops_db_salt;
	var $xoops_salt;
	var $xoops_db_prefix;
	var $xoops_language;
	var $module_db_prefix;
	var $db_name;
	var $db_user;
	var $db_pass;
	var $db_host;
	var $module_name;
	var $module_path;
	var $module_url;
	var $module_version;
	var $module_codename;
	var $module_id;
	var $is_impress;
	var $xoops_time_zone;
	
	function __constructor()	//for PHP5
    {
        $this->xpressInfo();
       
    }
    
    function modInfo()	//for PHP4 constructor
    {  
    	global $xoopsModule;
    	
    	$this->xoops_mainfile_path = dirname(dirname(dirname(dirname(__FILE__)))) . '/mainfile.php';
    	$this->module_path=dirname(dirname(__FILE__));
    	$this->module_name=basename($this->module_path);
		$this->xoops_root_path = XOOPS_ROOT_PATH;
		$this->xoops_trust_path = (defined('XOOPS_TRUST_PATH')) ? XOOPS_TRUST_PATH : '';
		$this->xoops_url = XOOPS_URL;
		$this->module_url = $this->xoops_url . '/modules/' . $this->module_name;
		$this->xoops_upload_path = XOOPS_UPLOAD_PATH;
		$this->xoops_upload_url = XOOPS_UPLOAD_URL;
		$this->xoops_cache_path = XOOPS_CACHE_PATH;
		$this->db_prefix = XOOPS_DB_PREFIX;
		$this->module_db_prefix = $this->xoops_db_prefix  . '_' . preg_replace('/wordpress/','wp',$this->module_name) . '_';
		$this->db_name = XOOPS_DB_NAME;
		$this->db_user = XOOPS_DB_USER;
		$this->db_pass = XOOPS_DB_PASS;
		$this->db_host = XOOPS_DB_HOST;
		$this->xoops_db_salt = (defined('XOOPS_DB_SALT')) ? XOOPS_DB_SALT : '';
		$this->xoops_salt = (defined('XOOPS_SALT')) ? XOOPS_SALT : '';
		$this->xoops_lang =  @$GLOBALS["xoopsConfig"]['language'];
		$this->module_id =! empty($xoopsModule) ? $xoopsModule->getVar('mid') : 0;
		$this->module_version = empty($xoopsModule) ? $xoopsModule->getVar('version') : '';
		$module_codename = $this->_get_module_codename();
    	// start /admin/index.php page detect
    	$php_script_name = $_SERVER['SCRIPT_NAME'];
		$php_query_string = $_SERVER['QUERY_STRING'];
		$admin_page = 	basename(dirname(dirname(__FILE__))) . '/admin/index.php';
		$is_xoops_module_admin = false;
		if (strstr($php_script_name,$admin_page) !== false) $is_xoops_module_admin = true;
		if (strstr($php_query_string,$admin_page) !== false) $is_xoops_module_admin = true;
		
		if (function_exists('date_default_timezone_get')){
			$this->xoops_time_zone = date_default_timezone_get();
		}
    }

    
    // get XPressME module virsion and codename from xoops_versions.php
    function _get_module_codename(){
    	$xoops_version_file = $this->module_path . '/xoops_version.php';
		if(file_exists($xoops_version_file)){
			$version_file = file($xoops_version_file);
			$codename_pattern = '^\s*(\$modversion\[\s*\'codename\'\s*\])\s*=\s*[\'"]([^\'"]*)[\'"]';
			for ($i = 0 ; $i <count($version_file) ; $i++){
				if (preg_match( "/$codename_pattern/", $version_file[$i] ,$c_matches )){
					return $c_matches[2];
				}
			}
		}
		return '';
    }
    
   	function is_wpdb_installed(){
   		global $xoopsDB;
		$mydirname = basename(dirname( dirname( __FILE__ ) )) ;
		$prefix_mod = XOOPS_DB_PREFIX .'_' . preg_replace('/wordpress/','wp',$mydirname) . '_';
		$sql = "SHOW TABLES LIKE '$prefix_mod%'";
		if ($result = $xoopsDB->queryf($sql)){
			if($xoopsDB->getRowsNum($result))  return true;
		}
		return false;
	}
	
	function is_writeable_mode($check_file) {
        if (!is_dir($check_file)) {
           if ( file_exists($check_file) ) {
                if (! is_writeable($check_file)) {
                    return false;
				}
            }
        } else {
            if (! is_writeable($check_file)) {
                return false;
            } else {
            	// Windows parmission check
            	$src_file = __FILE__ ;
				$newfile = $check_file . 'write_check.txt';
				if (!@copy($src_file, $newfile)) {
                	return false;
				} else {
					unlink($newfile);
				}
			}
        }
    	return true;
	}
	
}
?>