<?php
/*
 * XPressME - WordPress for XOOPS
 *
 * @copyright	XPressME Project http://www.toemon.com
 * @license		http://www.fsf.org/copyleft/gpl.html GNU public license
 * @author		toemon
 * @package		module::xpress
 */

if (defined( 'XOOPS_MAINFILE_INCLUDED')|| defined( 'XOOPS_BOOTSTRAP')) :
require_once dirname( __FILE__ ).'/langInfo_class.php' ;

class wpConfigInfoClass {
	var $xoops_db_prefix;
	var $db_prefix;
	var $db_name;
	var $db_user;
	var $db_pass;
	var $db_host;
	var $db_salt;
	var $langInfo;
	
	function __constructor()	//for PHP5
    {
        $this->wpConfigInfoClass();
    }
    
    function wpConfigInfoClass()	//for PHP4 constructor
    {
		global $xoopsModule;
		$this->xoops_db_prefix = XOOPS_DB_PREFIX . '_';
		$this->db_name = XOOPS_DB_NAME;
		$this->db_user = XOOPS_DB_USER;
		$this->db_pass = XOOPS_DB_PASS;
		$this->db_host = XOOPS_DB_HOST;
		if(!defined('XOOPS_DB_NAME') ) $this->_get_resource_db_ini();
		$this->db_prefix = $this->_get_wp_db_prefix();
		$this->db_salt = (defined('XOOPS_DB_SALT')) ? XOOPS_DB_SALT : '';
		require_once dirname( __FILE__ ).'/langInfo_class.php' ;
		$this->langInfo = new langInfoClass;
    }
	function _get_wp_db_prefix(){
		$module_name = basename(dirname(dirname(__FILE__)));
    	$module_db_prefix = $this->xoops_db_prefix . preg_replace('/wordpress/','wp',$module_name) . '_';
    	return $module_db_prefix;
	}

	// XOOPS3 doesn't define the DB connection information in the constant.
    function _get_resource_db_ini(){
		if(!defined('XOOPS_VAR_PATH') ) return;
		$def_file = XOOPS_VAR_PATH . '/etc/resource.db.ini.php';
		if(! file_exists($def_file)) return;
		$array_file = file($def_file);
		foreach ($array_file as $line){
			if (preg_match('/^\s*dbname\s*=\s*[\'"](.*)[\'"]/' ,$line,$matchs))
				$this->db_name = $matchs[1];
			if (preg_match('/^\s*host\s*=\s*[\'"](.*)[\'"]/' ,$line,$matchs))
				$this->db_host = $matchs[1];
			if (preg_match('/^\s*username\s*=\s*[\'"](.*)[\'"]/' ,$line,$matchs))
				$this->db_user = $matchs[1];
			if (preg_match('/^\s*password\s*=\s*[\'"](.*)[\'"]/' ,$line,$matchs))
				$this->db_pass = $matchs[1];
			if (preg_match('/^\s*prefix\s*=\s*[\'"](.*)[\'"]/' ,$line,$matchs))
				$this->xoops_db_prefix = $matchs[1].'_';
		}
	}
	
	function get_xoops_db_prefix(){
		return $this->xoops_db_prefix;
	}
	function get_db_prefix($module_dirname){
		if (empty($module_dirname)){
			return $this->db_prefix;
		} else {
    		$module_db_prefix = $this->xoops_db_prefix . preg_replace('/wordpress/','wp',$module_dirname) . '_';
    		return $module_db_prefix;		
		}
	}
	function get_wp_db_prefix(){
		return $this->db_prefix;
	}
	function get_db_name(){
		return $this->db_name;
	}
	function get_db_user(){
		return $this->db_user;
	}
	function get_db_pass(){
		return $this->db_pass;
	}
	function get_db_host(){
		return $this->db_host;
	}
	function get_db_salt(){
		return $this->db_salt;
	}
	function get_wpLang($xoops_lang=''){
		return $this->langInfo->get_wpLang($xoops_lang);
	}
}
endif;
?>