<?php
// xoops db
function get_xpress_dir_path()
{
	return ABSPATH;
}

function get_xpress_dir_name()
{
	return basename(ABSPATH);
}

function get_wp_prefix_only()
{
	$dir_name = get_xpress_dir_name();
	$prefix = $dir_name;
	if ($prefix == 'wordpress') $prefix = 'wp';
	
	$prefix = $prefix . '_';
	return $prefix;
}

function get_xoops_prefix()
{
	global $xoops_config;
	$ret =$xoops_config->xoops_db_prefix . '_';
	return $ret;
}
function get_wp_prefix()
{
	$prefix = get_xoops_prefix() . get_wp_prefix_only();
	return $prefix;
}

function get_xpress_modid()
{
	global $xoops_db;
	
	$modulename = get_xpress_dir_name();	
	$sql = "SELECT mid FROM " . get_xoops_prefix() . "modules WHERE dirname = '$modulename'";
	$mid = $xoops_db->get_var($sql);
	return $mid;	
}

function get_xpress_db_version()
{
	include get_xpress_dir_path() . '/wp-includes/version.php';
	return $wp_db_version;
}

function is_block_cache_found($block_name)
{
	global $xoops_config;
	$mydirname = get_xpress_dir_name();

	if(defined('XOOPS_ROOT_PATH')){
		$cache_dir = XOOPS_ROOT_PATH . '/cache/';
	} else {
		$cache_dir = $xoops_config->xoops_root_path . '/cache/';
	}
	$xml_name = $block_name . '.xml';

    $filename = $cache_dir .$mydirname . '_' . $xml_name;
	$cache_time = 0;
//        if (file_exists($filename) && ((time() - filemtime($filename)) < $cache_time)) {
    if (file_exists($filename)) {
        return true;
        } else {
		return false;
	}
}


//When there is no block cash, and an optional block is different, false is returned.
function is_block_cache_normal()
{
	global $xoops_config;
	global $xoops_db;
	$mid = get_xpress_modid();
	$sql = "SELECT bid,options,func_file FROM " . get_xoops_prefix() . "newblocks WHERE mid = $mid ";
	$blocks = $xoops_db->get_results($sql);
	$mydirname = get_xpress_dir_name();
	require_once get_xpress_dir_path() . '/include/xpress_block_render.php';

	foreach($blocks as $block){
		$func_file = $block->func_file;
		$call_theme_function_name = str_replace(".php", "", $func_file);
		$inc_theme_file_name = str_replace(".php", "", $func_file) . '_theme.php';
		$cache_title = str_replace(".php", "", $func_file);
		$blockID = $block->bid;
		$options = explode("|", $block->options);
		
		if (!is_block_cache_found($cache_title . $blockID)) return false;
		$xml = xpress_block_cache_read($mydirname,$cache_title. $blockID);
		$options = '';
		$options = @$xml['block']['options'];
		if( strcmp($options,$block->options) != 0 ) return false;
	}
	return true;
}


function block_cache_refresh()
{
	global $xoops_db;
	$mid = get_xpress_modid();
	$sql = "SELECT bid,options,func_file FROM " . get_xoops_prefix() . "newblocks WHERE mid = $mid";
	$blocks = $xoops_db->get_results($sql);
	$mydirname = get_xpress_dir_name();
	require_once get_xpress_dir_path() . '/include/xpress_block_render.php';


	foreach($blocks as $block){
		$func_file = $block->func_file;
		$call_theme_function_name = str_replace(".php", "", $func_file);
		$inc_theme_file_name = str_replace(".php", "", $func_file) . '_theme.php';
		$cache_title = str_replace(".php", "", $func_file);
		$blockID = $block->bid;
		$options = explode("|", $block->options);
					
		$block_theme_file = get_block_file_path($mydirname,$inc_theme_file_name);
		require_once $block_theme_file;
		$block_render = $call_theme_function_name($options);		//The block name and the called function name should be assumed to be the same name. 			
		$xml['block'] = $block_render;
		$xml['block']['options'] = $block->options;
		xpress_block_cache_write($mydirname,$cache_title. $blockID, $xml);
	}
}

?>